package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps cfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps = CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps.builder()
 *         .localGatewayRouteTableId("localGatewayRouteTableId")
 *         .localGatewayVirtualInterfaceGroupId("localGatewayVirtualInterfaceGroupId")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:38.781Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the local gateway route table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocalGatewayRouteTableId();

    /**
     * The ID of the virtual interface group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLocalGatewayVirtualInterfaceGroupId();

    /**
     * The tags assigned to the association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps> {
        java.lang.String localGatewayRouteTableId;
        java.lang.String localGatewayVirtualInterfaceGroupId;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps#getLocalGatewayRouteTableId}
         * @param localGatewayRouteTableId The ID of the local gateway route table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localGatewayRouteTableId(java.lang.String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps#getLocalGatewayVirtualInterfaceGroupId}
         * @param localGatewayVirtualInterfaceGroupId The ID of the virtual interface group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localGatewayVirtualInterfaceGroupId(java.lang.String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps#getTags}
         * @param tags The tags assigned to the association.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps {
        private final java.lang.String localGatewayRouteTableId;
        private final java.lang.String localGatewayVirtualInterfaceGroupId;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.localGatewayRouteTableId = software.amazon.jsii.Kernel.get(this, "localGatewayRouteTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.localGatewayVirtualInterfaceGroupId = software.amazon.jsii.Kernel.get(this, "localGatewayVirtualInterfaceGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.localGatewayRouteTableId = java.util.Objects.requireNonNull(builder.localGatewayRouteTableId, "localGatewayRouteTableId is required");
            this.localGatewayVirtualInterfaceGroupId = java.util.Objects.requireNonNull(builder.localGatewayVirtualInterfaceGroupId, "localGatewayVirtualInterfaceGroupId is required");
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getLocalGatewayRouteTableId() {
            return this.localGatewayRouteTableId;
        }

        @Override
        public final java.lang.String getLocalGatewayVirtualInterfaceGroupId() {
            return this.localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("localGatewayRouteTableId", om.valueToTree(this.getLocalGatewayRouteTableId()));
            data.set("localGatewayVirtualInterfaceGroupId", om.valueToTree(this.getLocalGatewayVirtualInterfaceGroupId()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps.Jsii$Proxy that = (CfnLocalGatewayRouteTableVirtualInterfaceGroupAssociationProps.Jsii$Proxy) o;

            if (!localGatewayRouteTableId.equals(that.localGatewayRouteTableId)) return false;
            if (!localGatewayVirtualInterfaceGroupId.equals(that.localGatewayVirtualInterfaceGroupId)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.localGatewayRouteTableId.hashCode();
            result = 31 * result + (this.localGatewayVirtualInterfaceGroupId.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
