package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation <code>AWS::EC2::VerifiedAccessTrustProvider</code>.
 * <p>
 * Describes a Verified Access trust provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVerifiedAccessTrustProvider cfnVerifiedAccessTrustProvider = CfnVerifiedAccessTrustProvider.Builder.create(this, "MyCfnVerifiedAccessTrustProvider")
 *         .policyReferenceName("policyReferenceName")
 *         .trustProviderType("trustProviderType")
 *         // the properties below are optional
 *         .description("description")
 *         .deviceOptions(DeviceOptionsProperty.builder()
 *                 .tenantId("tenantId")
 *                 .build())
 *         .deviceTrustProviderType("deviceTrustProviderType")
 *         .oidcOptions(OidcOptionsProperty.builder()
 *                 .authorizationEndpoint("authorizationEndpoint")
 *                 .clientId("clientId")
 *                 .clientSecret("clientSecret")
 *                 .issuer("issuer")
 *                 .scope("scope")
 *                 .tokenEndpoint("tokenEndpoint")
 *                 .userInfoEndpoint("userInfoEndpoint")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userTrustProviderType("userTrustProviderType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.84.0 (build 5404dcf)", date = "2023-06-19T16:30:39.238Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVerifiedAccessTrustProvider")
public class CfnVerifiedAccessTrustProvider extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnVerifiedAccessTrustProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVerifiedAccessTrustProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::EC2::VerifiedAccessTrustProvider</code>.
     * <p>
     * @param scope <ul><li>scope in which this resource is defined.</li></ul> This parameter is required.
     * @param id <ul><li>scoped id of the resource.</li></ul> This parameter is required.
     * @param props <ul><li>resource properties.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVerifiedAccessTrustProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector <ul><li>tree inspector to collect and process attributes.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The creation time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The last updated time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Verified Access trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVerifiedAccessTrustProviderId() {
        return software.amazon.jsii.Kernel.get(this, "attrVerifiedAccessTrustProviderId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The identifier to be used when working with policy rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyReferenceName() {
        return software.amazon.jsii.Kernel.get(this, "policyReferenceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier to be used when working with policy rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyReferenceName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policyReferenceName", java.util.Objects.requireNonNull(value, "policyReferenceName is required"));
    }

    /**
     * The type of Verified Access trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTrustProviderType() {
        return software.amazon.jsii.Kernel.get(this, "trustProviderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of Verified Access trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrustProviderType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "trustProviderType", java.util.Objects.requireNonNull(value, "trustProviderType is required"));
    }

    /**
     * A description for the AWS Verified Access trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the AWS Verified Access trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The options for device-identity trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeviceOptions() {
        return software.amazon.jsii.Kernel.get(this, "deviceOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The options for device-identity trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeviceOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deviceOptions", value);
    }

    /**
     * The options for device-identity trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeviceOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider.DeviceOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "deviceOptions", value);
    }

    /**
     * The type of device-based trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeviceTrustProviderType() {
        return software.amazon.jsii.Kernel.get(this, "deviceTrustProviderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of device-based trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeviceTrustProviderType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deviceTrustProviderType", value);
    }

    /**
     * The options for an OpenID Connect-compatible user-identity trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOidcOptions() {
        return software.amazon.jsii.Kernel.get(this, "oidcOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The options for an OpenID Connect-compatible user-identity trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOidcOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "oidcOptions", value);
    }

    /**
     * The options for an OpenID Connect-compatible user-identity trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOidcOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider.OidcOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "oidcOptions", value);
    }

    /**
     * The type of user-based trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUserTrustProviderType() {
        return software.amazon.jsii.Kernel.get(this, "userTrustProviderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of user-based trust provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserTrustProviderType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userTrustProviderType", value);
    }
    /**
     * Describes the options for an AWS Verified Access device-identity based trust provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * DeviceOptionsProperty deviceOptionsProperty = DeviceOptionsProperty.builder()
     *         .tenantId("tenantId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVerifiedAccessTrustProvider.DeviceOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DeviceOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeviceOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the tenant application with the device-identity provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTenantId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeviceOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeviceOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeviceOptionsProperty> {
            java.lang.String tenantId;

            /**
             * Sets the value of {@link DeviceOptionsProperty#getTenantId}
             * @param tenantId The ID of the tenant application with the device-identity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tenantId(java.lang.String tenantId) {
                this.tenantId = tenantId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeviceOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeviceOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeviceOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceOptionsProperty {
            private final java.lang.String tenantId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tenantId = software.amazon.jsii.Kernel.get(this, "tenantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tenantId = builder.tenantId;
            }

            @Override
            public final java.lang.String getTenantId() {
                return this.tenantId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTenantId() != null) {
                    data.set("tenantId", om.valueToTree(this.getTenantId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVerifiedAccessTrustProvider.DeviceOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeviceOptionsProperty.Jsii$Proxy that = (DeviceOptionsProperty.Jsii$Proxy) o;

                return this.tenantId != null ? this.tenantId.equals(that.tenantId) : that.tenantId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes the options for an OpenID Connect-compatible user-identity trust provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * OidcOptionsProperty oidcOptionsProperty = OidcOptionsProperty.builder()
     *         .authorizationEndpoint("authorizationEndpoint")
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         .issuer("issuer")
     *         .scope("scope")
     *         .tokenEndpoint("tokenEndpoint")
     *         .userInfoEndpoint("userInfoEndpoint")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVerifiedAccessTrustProvider.OidcOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(OidcOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OidcOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The OIDC authorization endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationEndpoint() {
            return null;
        }

        /**
         * The client identifier.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
            return null;
        }

        /**
         * The client secret.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientSecret() {
            return null;
        }

        /**
         * The OIDC issuer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIssuer() {
            return null;
        }

        /**
         * The OpenID Connect (OIDC) scope specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
            return null;
        }

        /**
         * The OIDC token endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTokenEndpoint() {
            return null;
        }

        /**
         * The OIDC user info endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserInfoEndpoint() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OidcOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OidcOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OidcOptionsProperty> {
            java.lang.String authorizationEndpoint;
            java.lang.String clientId;
            java.lang.String clientSecret;
            java.lang.String issuer;
            java.lang.String scope;
            java.lang.String tokenEndpoint;
            java.lang.String userInfoEndpoint;

            /**
             * Sets the value of {@link OidcOptionsProperty#getAuthorizationEndpoint}
             * @param authorizationEndpoint The OIDC authorization endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationEndpoint(java.lang.String authorizationEndpoint) {
                this.authorizationEndpoint = authorizationEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link OidcOptionsProperty#getClientId}
             * @param clientId The client identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link OidcOptionsProperty#getClientSecret}
             * @param clientSecret The client secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link OidcOptionsProperty#getIssuer}
             * @param issuer The OIDC issuer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuer(java.lang.String issuer) {
                this.issuer = issuer;
                return this;
            }

            /**
             * Sets the value of {@link OidcOptionsProperty#getScope}
             * @param scope The OpenID Connect (OIDC) scope specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Sets the value of {@link OidcOptionsProperty#getTokenEndpoint}
             * @param tokenEndpoint The OIDC token endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenEndpoint(java.lang.String tokenEndpoint) {
                this.tokenEndpoint = tokenEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link OidcOptionsProperty#getUserInfoEndpoint}
             * @param userInfoEndpoint The OIDC user info endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userInfoEndpoint(java.lang.String userInfoEndpoint) {
                this.userInfoEndpoint = userInfoEndpoint;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OidcOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OidcOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OidcOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OidcOptionsProperty {
            private final java.lang.String authorizationEndpoint;
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.String issuer;
            private final java.lang.String scope;
            private final java.lang.String tokenEndpoint;
            private final java.lang.String userInfoEndpoint;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizationEndpoint = software.amazon.jsii.Kernel.get(this, "authorizationEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.issuer = software.amazon.jsii.Kernel.get(this, "issuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tokenEndpoint = software.amazon.jsii.Kernel.get(this, "tokenEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userInfoEndpoint = software.amazon.jsii.Kernel.get(this, "userInfoEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationEndpoint = builder.authorizationEndpoint;
                this.clientId = builder.clientId;
                this.clientSecret = builder.clientSecret;
                this.issuer = builder.issuer;
                this.scope = builder.scope;
                this.tokenEndpoint = builder.tokenEndpoint;
                this.userInfoEndpoint = builder.userInfoEndpoint;
            }

            @Override
            public final java.lang.String getAuthorizationEndpoint() {
                return this.authorizationEndpoint;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.String getIssuer() {
                return this.issuer;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            public final java.lang.String getTokenEndpoint() {
                return this.tokenEndpoint;
            }

            @Override
            public final java.lang.String getUserInfoEndpoint() {
                return this.userInfoEndpoint;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthorizationEndpoint() != null) {
                    data.set("authorizationEndpoint", om.valueToTree(this.getAuthorizationEndpoint()));
                }
                if (this.getClientId() != null) {
                    data.set("clientId", om.valueToTree(this.getClientId()));
                }
                if (this.getClientSecret() != null) {
                    data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                }
                if (this.getIssuer() != null) {
                    data.set("issuer", om.valueToTree(this.getIssuer()));
                }
                if (this.getScope() != null) {
                    data.set("scope", om.valueToTree(this.getScope()));
                }
                if (this.getTokenEndpoint() != null) {
                    data.set("tokenEndpoint", om.valueToTree(this.getTokenEndpoint()));
                }
                if (this.getUserInfoEndpoint() != null) {
                    data.set("userInfoEndpoint", om.valueToTree(this.getUserInfoEndpoint()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVerifiedAccessTrustProvider.OidcOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OidcOptionsProperty.Jsii$Proxy that = (OidcOptionsProperty.Jsii$Proxy) o;

                if (this.authorizationEndpoint != null ? !this.authorizationEndpoint.equals(that.authorizationEndpoint) : that.authorizationEndpoint != null) return false;
                if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) return false;
                if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) return false;
                if (this.issuer != null ? !this.issuer.equals(that.issuer) : that.issuer != null) return false;
                if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
                if (this.tokenEndpoint != null ? !this.tokenEndpoint.equals(that.tokenEndpoint) : that.tokenEndpoint != null) return false;
                return this.userInfoEndpoint != null ? this.userInfoEndpoint.equals(that.userInfoEndpoint) : that.userInfoEndpoint == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizationEndpoint != null ? this.authorizationEndpoint.hashCode() : 0;
                result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
                result = 31 * result + (this.clientSecret != null ? this.clientSecret.hashCode() : 0);
                result = 31 * result + (this.issuer != null ? this.issuer.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                result = 31 * result + (this.tokenEndpoint != null ? this.tokenEndpoint.hashCode() : 0);
                result = 31 * result + (this.userInfoEndpoint != null ? this.userInfoEndpoint.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope <ul><li>scope in which this resource is defined.</li></ul> This parameter is required.
         * @param id <ul><li>scoped id of the resource.</li></ul> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProviderProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProviderProps.Builder();
        }

        /**
         * The identifier to be used when working with policy rules.
         * <p>
         * @return {@code this}
         * @param policyReferenceName The identifier to be used when working with policy rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyReferenceName(final java.lang.String policyReferenceName) {
            this.props.policyReferenceName(policyReferenceName);
            return this;
        }

        /**
         * The type of Verified Access trust provider.
         * <p>
         * @return {@code this}
         * @param trustProviderType The type of Verified Access trust provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustProviderType(final java.lang.String trustProviderType) {
            this.props.trustProviderType(trustProviderType);
            return this;
        }

        /**
         * A description for the AWS Verified Access trust provider.
         * <p>
         * @return {@code this}
         * @param description A description for the AWS Verified Access trust provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The options for device-identity trust provider.
         * <p>
         * @return {@code this}
         * @param deviceOptions The options for device-identity trust provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceOptions(final software.amazon.awscdk.core.IResolvable deviceOptions) {
            this.props.deviceOptions(deviceOptions);
            return this;
        }
        /**
         * The options for device-identity trust provider.
         * <p>
         * @return {@code this}
         * @param deviceOptions The options for device-identity trust provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceOptions(final software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider.DeviceOptionsProperty deviceOptions) {
            this.props.deviceOptions(deviceOptions);
            return this;
        }

        /**
         * The type of device-based trust provider.
         * <p>
         * @return {@code this}
         * @param deviceTrustProviderType The type of device-based trust provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceTrustProviderType(final java.lang.String deviceTrustProviderType) {
            this.props.deviceTrustProviderType(deviceTrustProviderType);
            return this;
        }

        /**
         * The options for an OpenID Connect-compatible user-identity trust provider.
         * <p>
         * @return {@code this}
         * @param oidcOptions The options for an OpenID Connect-compatible user-identity trust provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oidcOptions(final software.amazon.awscdk.core.IResolvable oidcOptions) {
            this.props.oidcOptions(oidcOptions);
            return this;
        }
        /**
         * The options for an OpenID Connect-compatible user-identity trust provider.
         * <p>
         * @return {@code this}
         * @param oidcOptions The options for an OpenID Connect-compatible user-identity trust provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder oidcOptions(final software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider.OidcOptionsProperty oidcOptions) {
            this.props.oidcOptions(oidcOptions);
            return this;
        }

        /**
         * The tags.
         * <p>
         * @return {@code this}
         * @param tags The tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The type of user-based trust provider.
         * <p>
         * @return {@code this}
         * @param userTrustProviderType The type of user-based trust provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userTrustProviderType(final java.lang.String userTrustProviderType) {
            this.props.userTrustProviderType(userTrustProviderType);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider build() {
            return new software.amazon.awscdk.services.ec2.CfnVerifiedAccessTrustProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
