package software.amazon.awscdk.services.ec2;

/**
 * This represents a single EC2 instance.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.1 (build 9ff44cb)", date = "2020-01-16T01:51:39.239Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.Instance")
public class Instance extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.IInstance {

    protected Instance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Instance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Instance(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.InstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add the security group to the instance.
     * <p>
     * @param securityGroup : The security group to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        this.jsiiCall("addSecurityGroup", Void.class, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required") });
    }

    /**
     * Adds a statement to the IAM role assumed by the instance.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToRolePolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("addToRolePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Add command to the startup script of the instance.
     * <p>
     * The command must be in the scripting language supported by the instance's OS (i.e. Linux/Windows).
     * <p>
     * @param commands This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addUserData(final java.lang.String... commands) {
        this.jsiiCall("addUserData", Void.class, java.util.Arrays.<Object>stream(commands).toArray(Object[]::new));
    }

    /**
     * Allows specify security group connections for the instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * the underlying instance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.CfnInstance getInstance() {
        return this.jsiiGet("instance", software.amazon.awscdk.services.ec2.CfnInstance.class);
    }

    /**
     * The availability zone the instance was launched in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getInstanceAvailabilityZone() {
        return this.jsiiGet("instanceAvailabilityZone", java.lang.String.class);
    }

    /**
     * The instance's ID.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getInstanceId() {
        return this.jsiiGet("instanceId", java.lang.String.class);
    }

    /**
     * Private DNS name for this instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getInstancePrivateDnsName() {
        return this.jsiiGet("instancePrivateDnsName", java.lang.String.class);
    }

    /**
     * Private IP for this instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getInstancePrivateIp() {
        return this.jsiiGet("instancePrivateIp", java.lang.String.class);
    }

    /**
     * Publicly-routable DNS name for this instance.
     * <p>
     * (May be an empty string if the instance does not have a public name).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getInstancePublicDnsName() {
        return this.jsiiGet("instancePublicDnsName", java.lang.String.class);
    }

    /**
     * Publicly-routable IP  address for this instance.
     * <p>
     * (May be an empty string if the instance does not have a public IP).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getInstancePublicIp() {
        return this.jsiiGet("instancePublicIp", java.lang.String.class);
    }

    /**
     * The type of OS the instance is running.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.OperatingSystemType getOsType() {
        return this.jsiiGet("osType", software.amazon.awscdk.services.ec2.OperatingSystemType.class);
    }

    /**
     * The IAM role assumed by the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.iam.IRole getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * UserData for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.UserData getUserData() {
        return this.jsiiGet("userData", software.amazon.awscdk.services.ec2.UserData.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.Instance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.InstanceProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.InstanceProps.Builder();
        }

        /**
         * Type of instance to launch.
         * <p>
         * @return {@code this}
         * @param instanceType Type of instance to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * AMI to launch.
         * <p>
         * @return {@code this}
         * @param machineImage AMI to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(final software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        /**
         * VPC to launch the instance in.
         * <p>
         * @return {@code this}
         * @param vpc VPC to launch the instance in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Whether the instance could initiate connections to anywhere by default.
         * <p>
         * This property is only used when you do not provide a security group.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllOutbound Whether the instance could initiate connections to anywhere by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * In which AZ to place the instance within the VPC.
         * <p>
         * Default: - Random zone.
         * <p>
         * @return {@code this}
         * @param availabilityZone In which AZ to place the instance within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         * <p>
         * Each instance that is launched has an associated root device volume,
         * either an Amazon EBS volume or an instance store volume.
         * You can use block device mappings to specify additional EBS volumes or
         * instance store volumes to attach to an instance when it is launched.
         * <p>
         * Default: - Uses the block device mapping of the AMI
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDevices(final java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices) {
            this.props.blockDevices(blockDevices);
            return this;
        }

        /**
         * The name of the instance.
         * <p>
         * Default: - CDK generated name
         * <p>
         * @return {@code this}
         * @param instanceName The name of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceName(final java.lang.String instanceName) {
            this.props.instanceName(instanceName);
            return this;
        }

        /**
         * Name of SSH keypair to grant access to instance.
         * <p>
         * Default: - No SSH access will be possible.
         * <p>
         * @return {@code this}
         * @param keyName Name of SSH keypair to grant access to instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(final java.lang.String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        /**
         * Defines a private IP address to associate with an instance.
         * <p>
         * Private IP should be available within the VPC that the instance is build within.
         * <p>
         * Default: - no association
         * <p>
         * @return {@code this}
         * @param privateIpAddress Defines a private IP address to associate with an instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateIpAddress(final java.lang.String privateIpAddress) {
            this.props.privateIpAddress(privateIpAddress);
            return this;
        }

        /**
         * The length of time to wait for the resourceSignalCount.
         * <p>
         * The maximum value is 43200 (12 hours).
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param resourceSignalTimeout The length of time to wait for the resourceSignalCount. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSignalTimeout(final software.amazon.awscdk.core.Duration resourceSignalTimeout) {
            this.props.resourceSignalTimeout(resourceSignalTimeout);
            return this;
        }

        /**
         * An IAM role to associate with the instance profile assigned to this Auto Scaling Group.
         * <p>
         * The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
         * <p>
         * Default: - A role will automatically be created, it can be accessed via the `role` property
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated. See https://github.com/aws/jsii/issues/826
         * Role role = new Role(this, "MyRole", new RoleProps()
         *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com")));}</pre></blockquote>
         * <p>
         * @return {@code this}
         * @param role An IAM role to associate with the instance profile assigned to this Auto Scaling Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Security Group to assign to this instance.
         * <p>
         * Default: - create new security group
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group to assign to this instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * Specifies whether to enable an instance launched in a VPC to perform NAT.
         * <p>
         * This controls whether source/destination checking is enabled on the instance.
         * A value of true means that checking is enabled, and false means that checking is disabled.
         * The value must be false for the instance to perform NAT.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param sourceDestCheck Specifies whether to enable an instance launched in a VPC to perform NAT. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDestCheck(final java.lang.Boolean sourceDestCheck) {
            this.props.sourceDestCheck(sourceDestCheck);
            return this;
        }

        /**
         * Specific UserData to use.
         * <p>
         * The UserData may still be mutated after creation.
         * <p>
         * Default: - A UserData object appropriate for the MachineImage's
         * Operating System is created.
         * <p>
         * @return {@code this}
         * @param userData Specific UserData to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props.userData(userData);
            return this;
        }

        /**
         * Where to place the instance within the VPC.
         * <p>
         * Default: - Private subnets.
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the instance within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.Instance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.Instance build() {
            return new software.amazon.awscdk.services.ec2.Instance(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
