package software.amazon.awscdk.services.ec2;

/**
 * Creates an Amazon EC2 security group within a VPC.
 * <p>
 * Security Groups act like a firewall with a set of rules, and are associated
 * with any AWS resource that has or creates Elastic Network Interfaces (ENIs).
 * A typical example of a resource that has a security group is an Instance (or
 * Auto Scaling Group of instances)
 * <p>
 * If you are defining new infrastructure in CDK, there is a good chance you
 * won't have to interact with this class at all. Like IAM Roles, Security
 * Groups need to exist to control access between AWS resources, but CDK will
 * automatically generate and populate them with least-privilege permissions
 * for you so you can concentrate on your business logic.
 * <p>
 * All Constructs that require Security Groups will create one for you if you
 * don't specify one at construction. After construction, you can selectively
 * allow connections to and between constructs via--for example-- the <code>instance.connections</code>
 * object. Think of it as "allowing connections to your instance", rather than
 * "adding ingress rules a security group". See the <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/aws-ec2-readme.html#allowing-connections">Allowing
 * Connections</a>
 * section in the library documentation for examples.
 * <p>
 * Direct manipulation of the Security Group through <code>addIngressRule</code> and
 * <code>addEgressRule</code> is possible, but mutation through the <code>.connections</code> object
 * is recommended. If you peer two constructs with security groups this way,
 * appropriate rules will be created in both.
 * <p>
 * If you have an existing security group you want to use in your CDK application,
 * you would import it like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var securityGroup = SecurityGroup.fromSecurityGroupId(this, "SG", "sg-12345", Map.of(
 *         "mutable", false));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.1 (build 9ff44cb)", date = "2020-01-16T01:51:39.248Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SecurityGroup")
public class SecurityGroup extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.ec2.ISecurityGroup {

    protected SecurityGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecurityGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SecurityGroup(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.SecurityGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing security group into this app.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param securityGroupId This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.ISecurityGroup fromSecurityGroupId(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String securityGroupId, final software.amazon.awscdk.services.ec2.SecurityGroupImportOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SecurityGroup.class, "fromSecurityGroupId", software.amazon.awscdk.services.ec2.ISecurityGroup.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(securityGroupId, "securityGroupId is required"), options });
    }

    /**
     * Import an existing security group into this app.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param securityGroupId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.ec2.ISecurityGroup fromSecurityGroupId(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String securityGroupId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SecurityGroup.class, "fromSecurityGroupId", software.amazon.awscdk.services.ec2.ISecurityGroup.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(securityGroupId, "securityGroupId is required") });
    }

    /**
     * Return whether the indicated object is a security group.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.Boolean isSecurityGroup(final java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.SecurityGroup.class, "isSecurityGroup", java.lang.Boolean.class, new Object[] { x });
    }

    /**
     * Add an egress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     * @param remoteRule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addEgressRule(final software.amazon.awscdk.services.ec2.IPeer peer, final software.amazon.awscdk.services.ec2.Port connection, final java.lang.String description, final java.lang.Boolean remoteRule) {
        this.jsiiCall("addEgressRule", Void.class, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description, remoteRule });
    }

    /**
     * Add an egress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addEgressRule(final software.amazon.awscdk.services.ec2.IPeer peer, final software.amazon.awscdk.services.ec2.Port connection, final java.lang.String description) {
        this.jsiiCall("addEgressRule", Void.class, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description });
    }

    /**
     * Add an egress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addEgressRule(final software.amazon.awscdk.services.ec2.IPeer peer, final software.amazon.awscdk.services.ec2.Port connection) {
        this.jsiiCall("addEgressRule", Void.class, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required") });
    }

    /**
     * Add an ingress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     * @param remoteRule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addIngressRule(final software.amazon.awscdk.services.ec2.IPeer peer, final software.amazon.awscdk.services.ec2.Port connection, final java.lang.String description, final java.lang.Boolean remoteRule) {
        this.jsiiCall("addIngressRule", Void.class, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description, remoteRule });
    }

    /**
     * Add an ingress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addIngressRule(final software.amazon.awscdk.services.ec2.IPeer peer, final software.amazon.awscdk.services.ec2.Port connection, final java.lang.String description) {
        this.jsiiCall("addIngressRule", Void.class, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description });
    }

    /**
     * Add an ingress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addIngressRule(final software.amazon.awscdk.services.ec2.IPeer peer, final software.amazon.awscdk.services.ec2.Port connection) {
        this.jsiiCall("addIngressRule", Void.class, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required") });
    }

    /**
     * Produce the egress rule JSON for the given connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.Object toEgressRuleConfig() {
        return this.jsiiCall("toEgressRuleConfig", java.lang.Object.class);
    }

    /**
     * Produce the ingress rule JSON for the given connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public java.lang.Object toIngressRuleConfig() {
        return this.jsiiCall("toIngressRuleConfig", java.lang.Object.class);
    }

    /**
     * Whether the SecurityGroup has been configured to allow all outbound traffic.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Boolean getAllowAllOutbound() {
        return this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
    }

    /**
     * Whether the rule can be inlined into a SecurityGroup or not.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Boolean getCanInlineRule() {
        return this.jsiiGet("canInlineRule", java.lang.Boolean.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * The ID of the security group.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getSecurityGroupId() {
        return this.jsiiGet("securityGroupId", java.lang.String.class);
    }

    /**
     * An attribute that represents the security group name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getSecurityGroupName() {
        return this.jsiiGet("securityGroupName", java.lang.String.class);
    }

    /**
     * The VPC ID this security group is part of.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getSecurityGroupVpcId() {
        return this.jsiiGet("securityGroupVpcId", java.lang.String.class);
    }

    /**
     * A unique identifier for this connection peer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getUniqueId() {
        return this.jsiiGet("uniqueId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.Port getDefaultPort() {
        return this.jsiiGet("defaultPort", software.amazon.awscdk.services.ec2.Port.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.SecurityGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.SecurityGroupProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.SecurityGroupProps.Builder();
        }

        /**
         * The VPC in which to create the security group.
         * <p>
         * @return {@code this}
         * @param vpc The VPC in which to create the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Whether to allow all outbound traffic by default.
         * <p>
         * If this is set to true, there will only be a single egress rule which allows all
         * outbound traffic. If this is set to false, no outbound traffic will be allowed by
         * default and all egress traffic must be explicitly authorized.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllOutbound Whether to allow all outbound traffic by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * A description of the security group.
         * <p>
         * Default: The default name will be the construct's CDK path.
         * <p>
         * @return {@code this}
         * @param description A description of the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the security group.
         * <p>
         * For valid values, see the GroupName
         * parameter of the CreateSecurityGroup action in the Amazon EC2 API
         * Reference.
         * <p>
         * It is not recommended to use an explicit group name.
         * <p>
         * Default: If you don't specify a GroupName, AWS CloudFormation generates a
         * unique physical ID and uses that ID for the group name.
         * <p>
         * @return {@code this}
         * @param securityGroupName The name of the security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupName(final java.lang.String securityGroupName) {
            this.props.securityGroupName(securityGroupName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.SecurityGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.SecurityGroup build() {
            return new software.amazon.awscdk.services.ec2.SecurityGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
