package software.amazon.awscdk.services.ec2;

/**
 * Options to add an interface endpoint to a VPC.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.2 (build 4370756)", date = "2020-01-23T18:16:46.598Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InterfaceVpcEndpointOptions")
@software.amazon.jsii.Jsii.Proxy(InterfaceVpcEndpointOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InterfaceVpcEndpointOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The service to use for this interface VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService getService();

    /**
     * Whether to automatically allow VPC traffic to the endpoint.
     * <p>
     * If enabled, all traffic to the endpoint from within the VPC will be
     * automatically allowed. This is done based on the VPC's CIDR range.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getOpen() {
        return null;
    }

    /**
     * Whether to associate a private hosted zone with the specified VPC.
     * <p>
     * This
     * allows you to make requests to the service using its default DNS hostname.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getPrivateDnsEnabled() {
        return null;
    }

    /**
     * The security groups to associate with this interface VPC endpoint.
     * <p>
     * Default: - a new security group is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * The subnets in which to create an endpoint network interface.
     * <p>
     * At most one
     * per availability zone.
     * <p>
     * Default: - private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.ec2.SubnetSelection getSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InterfaceVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InterfaceVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service;
        private java.lang.Boolean open;
        private java.lang.Boolean privateDnsEnabled;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnets;

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getService}
         * @param service The service to use for this interface VPC endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getOpen}
         * @param open Whether to automatically allow VPC traffic to the endpoint.
         *             If enabled, all traffic to the endpoint from within the VPC will be
         *             automatically allowed. This is done based on the VPC's CIDR range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder open(java.lang.Boolean open) {
            this.open = open;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getPrivateDnsEnabled}
         * @param privateDnsEnabled Whether to associate a private hosted zone with the specified VPC.
         *                          This
         *                          allows you to make requests to the service using its default DNS hostname.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsEnabled(java.lang.Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getSecurityGroups}
         * @param securityGroups The security groups to associate with this interface VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getSubnets}
         * @param subnets The subnets in which to create an endpoint network interface.
         *                At most one
         *                per availability zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(software.amazon.awscdk.services.ec2.SubnetSelection subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InterfaceVpcEndpointOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public InterfaceVpcEndpointOptions build() {
            return new Jsii$Proxy(service, open, privateDnsEnabled, securityGroups, subnets);
        }
    }

    /**
     * An implementation for {@link InterfaceVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InterfaceVpcEndpointOptions {
        private final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service;
        private final java.lang.Boolean open;
        private final java.lang.Boolean privateDnsEnabled;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.service = this.jsiiGet("service", software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService.class);
            this.open = this.jsiiGet("open", java.lang.Boolean.class);
            this.privateDnsEnabled = this.jsiiGet("privateDnsEnabled", java.lang.Boolean.class);
            this.securityGroups = this.jsiiGet("securityGroups", java.util.List.class);
            this.subnets = this.jsiiGet("subnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service, final java.lang.Boolean open, final java.lang.Boolean privateDnsEnabled, final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups, final software.amazon.awscdk.services.ec2.SubnetSelection subnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.service = java.util.Objects.requireNonNull(service, "service is required");
            this.open = open;
            this.privateDnsEnabled = privateDnsEnabled;
            this.securityGroups = securityGroups;
            this.subnets = subnets;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService getService() {
            return this.service;
        }

        @Override
        public java.lang.Boolean getOpen() {
            return this.open;
        }

        @Override
        public java.lang.Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getSubnets() {
            return this.subnets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("service", om.valueToTree(this.getService()));
            if (this.getOpen() != null) {
                data.set("open", om.valueToTree(this.getOpen()));
            }
            if (this.getPrivateDnsEnabled() != null) {
                data.set("privateDnsEnabled", om.valueToTree(this.getPrivateDnsEnabled()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnets() != null) {
                data.set("subnets", om.valueToTree(this.getSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.InterfaceVpcEndpointOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InterfaceVpcEndpointOptions.Jsii$Proxy that = (InterfaceVpcEndpointOptions.Jsii$Proxy) o;

            if (!service.equals(that.service)) return false;
            if (this.open != null ? !this.open.equals(that.open) : that.open != null) return false;
            if (this.privateDnsEnabled != null ? !this.privateDnsEnabled.equals(that.privateDnsEnabled) : that.privateDnsEnabled != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            return this.subnets != null ? this.subnets.equals(that.subnets) : that.subnets == null;
        }

        @Override
        public int hashCode() {
            int result = this.service.hashCode();
            result = 31 * result + (this.open != null ? this.open.hashCode() : 0);
            result = 31 * result + (this.privateDnsEnabled != null ? this.privateDnsEnabled.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            return result;
        }
    }
}
