package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::LocalGatewayRoute`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-19T09:09:35.086Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnLocalGatewayRouteProps")
@software.amazon.jsii.Jsii.Proxy(CfnLocalGatewayRouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnLocalGatewayRouteProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::LocalGatewayRoute.DestinationCidrBlock`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-destinationcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDestinationCidrBlock();

    /**
     * `AWS::EC2::LocalGatewayRoute.LocalGatewayRouteTableId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayroutetableid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getLocalGatewayRouteTableId();

    /**
     * `AWS::EC2::LocalGatewayRoute.LocalGatewayVirtualInterfaceGroupId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-localgatewayroute.html#cfn-ec2-localgatewayroute-localgatewayvirtualinterfacegroupid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getLocalGatewayVirtualInterfaceGroupId();

    /**
     * @return a {@link Builder} of {@link CfnLocalGatewayRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLocalGatewayRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String destinationCidrBlock;
        private java.lang.String localGatewayRouteTableId;
        private java.lang.String localGatewayVirtualInterfaceGroupId;

        /**
         * Sets the value of {@link CfnLocalGatewayRouteProps#getDestinationCidrBlock}
         * @param destinationCidrBlock `AWS::EC2::LocalGatewayRoute.DestinationCidrBlock`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder destinationCidrBlock(java.lang.String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayRouteProps#getLocalGatewayRouteTableId}
         * @param localGatewayRouteTableId `AWS::EC2::LocalGatewayRoute.LocalGatewayRouteTableId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder localGatewayRouteTableId(java.lang.String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocalGatewayRouteProps#getLocalGatewayVirtualInterfaceGroupId}
         * @param localGatewayVirtualInterfaceGroupId `AWS::EC2::LocalGatewayRoute.LocalGatewayVirtualInterfaceGroupId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder localGatewayVirtualInterfaceGroupId(java.lang.String localGatewayVirtualInterfaceGroupId) {
            this.localGatewayVirtualInterfaceGroupId = localGatewayVirtualInterfaceGroupId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLocalGatewayRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnLocalGatewayRouteProps build() {
            return new Jsii$Proxy(destinationCidrBlock, localGatewayRouteTableId, localGatewayVirtualInterfaceGroupId);
        }
    }

    /**
     * An implementation for {@link CfnLocalGatewayRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLocalGatewayRouteProps {
        private final java.lang.String destinationCidrBlock;
        private final java.lang.String localGatewayRouteTableId;
        private final java.lang.String localGatewayVirtualInterfaceGroupId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationCidrBlock = this.jsiiGet("destinationCidrBlock", java.lang.String.class);
            this.localGatewayRouteTableId = this.jsiiGet("localGatewayRouteTableId", java.lang.String.class);
            this.localGatewayVirtualInterfaceGroupId = this.jsiiGet("localGatewayVirtualInterfaceGroupId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String destinationCidrBlock, final java.lang.String localGatewayRouteTableId, final java.lang.String localGatewayVirtualInterfaceGroupId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationCidrBlock = java.util.Objects.requireNonNull(destinationCidrBlock, "destinationCidrBlock is required");
            this.localGatewayRouteTableId = java.util.Objects.requireNonNull(localGatewayRouteTableId, "localGatewayRouteTableId is required");
            this.localGatewayVirtualInterfaceGroupId = java.util.Objects.requireNonNull(localGatewayVirtualInterfaceGroupId, "localGatewayVirtualInterfaceGroupId is required");
        }

        @Override
        public java.lang.String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public java.lang.String getLocalGatewayRouteTableId() {
            return this.localGatewayRouteTableId;
        }

        @Override
        public java.lang.String getLocalGatewayVirtualInterfaceGroupId() {
            return this.localGatewayVirtualInterfaceGroupId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationCidrBlock", om.valueToTree(this.getDestinationCidrBlock()));
            data.set("localGatewayRouteTableId", om.valueToTree(this.getLocalGatewayRouteTableId()));
            data.set("localGatewayVirtualInterfaceGroupId", om.valueToTree(this.getLocalGatewayVirtualInterfaceGroupId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnLocalGatewayRouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLocalGatewayRouteProps.Jsii$Proxy that = (CfnLocalGatewayRouteProps.Jsii$Proxy) o;

            if (!destinationCidrBlock.equals(that.destinationCidrBlock)) return false;
            if (!localGatewayRouteTableId.equals(that.localGatewayRouteTableId)) return false;
            return this.localGatewayVirtualInterfaceGroupId.equals(that.localGatewayVirtualInterfaceGroupId);
        }

        @Override
        public int hashCode() {
            int result = this.destinationCidrBlock.hashCode();
            result = 31 * result + (this.localGatewayRouteTableId.hashCode());
            result = 31 * result + (this.localGatewayVirtualInterfaceGroupId.hashCode());
            return result;
        }
    }
}
