package software.amazon.awscdk.services.ec2;

import static java.util.Arrays.asList;

import java.util.List;
import software.amazon.jsii.JsiiModule;

public final class $Module extends JsiiModule {
    public $Module() {
        super("@aws-cdk/aws-ec2", "1.27.0", $Module.class, "aws-ec2@1.27.0.jsii.tgz");
    }

    @Override
    public List<Class<? extends JsiiModule>> getDependencies() {
        return asList(software.amazon.awscdk.services.cloudwatch.$Module.class, software.amazon.awscdk.services.iam.$Module.class, software.amazon.awscdk.services.logs.$Module.class, software.amazon.awscdk.services.s3.$Module.class, software.amazon.awscdk.services.ssm.$Module.class, software.amazon.awscdk.core.$Module.class, software.amazon.awscdk.cxapi.$Module.class);
    }

    @Override
    protected Class<?> resolveClass(final String fqn) throws ClassNotFoundException {
        switch (fqn) {
            case "@aws-cdk/aws-ec2.AclCidr": return software.amazon.awscdk.services.ec2.AclCidr.class;
            case "@aws-cdk/aws-ec2.AclCidrConfig": return software.amazon.awscdk.services.ec2.AclCidrConfig.class;
            case "@aws-cdk/aws-ec2.AclIcmp": return software.amazon.awscdk.services.ec2.AclIcmp.class;
            case "@aws-cdk/aws-ec2.AclPortRange": return software.amazon.awscdk.services.ec2.AclPortRange.class;
            case "@aws-cdk/aws-ec2.AclTraffic": return software.amazon.awscdk.services.ec2.AclTraffic.class;
            case "@aws-cdk/aws-ec2.AclTrafficConfig": return software.amazon.awscdk.services.ec2.AclTrafficConfig.class;
            case "@aws-cdk/aws-ec2.Action": return software.amazon.awscdk.services.ec2.Action.class;
            case "@aws-cdk/aws-ec2.AddRouteOptions": return software.amazon.awscdk.services.ec2.AddRouteOptions.class;
            case "@aws-cdk/aws-ec2.AmazonLinuxEdition": return software.amazon.awscdk.services.ec2.AmazonLinuxEdition.class;
            case "@aws-cdk/aws-ec2.AmazonLinuxGeneration": return software.amazon.awscdk.services.ec2.AmazonLinuxGeneration.class;
            case "@aws-cdk/aws-ec2.AmazonLinuxImage": return software.amazon.awscdk.services.ec2.AmazonLinuxImage.class;
            case "@aws-cdk/aws-ec2.AmazonLinuxImageProps": return software.amazon.awscdk.services.ec2.AmazonLinuxImageProps.class;
            case "@aws-cdk/aws-ec2.AmazonLinuxStorage": return software.amazon.awscdk.services.ec2.AmazonLinuxStorage.class;
            case "@aws-cdk/aws-ec2.AmazonLinuxVirt": return software.amazon.awscdk.services.ec2.AmazonLinuxVirt.class;
            case "@aws-cdk/aws-ec2.BastionHostLinux": return software.amazon.awscdk.services.ec2.BastionHostLinux.class;
            case "@aws-cdk/aws-ec2.BastionHostLinuxProps": return software.amazon.awscdk.services.ec2.BastionHostLinuxProps.class;
            case "@aws-cdk/aws-ec2.BlockDevice": return software.amazon.awscdk.services.ec2.BlockDevice.class;
            case "@aws-cdk/aws-ec2.BlockDeviceVolume": return software.amazon.awscdk.services.ec2.BlockDeviceVolume.class;
            case "@aws-cdk/aws-ec2.CfnCapacityReservation": return software.amazon.awscdk.services.ec2.CfnCapacityReservation.class;
            case "@aws-cdk/aws-ec2.CfnCapacityReservation.TagSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnCapacityReservation.TagSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnCapacityReservationProps": return software.amazon.awscdk.services.ec2.CfnCapacityReservationProps.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnAuthorizationRule": return software.amazon.awscdk.services.ec2.CfnClientVpnAuthorizationRule.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnAuthorizationRuleProps": return software.amazon.awscdk.services.ec2.CfnClientVpnAuthorizationRuleProps.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnEndpoint": return software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty": return software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ClientAuthenticationRequestProperty": return software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty": return software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty": return software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.TagSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.TagSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnEndpointProps": return software.amazon.awscdk.services.ec2.CfnClientVpnEndpointProps.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnRoute": return software.amazon.awscdk.services.ec2.CfnClientVpnRoute.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnRouteProps": return software.amazon.awscdk.services.ec2.CfnClientVpnRouteProps.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnTargetNetworkAssociation": return software.amazon.awscdk.services.ec2.CfnClientVpnTargetNetworkAssociation.class;
            case "@aws-cdk/aws-ec2.CfnClientVpnTargetNetworkAssociationProps": return software.amazon.awscdk.services.ec2.CfnClientVpnTargetNetworkAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnCustomerGateway": return software.amazon.awscdk.services.ec2.CfnCustomerGateway.class;
            case "@aws-cdk/aws-ec2.CfnCustomerGatewayProps": return software.amazon.awscdk.services.ec2.CfnCustomerGatewayProps.class;
            case "@aws-cdk/aws-ec2.CfnDHCPOptions": return software.amazon.awscdk.services.ec2.CfnDHCPOptions.class;
            case "@aws-cdk/aws-ec2.CfnDHCPOptionsProps": return software.amazon.awscdk.services.ec2.CfnDHCPOptionsProps.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.SpotOptionsRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.SpotOptionsRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.TagRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.TagSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.TagSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty": return software.amazon.awscdk.services.ec2.CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.class;
            case "@aws-cdk/aws-ec2.CfnEC2FleetProps": return software.amazon.awscdk.services.ec2.CfnEC2FleetProps.class;
            case "@aws-cdk/aws-ec2.CfnEIP": return software.amazon.awscdk.services.ec2.CfnEIP.class;
            case "@aws-cdk/aws-ec2.CfnEIPAssociation": return software.amazon.awscdk.services.ec2.CfnEIPAssociation.class;
            case "@aws-cdk/aws-ec2.CfnEIPAssociationProps": return software.amazon.awscdk.services.ec2.CfnEIPAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnEIPProps": return software.amazon.awscdk.services.ec2.CfnEIPProps.class;
            case "@aws-cdk/aws-ec2.CfnEgressOnlyInternetGateway": return software.amazon.awscdk.services.ec2.CfnEgressOnlyInternetGateway.class;
            case "@aws-cdk/aws-ec2.CfnEgressOnlyInternetGatewayProps": return software.amazon.awscdk.services.ec2.CfnEgressOnlyInternetGatewayProps.class;
            case "@aws-cdk/aws-ec2.CfnFlowLog": return software.amazon.awscdk.services.ec2.CfnFlowLog.class;
            case "@aws-cdk/aws-ec2.CfnFlowLogProps": return software.amazon.awscdk.services.ec2.CfnFlowLogProps.class;
            case "@aws-cdk/aws-ec2.CfnGatewayRouteTableAssociation": return software.amazon.awscdk.services.ec2.CfnGatewayRouteTableAssociation.class;
            case "@aws-cdk/aws-ec2.CfnGatewayRouteTableAssociationProps": return software.amazon.awscdk.services.ec2.CfnGatewayRouteTableAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnHost": return software.amazon.awscdk.services.ec2.CfnHost.class;
            case "@aws-cdk/aws-ec2.CfnHostProps": return software.amazon.awscdk.services.ec2.CfnHostProps.class;
            case "@aws-cdk/aws-ec2.CfnInstance": return software.amazon.awscdk.services.ec2.CfnInstance.class;
            case "@aws-cdk/aws-ec2.CfnInstance.AssociationParameterProperty": return software.amazon.awscdk.services.ec2.CfnInstance.AssociationParameterProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.BlockDeviceMappingProperty": return software.amazon.awscdk.services.ec2.CfnInstance.BlockDeviceMappingProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.CpuOptionsProperty": return software.amazon.awscdk.services.ec2.CfnInstance.CpuOptionsProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.CreditSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnInstance.CreditSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.EbsProperty": return software.amazon.awscdk.services.ec2.CfnInstance.EbsProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.ElasticGpuSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnInstance.ElasticGpuSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.ElasticInferenceAcceleratorProperty": return software.amazon.awscdk.services.ec2.CfnInstance.ElasticInferenceAcceleratorProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.HibernationOptionsProperty": return software.amazon.awscdk.services.ec2.CfnInstance.HibernationOptionsProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.InstanceIpv6AddressProperty": return software.amazon.awscdk.services.ec2.CfnInstance.InstanceIpv6AddressProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.LaunchTemplateSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnInstance.LaunchTemplateSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.LicenseSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnInstance.LicenseSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.NetworkInterfaceProperty": return software.amazon.awscdk.services.ec2.CfnInstance.NetworkInterfaceProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.NoDeviceProperty": return software.amazon.awscdk.services.ec2.CfnInstance.NoDeviceProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.PrivateIpAddressSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnInstance.PrivateIpAddressSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.SsmAssociationProperty": return software.amazon.awscdk.services.ec2.CfnInstance.SsmAssociationProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstance.VolumeProperty": return software.amazon.awscdk.services.ec2.CfnInstance.VolumeProperty.class;
            case "@aws-cdk/aws-ec2.CfnInstanceProps": return software.amazon.awscdk.services.ec2.CfnInstanceProps.class;
            case "@aws-cdk/aws-ec2.CfnInternetGateway": return software.amazon.awscdk.services.ec2.CfnInternetGateway.class;
            case "@aws-cdk/aws-ec2.CfnInternetGatewayProps": return software.amazon.awscdk.services.ec2.CfnInternetGatewayProps.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.BlockDeviceMappingProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.BlockDeviceMappingProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.CapacityReservationTargetProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CapacityReservationTargetProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.CpuOptionsProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CpuOptionsProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.CreditSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.CreditSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.EbsProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.EbsProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.ElasticGpuSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.HibernationOptionsProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.HibernationOptionsProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.IamInstanceProfileProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.IamInstanceProfileProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.InstanceMarketOptionsProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.Ipv6AddProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.Ipv6AddProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateDataProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.LicenseSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LicenseSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.MetadataOptionsProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MetadataOptionsProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.MonitoringProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.MonitoringProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.NetworkInterfaceProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.NetworkInterfaceProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.PlacementProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PlacementProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.PrivateIpAddProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.PrivateIpAddProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.SpotOptionsProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.SpotOptionsProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplate.TagSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnLaunchTemplate.TagSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnLaunchTemplateProps": return software.amazon.awscdk.services.ec2.CfnLaunchTemplateProps.class;
            case "@aws-cdk/aws-ec2.CfnLocalGatewayRoute": return software.amazon.awscdk.services.ec2.CfnLocalGatewayRoute.class;
            case "@aws-cdk/aws-ec2.CfnLocalGatewayRouteProps": return software.amazon.awscdk.services.ec2.CfnLocalGatewayRouteProps.class;
            case "@aws-cdk/aws-ec2.CfnLocalGatewayRouteTableVPCAssociation": return software.amazon.awscdk.services.ec2.CfnLocalGatewayRouteTableVPCAssociation.class;
            case "@aws-cdk/aws-ec2.CfnLocalGatewayRouteTableVPCAssociation.TagsProperty": return software.amazon.awscdk.services.ec2.CfnLocalGatewayRouteTableVPCAssociation.TagsProperty.class;
            case "@aws-cdk/aws-ec2.CfnLocalGatewayRouteTableVPCAssociationProps": return software.amazon.awscdk.services.ec2.CfnLocalGatewayRouteTableVPCAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnNatGateway": return software.amazon.awscdk.services.ec2.CfnNatGateway.class;
            case "@aws-cdk/aws-ec2.CfnNatGatewayProps": return software.amazon.awscdk.services.ec2.CfnNatGatewayProps.class;
            case "@aws-cdk/aws-ec2.CfnNetworkAcl": return software.amazon.awscdk.services.ec2.CfnNetworkAcl.class;
            case "@aws-cdk/aws-ec2.CfnNetworkAclEntry": return software.amazon.awscdk.services.ec2.CfnNetworkAclEntry.class;
            case "@aws-cdk/aws-ec2.CfnNetworkAclEntry.IcmpProperty": return software.amazon.awscdk.services.ec2.CfnNetworkAclEntry.IcmpProperty.class;
            case "@aws-cdk/aws-ec2.CfnNetworkAclEntry.PortRangeProperty": return software.amazon.awscdk.services.ec2.CfnNetworkAclEntry.PortRangeProperty.class;
            case "@aws-cdk/aws-ec2.CfnNetworkAclEntryProps": return software.amazon.awscdk.services.ec2.CfnNetworkAclEntryProps.class;
            case "@aws-cdk/aws-ec2.CfnNetworkAclProps": return software.amazon.awscdk.services.ec2.CfnNetworkAclProps.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterface": return software.amazon.awscdk.services.ec2.CfnNetworkInterface.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterface.InstanceIpv6AddressProperty": return software.amazon.awscdk.services.ec2.CfnNetworkInterface.InstanceIpv6AddressProperty.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterface.PrivateIpAddressSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnNetworkInterface.PrivateIpAddressSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterfaceAttachment": return software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachment.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterfaceAttachmentProps": return software.amazon.awscdk.services.ec2.CfnNetworkInterfaceAttachmentProps.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterfacePermission": return software.amazon.awscdk.services.ec2.CfnNetworkInterfacePermission.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterfacePermissionProps": return software.amazon.awscdk.services.ec2.CfnNetworkInterfacePermissionProps.class;
            case "@aws-cdk/aws-ec2.CfnNetworkInterfaceProps": return software.amazon.awscdk.services.ec2.CfnNetworkInterfaceProps.class;
            case "@aws-cdk/aws-ec2.CfnPlacementGroup": return software.amazon.awscdk.services.ec2.CfnPlacementGroup.class;
            case "@aws-cdk/aws-ec2.CfnPlacementGroupProps": return software.amazon.awscdk.services.ec2.CfnPlacementGroupProps.class;
            case "@aws-cdk/aws-ec2.CfnRoute": return software.amazon.awscdk.services.ec2.CfnRoute.class;
            case "@aws-cdk/aws-ec2.CfnRouteProps": return software.amazon.awscdk.services.ec2.CfnRouteProps.class;
            case "@aws-cdk/aws-ec2.CfnRouteTable": return software.amazon.awscdk.services.ec2.CfnRouteTable.class;
            case "@aws-cdk/aws-ec2.CfnRouteTableProps": return software.amazon.awscdk.services.ec2.CfnRouteTableProps.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroup": return software.amazon.awscdk.services.ec2.CfnSecurityGroup.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroup.EgressProperty": return software.amazon.awscdk.services.ec2.CfnSecurityGroup.EgressProperty.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroup.IngressProperty": return software.amazon.awscdk.services.ec2.CfnSecurityGroup.IngressProperty.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroupEgress": return software.amazon.awscdk.services.ec2.CfnSecurityGroupEgress.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroupEgressProps": return software.amazon.awscdk.services.ec2.CfnSecurityGroupEgressProps.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroupIngress": return software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroupIngressProps": return software.amazon.awscdk.services.ec2.CfnSecurityGroupIngressProps.class;
            case "@aws-cdk/aws-ec2.CfnSecurityGroupProps": return software.amazon.awscdk.services.ec2.CfnSecurityGroupProps.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet": return software.amazon.awscdk.services.ec2.CfnSpotFleet.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.BlockDeviceMappingProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.BlockDeviceMappingProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.ClassicLoadBalancerProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancerProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.ClassicLoadBalancersConfigProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.EbsBlockDeviceProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.EbsBlockDeviceProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.GroupIdentifierProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.GroupIdentifierProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.IamInstanceProfileSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.InstanceIpv6AddressProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.InstanceIpv6AddressProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.LaunchTemplateConfigProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.LaunchTemplateConfigProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.LaunchTemplateOverridesProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.LaunchTemplateOverridesProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.LoadBalancersConfigProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.LoadBalancersConfigProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.PrivateIpAddressSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetLaunchSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetMonitoringProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetMonitoringProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetRequestConfigDataProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotFleetTagSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.SpotPlacementProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.SpotPlacementProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.TargetGroupProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleet.TargetGroupsConfigProperty": return software.amazon.awscdk.services.ec2.CfnSpotFleet.TargetGroupsConfigProperty.class;
            case "@aws-cdk/aws-ec2.CfnSpotFleetProps": return software.amazon.awscdk.services.ec2.CfnSpotFleetProps.class;
            case "@aws-cdk/aws-ec2.CfnSubnet": return software.amazon.awscdk.services.ec2.CfnSubnet.class;
            case "@aws-cdk/aws-ec2.CfnSubnetCidrBlock": return software.amazon.awscdk.services.ec2.CfnSubnetCidrBlock.class;
            case "@aws-cdk/aws-ec2.CfnSubnetCidrBlockProps": return software.amazon.awscdk.services.ec2.CfnSubnetCidrBlockProps.class;
            case "@aws-cdk/aws-ec2.CfnSubnetNetworkAclAssociation": return software.amazon.awscdk.services.ec2.CfnSubnetNetworkAclAssociation.class;
            case "@aws-cdk/aws-ec2.CfnSubnetNetworkAclAssociationProps": return software.amazon.awscdk.services.ec2.CfnSubnetNetworkAclAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnSubnetProps": return software.amazon.awscdk.services.ec2.CfnSubnetProps.class;
            case "@aws-cdk/aws-ec2.CfnSubnetRouteTableAssociation": return software.amazon.awscdk.services.ec2.CfnSubnetRouteTableAssociation.class;
            case "@aws-cdk/aws-ec2.CfnSubnetRouteTableAssociationProps": return software.amazon.awscdk.services.ec2.CfnSubnetRouteTableAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnTrafficMirrorFilter": return software.amazon.awscdk.services.ec2.CfnTrafficMirrorFilter.class;
            case "@aws-cdk/aws-ec2.CfnTrafficMirrorFilterProps": return software.amazon.awscdk.services.ec2.CfnTrafficMirrorFilterProps.class;
            case "@aws-cdk/aws-ec2.CfnTrafficMirrorFilterRule": return software.amazon.awscdk.services.ec2.CfnTrafficMirrorFilterRule.class;
            case "@aws-cdk/aws-ec2.CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty": return software.amazon.awscdk.services.ec2.CfnTrafficMirrorFilterRule.TrafficMirrorPortRangeProperty.class;
            case "@aws-cdk/aws-ec2.CfnTrafficMirrorFilterRuleProps": return software.amazon.awscdk.services.ec2.CfnTrafficMirrorFilterRuleProps.class;
            case "@aws-cdk/aws-ec2.CfnTrafficMirrorSession": return software.amazon.awscdk.services.ec2.CfnTrafficMirrorSession.class;
            case "@aws-cdk/aws-ec2.CfnTrafficMirrorSessionProps": return software.amazon.awscdk.services.ec2.CfnTrafficMirrorSessionProps.class;
            case "@aws-cdk/aws-ec2.CfnTrafficMirrorTarget": return software.amazon.awscdk.services.ec2.CfnTrafficMirrorTarget.class;
            case "@aws-cdk/aws-ec2.CfnTrafficMirrorTargetProps": return software.amazon.awscdk.services.ec2.CfnTrafficMirrorTargetProps.class;
            case "@aws-cdk/aws-ec2.CfnTransitGateway": return software.amazon.awscdk.services.ec2.CfnTransitGateway.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayAttachment": return software.amazon.awscdk.services.ec2.CfnTransitGatewayAttachment.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayAttachmentProps": return software.amazon.awscdk.services.ec2.CfnTransitGatewayAttachmentProps.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayProps": return software.amazon.awscdk.services.ec2.CfnTransitGatewayProps.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRoute": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRoute.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteProps": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteProps.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteTable": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteTable.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteTableAssociation": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteTableAssociation.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteTableAssociationProps": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteTableAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteTablePropagation": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteTablePropagation.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteTablePropagationProps": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteTablePropagationProps.class;
            case "@aws-cdk/aws-ec2.CfnTransitGatewayRouteTableProps": return software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteTableProps.class;
            case "@aws-cdk/aws-ec2.CfnVPC": return software.amazon.awscdk.services.ec2.CfnVPC.class;
            case "@aws-cdk/aws-ec2.CfnVPCCidrBlock": return software.amazon.awscdk.services.ec2.CfnVPCCidrBlock.class;
            case "@aws-cdk/aws-ec2.CfnVPCCidrBlockProps": return software.amazon.awscdk.services.ec2.CfnVPCCidrBlockProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCDHCPOptionsAssociation": return software.amazon.awscdk.services.ec2.CfnVPCDHCPOptionsAssociation.class;
            case "@aws-cdk/aws-ec2.CfnVPCDHCPOptionsAssociationProps": return software.amazon.awscdk.services.ec2.CfnVPCDHCPOptionsAssociationProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpoint": return software.amazon.awscdk.services.ec2.CfnVPCEndpoint.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpointConnectionNotification": return software.amazon.awscdk.services.ec2.CfnVPCEndpointConnectionNotification.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpointConnectionNotificationProps": return software.amazon.awscdk.services.ec2.CfnVPCEndpointConnectionNotificationProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpointProps": return software.amazon.awscdk.services.ec2.CfnVPCEndpointProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpointService": return software.amazon.awscdk.services.ec2.CfnVPCEndpointService.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpointServicePermissions": return software.amazon.awscdk.services.ec2.CfnVPCEndpointServicePermissions.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpointServicePermissionsProps": return software.amazon.awscdk.services.ec2.CfnVPCEndpointServicePermissionsProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCEndpointServiceProps": return software.amazon.awscdk.services.ec2.CfnVPCEndpointServiceProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCGatewayAttachment": return software.amazon.awscdk.services.ec2.CfnVPCGatewayAttachment.class;
            case "@aws-cdk/aws-ec2.CfnVPCGatewayAttachmentProps": return software.amazon.awscdk.services.ec2.CfnVPCGatewayAttachmentProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCPeeringConnection": return software.amazon.awscdk.services.ec2.CfnVPCPeeringConnection.class;
            case "@aws-cdk/aws-ec2.CfnVPCPeeringConnectionProps": return software.amazon.awscdk.services.ec2.CfnVPCPeeringConnectionProps.class;
            case "@aws-cdk/aws-ec2.CfnVPCProps": return software.amazon.awscdk.services.ec2.CfnVPCProps.class;
            case "@aws-cdk/aws-ec2.CfnVPNConnection": return software.amazon.awscdk.services.ec2.CfnVPNConnection.class;
            case "@aws-cdk/aws-ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty": return software.amazon.awscdk.services.ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty.class;
            case "@aws-cdk/aws-ec2.CfnVPNConnectionProps": return software.amazon.awscdk.services.ec2.CfnVPNConnectionProps.class;
            case "@aws-cdk/aws-ec2.CfnVPNConnectionRoute": return software.amazon.awscdk.services.ec2.CfnVPNConnectionRoute.class;
            case "@aws-cdk/aws-ec2.CfnVPNConnectionRouteProps": return software.amazon.awscdk.services.ec2.CfnVPNConnectionRouteProps.class;
            case "@aws-cdk/aws-ec2.CfnVPNGateway": return software.amazon.awscdk.services.ec2.CfnVPNGateway.class;
            case "@aws-cdk/aws-ec2.CfnVPNGatewayProps": return software.amazon.awscdk.services.ec2.CfnVPNGatewayProps.class;
            case "@aws-cdk/aws-ec2.CfnVPNGatewayRoutePropagation": return software.amazon.awscdk.services.ec2.CfnVPNGatewayRoutePropagation.class;
            case "@aws-cdk/aws-ec2.CfnVPNGatewayRoutePropagationProps": return software.amazon.awscdk.services.ec2.CfnVPNGatewayRoutePropagationProps.class;
            case "@aws-cdk/aws-ec2.CfnVolume": return software.amazon.awscdk.services.ec2.CfnVolume.class;
            case "@aws-cdk/aws-ec2.CfnVolumeAttachment": return software.amazon.awscdk.services.ec2.CfnVolumeAttachment.class;
            case "@aws-cdk/aws-ec2.CfnVolumeAttachmentProps": return software.amazon.awscdk.services.ec2.CfnVolumeAttachmentProps.class;
            case "@aws-cdk/aws-ec2.CfnVolumeProps": return software.amazon.awscdk.services.ec2.CfnVolumeProps.class;
            case "@aws-cdk/aws-ec2.CommonNetworkAclEntryOptions": return software.amazon.awscdk.services.ec2.CommonNetworkAclEntryOptions.class;
            case "@aws-cdk/aws-ec2.ConfigureNatOptions": return software.amazon.awscdk.services.ec2.ConfigureNatOptions.class;
            case "@aws-cdk/aws-ec2.ConnectionRule": return software.amazon.awscdk.services.ec2.ConnectionRule.class;
            case "@aws-cdk/aws-ec2.Connections": return software.amazon.awscdk.services.ec2.Connections.class;
            case "@aws-cdk/aws-ec2.ConnectionsProps": return software.amazon.awscdk.services.ec2.ConnectionsProps.class;
            case "@aws-cdk/aws-ec2.DefaultInstanceTenancy": return software.amazon.awscdk.services.ec2.DefaultInstanceTenancy.class;
            case "@aws-cdk/aws-ec2.EbsDeviceOptions": return software.amazon.awscdk.services.ec2.EbsDeviceOptions.class;
            case "@aws-cdk/aws-ec2.EbsDeviceOptionsBase": return software.amazon.awscdk.services.ec2.EbsDeviceOptionsBase.class;
            case "@aws-cdk/aws-ec2.EbsDeviceProps": return software.amazon.awscdk.services.ec2.EbsDeviceProps.class;
            case "@aws-cdk/aws-ec2.EbsDeviceSnapshotOptions": return software.amazon.awscdk.services.ec2.EbsDeviceSnapshotOptions.class;
            case "@aws-cdk/aws-ec2.EbsDeviceVolumeType": return software.amazon.awscdk.services.ec2.EbsDeviceVolumeType.class;
            case "@aws-cdk/aws-ec2.ExecuteFileOptions": return software.amazon.awscdk.services.ec2.ExecuteFileOptions.class;
            case "@aws-cdk/aws-ec2.FlowLog": return software.amazon.awscdk.services.ec2.FlowLog.class;
            case "@aws-cdk/aws-ec2.FlowLogDestination": return software.amazon.awscdk.services.ec2.FlowLogDestination.class;
            case "@aws-cdk/aws-ec2.FlowLogDestinationConfig": return software.amazon.awscdk.services.ec2.FlowLogDestinationConfig.class;
            case "@aws-cdk/aws-ec2.FlowLogDestinationType": return software.amazon.awscdk.services.ec2.FlowLogDestinationType.class;
            case "@aws-cdk/aws-ec2.FlowLogOptions": return software.amazon.awscdk.services.ec2.FlowLogOptions.class;
            case "@aws-cdk/aws-ec2.FlowLogProps": return software.amazon.awscdk.services.ec2.FlowLogProps.class;
            case "@aws-cdk/aws-ec2.FlowLogResourceType": return software.amazon.awscdk.services.ec2.FlowLogResourceType.class;
            case "@aws-cdk/aws-ec2.FlowLogTrafficType": return software.amazon.awscdk.services.ec2.FlowLogTrafficType.class;
            case "@aws-cdk/aws-ec2.GatewayConfig": return software.amazon.awscdk.services.ec2.GatewayConfig.class;
            case "@aws-cdk/aws-ec2.GatewayVpcEndpoint": return software.amazon.awscdk.services.ec2.GatewayVpcEndpoint.class;
            case "@aws-cdk/aws-ec2.GatewayVpcEndpointAwsService": return software.amazon.awscdk.services.ec2.GatewayVpcEndpointAwsService.class;
            case "@aws-cdk/aws-ec2.GatewayVpcEndpointOptions": return software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions.class;
            case "@aws-cdk/aws-ec2.GatewayVpcEndpointProps": return software.amazon.awscdk.services.ec2.GatewayVpcEndpointProps.class;
            case "@aws-cdk/aws-ec2.GenericLinuxImage": return software.amazon.awscdk.services.ec2.GenericLinuxImage.class;
            case "@aws-cdk/aws-ec2.GenericLinuxImageProps": return software.amazon.awscdk.services.ec2.GenericLinuxImageProps.class;
            case "@aws-cdk/aws-ec2.GenericWindowsImage": return software.amazon.awscdk.services.ec2.GenericWindowsImage.class;
            case "@aws-cdk/aws-ec2.GenericWindowsImageProps": return software.amazon.awscdk.services.ec2.GenericWindowsImageProps.class;
            case "@aws-cdk/aws-ec2.IConnectable": return software.amazon.awscdk.services.ec2.IConnectable.class;
            case "@aws-cdk/aws-ec2.IFlowLog": return software.amazon.awscdk.services.ec2.IFlowLog.class;
            case "@aws-cdk/aws-ec2.IGatewayVpcEndpoint": return software.amazon.awscdk.services.ec2.IGatewayVpcEndpoint.class;
            case "@aws-cdk/aws-ec2.IGatewayVpcEndpointService": return software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService.class;
            case "@aws-cdk/aws-ec2.IInstance": return software.amazon.awscdk.services.ec2.IInstance.class;
            case "@aws-cdk/aws-ec2.IInterfaceVpcEndpoint": return software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint.class;
            case "@aws-cdk/aws-ec2.IInterfaceVpcEndpointService": return software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService.class;
            case "@aws-cdk/aws-ec2.IMachineImage": return software.amazon.awscdk.services.ec2.IMachineImage.class;
            case "@aws-cdk/aws-ec2.INetworkAcl": return software.amazon.awscdk.services.ec2.INetworkAcl.class;
            case "@aws-cdk/aws-ec2.INetworkAclEntry": return software.amazon.awscdk.services.ec2.INetworkAclEntry.class;
            case "@aws-cdk/aws-ec2.IPeer": return software.amazon.awscdk.services.ec2.IPeer.class;
            case "@aws-cdk/aws-ec2.IPrivateSubnet": return software.amazon.awscdk.services.ec2.IPrivateSubnet.class;
            case "@aws-cdk/aws-ec2.IPublicSubnet": return software.amazon.awscdk.services.ec2.IPublicSubnet.class;
            case "@aws-cdk/aws-ec2.IRouteTable": return software.amazon.awscdk.services.ec2.IRouteTable.class;
            case "@aws-cdk/aws-ec2.ISecurityGroup": return software.amazon.awscdk.services.ec2.ISecurityGroup.class;
            case "@aws-cdk/aws-ec2.ISubnet": return software.amazon.awscdk.services.ec2.ISubnet.class;
            case "@aws-cdk/aws-ec2.ISubnetNetworkAclAssociation": return software.amazon.awscdk.services.ec2.ISubnetNetworkAclAssociation.class;
            case "@aws-cdk/aws-ec2.IVpc": return software.amazon.awscdk.services.ec2.IVpc.class;
            case "@aws-cdk/aws-ec2.IVpcEndpoint": return software.amazon.awscdk.services.ec2.IVpcEndpoint.class;
            case "@aws-cdk/aws-ec2.IVpcEndpointService": return software.amazon.awscdk.services.ec2.IVpcEndpointService.class;
            case "@aws-cdk/aws-ec2.IVpcEndpointServiceLoadBalancer": return software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer.class;
            case "@aws-cdk/aws-ec2.IVpnConnection": return software.amazon.awscdk.services.ec2.IVpnConnection.class;
            case "@aws-cdk/aws-ec2.Instance": return software.amazon.awscdk.services.ec2.Instance.class;
            case "@aws-cdk/aws-ec2.InstanceClass": return software.amazon.awscdk.services.ec2.InstanceClass.class;
            case "@aws-cdk/aws-ec2.InstanceProps": return software.amazon.awscdk.services.ec2.InstanceProps.class;
            case "@aws-cdk/aws-ec2.InstanceSize": return software.amazon.awscdk.services.ec2.InstanceSize.class;
            case "@aws-cdk/aws-ec2.InstanceType": return software.amazon.awscdk.services.ec2.InstanceType.class;
            case "@aws-cdk/aws-ec2.InterfaceVpcEndpoint": return software.amazon.awscdk.services.ec2.InterfaceVpcEndpoint.class;
            case "@aws-cdk/aws-ec2.InterfaceVpcEndpointAttributes": return software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAttributes.class;
            case "@aws-cdk/aws-ec2.InterfaceVpcEndpointAwsService": return software.amazon.awscdk.services.ec2.InterfaceVpcEndpointAwsService.class;
            case "@aws-cdk/aws-ec2.InterfaceVpcEndpointOptions": return software.amazon.awscdk.services.ec2.InterfaceVpcEndpointOptions.class;
            case "@aws-cdk/aws-ec2.InterfaceVpcEndpointProps": return software.amazon.awscdk.services.ec2.InterfaceVpcEndpointProps.class;
            case "@aws-cdk/aws-ec2.InterfaceVpcEndpointService": return software.amazon.awscdk.services.ec2.InterfaceVpcEndpointService.class;
            case "@aws-cdk/aws-ec2.LinuxUserDataOptions": return software.amazon.awscdk.services.ec2.LinuxUserDataOptions.class;
            case "@aws-cdk/aws-ec2.LookupMachineImage": return software.amazon.awscdk.services.ec2.LookupMachineImage.class;
            case "@aws-cdk/aws-ec2.LookupMachineImageProps": return software.amazon.awscdk.services.ec2.LookupMachineImageProps.class;
            case "@aws-cdk/aws-ec2.MachineImage": return software.amazon.awscdk.services.ec2.MachineImage.class;
            case "@aws-cdk/aws-ec2.MachineImageConfig": return software.amazon.awscdk.services.ec2.MachineImageConfig.class;
            case "@aws-cdk/aws-ec2.NatInstanceImage": return software.amazon.awscdk.services.ec2.NatInstanceImage.class;
            case "@aws-cdk/aws-ec2.NatInstanceProps": return software.amazon.awscdk.services.ec2.NatInstanceProps.class;
            case "@aws-cdk/aws-ec2.NatProvider": return software.amazon.awscdk.services.ec2.NatProvider.class;
            case "@aws-cdk/aws-ec2.NetworkAcl": return software.amazon.awscdk.services.ec2.NetworkAcl.class;
            case "@aws-cdk/aws-ec2.NetworkAclEntry": return software.amazon.awscdk.services.ec2.NetworkAclEntry.class;
            case "@aws-cdk/aws-ec2.NetworkAclEntryProps": return software.amazon.awscdk.services.ec2.NetworkAclEntryProps.class;
            case "@aws-cdk/aws-ec2.NetworkAclProps": return software.amazon.awscdk.services.ec2.NetworkAclProps.class;
            case "@aws-cdk/aws-ec2.OperatingSystemType": return software.amazon.awscdk.services.ec2.OperatingSystemType.class;
            case "@aws-cdk/aws-ec2.Peer": return software.amazon.awscdk.services.ec2.Peer.class;
            case "@aws-cdk/aws-ec2.Port": return software.amazon.awscdk.services.ec2.Port.class;
            case "@aws-cdk/aws-ec2.PortProps": return software.amazon.awscdk.services.ec2.PortProps.class;
            case "@aws-cdk/aws-ec2.PrivateSubnet": return software.amazon.awscdk.services.ec2.PrivateSubnet.class;
            case "@aws-cdk/aws-ec2.PrivateSubnetAttributes": return software.amazon.awscdk.services.ec2.PrivateSubnetAttributes.class;
            case "@aws-cdk/aws-ec2.PrivateSubnetProps": return software.amazon.awscdk.services.ec2.PrivateSubnetProps.class;
            case "@aws-cdk/aws-ec2.Protocol": return software.amazon.awscdk.services.ec2.Protocol.class;
            case "@aws-cdk/aws-ec2.PublicSubnet": return software.amazon.awscdk.services.ec2.PublicSubnet.class;
            case "@aws-cdk/aws-ec2.PublicSubnetAttributes": return software.amazon.awscdk.services.ec2.PublicSubnetAttributes.class;
            case "@aws-cdk/aws-ec2.PublicSubnetProps": return software.amazon.awscdk.services.ec2.PublicSubnetProps.class;
            case "@aws-cdk/aws-ec2.RouterType": return software.amazon.awscdk.services.ec2.RouterType.class;
            case "@aws-cdk/aws-ec2.S3DownloadOptions": return software.amazon.awscdk.services.ec2.S3DownloadOptions.class;
            case "@aws-cdk/aws-ec2.SecurityGroup": return software.amazon.awscdk.services.ec2.SecurityGroup.class;
            case "@aws-cdk/aws-ec2.SecurityGroupImportOptions": return software.amazon.awscdk.services.ec2.SecurityGroupImportOptions.class;
            case "@aws-cdk/aws-ec2.SecurityGroupProps": return software.amazon.awscdk.services.ec2.SecurityGroupProps.class;
            case "@aws-cdk/aws-ec2.SelectedSubnets": return software.amazon.awscdk.services.ec2.SelectedSubnets.class;
            case "@aws-cdk/aws-ec2.Subnet": return software.amazon.awscdk.services.ec2.Subnet.class;
            case "@aws-cdk/aws-ec2.SubnetAttributes": return software.amazon.awscdk.services.ec2.SubnetAttributes.class;
            case "@aws-cdk/aws-ec2.SubnetConfiguration": return software.amazon.awscdk.services.ec2.SubnetConfiguration.class;
            case "@aws-cdk/aws-ec2.SubnetNetworkAclAssociation": return software.amazon.awscdk.services.ec2.SubnetNetworkAclAssociation.class;
            case "@aws-cdk/aws-ec2.SubnetNetworkAclAssociationProps": return software.amazon.awscdk.services.ec2.SubnetNetworkAclAssociationProps.class;
            case "@aws-cdk/aws-ec2.SubnetProps": return software.amazon.awscdk.services.ec2.SubnetProps.class;
            case "@aws-cdk/aws-ec2.SubnetSelection": return software.amazon.awscdk.services.ec2.SubnetSelection.class;
            case "@aws-cdk/aws-ec2.SubnetType": return software.amazon.awscdk.services.ec2.SubnetType.class;
            case "@aws-cdk/aws-ec2.TrafficDirection": return software.amazon.awscdk.services.ec2.TrafficDirection.class;
            case "@aws-cdk/aws-ec2.UserData": return software.amazon.awscdk.services.ec2.UserData.class;
            case "@aws-cdk/aws-ec2.Vpc": return software.amazon.awscdk.services.ec2.Vpc.class;
            case "@aws-cdk/aws-ec2.VpcAttributes": return software.amazon.awscdk.services.ec2.VpcAttributes.class;
            case "@aws-cdk/aws-ec2.VpcEndpoint": return software.amazon.awscdk.services.ec2.VpcEndpoint.class;
            case "@aws-cdk/aws-ec2.VpcEndpointService": return software.amazon.awscdk.services.ec2.VpcEndpointService.class;
            case "@aws-cdk/aws-ec2.VpcEndpointServiceProps": return software.amazon.awscdk.services.ec2.VpcEndpointServiceProps.class;
            case "@aws-cdk/aws-ec2.VpcEndpointType": return software.amazon.awscdk.services.ec2.VpcEndpointType.class;
            case "@aws-cdk/aws-ec2.VpcLookupOptions": return software.amazon.awscdk.services.ec2.VpcLookupOptions.class;
            case "@aws-cdk/aws-ec2.VpcProps": return software.amazon.awscdk.services.ec2.VpcProps.class;
            case "@aws-cdk/aws-ec2.VpnConnection": return software.amazon.awscdk.services.ec2.VpnConnection.class;
            case "@aws-cdk/aws-ec2.VpnConnectionOptions": return software.amazon.awscdk.services.ec2.VpnConnectionOptions.class;
            case "@aws-cdk/aws-ec2.VpnConnectionProps": return software.amazon.awscdk.services.ec2.VpnConnectionProps.class;
            case "@aws-cdk/aws-ec2.VpnConnectionType": return software.amazon.awscdk.services.ec2.VpnConnectionType.class;
            case "@aws-cdk/aws-ec2.VpnTunnelOption": return software.amazon.awscdk.services.ec2.VpnTunnelOption.class;
            case "@aws-cdk/aws-ec2.WindowsImage": return software.amazon.awscdk.services.ec2.WindowsImage.class;
            case "@aws-cdk/aws-ec2.WindowsImageProps": return software.amazon.awscdk.services.ec2.WindowsImageProps.class;
            case "@aws-cdk/aws-ec2.WindowsVersion": return software.amazon.awscdk.services.ec2.WindowsVersion.class;
            default: throw new ClassNotFoundException("Unknown JSII type: " + fqn);
        }
    }
}
