/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ec2.$Module;
import software.amazon.awscdk.services.ec2.CfnInstance;
import software.amazon.awscdk.services.ec2.CfnInstanceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance")
public class CfnInstance
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnInstance.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnInstance(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstance(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnInstance(@NotNull Construct scope, @NotNull String id, @Nullable CfnInstanceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnInstance(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAvailabilityZone() {
        return (String)this.jsiiGet("attrAvailabilityZone", String.class);
    }

    @NotNull
    public String getAttrPrivateDnsName() {
        return (String)this.jsiiGet("attrPrivateDnsName", String.class);
    }

    @NotNull
    public String getAttrPrivateIp() {
        return (String)this.jsiiGet("attrPrivateIp", String.class);
    }

    @NotNull
    public String getAttrPublicDnsName() {
        return (String)this.jsiiGet("attrPublicDnsName", String.class);
    }

    @NotNull
    public String getAttrPublicIp() {
        return (String)this.jsiiGet("attrPublicIp", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @Nullable
    public String getAdditionalInfo() {
        return (String)this.jsiiGet("additionalInfo", String.class);
    }

    public void setAdditionalInfo(@Nullable String value) {
        this.jsiiSet("additionalInfo", value);
    }

    @Nullable
    public String getAffinity() {
        return (String)this.jsiiGet("affinity", String.class);
    }

    public void setAffinity(@Nullable String value) {
        this.jsiiSet("affinity", value);
    }

    @Nullable
    public String getAvailabilityZone() {
        return (String)this.jsiiGet("availabilityZone", String.class);
    }

    public void setAvailabilityZone(@Nullable String value) {
        this.jsiiSet("availabilityZone", value);
    }

    @Nullable
    public Object getBlockDeviceMappings() {
        return this.jsiiGet("blockDeviceMappings", Object.class);
    }

    public void setBlockDeviceMappings(@Nullable IResolvable value) {
        this.jsiiSet("blockDeviceMappings", value);
    }

    public void setBlockDeviceMappings(@Nullable List<Object> value) {
        this.jsiiSet("blockDeviceMappings", value);
    }

    @Nullable
    public Object getCpuOptions() {
        return this.jsiiGet("cpuOptions", Object.class);
    }

    public void setCpuOptions(@Nullable IResolvable value) {
        this.jsiiSet("cpuOptions", value);
    }

    public void setCpuOptions(@Nullable CpuOptionsProperty value) {
        this.jsiiSet("cpuOptions", value);
    }

    @Nullable
    public Object getCreditSpecification() {
        return this.jsiiGet("creditSpecification", Object.class);
    }

    public void setCreditSpecification(@Nullable IResolvable value) {
        this.jsiiSet("creditSpecification", value);
    }

    public void setCreditSpecification(@Nullable CreditSpecificationProperty value) {
        this.jsiiSet("creditSpecification", value);
    }

    @Nullable
    public Object getDisableApiTermination() {
        return this.jsiiGet("disableApiTermination", Object.class);
    }

    public void setDisableApiTermination(@Nullable Boolean value) {
        this.jsiiSet("disableApiTermination", value);
    }

    public void setDisableApiTermination(@Nullable IResolvable value) {
        this.jsiiSet("disableApiTermination", value);
    }

    @Nullable
    public Object getEbsOptimized() {
        return this.jsiiGet("ebsOptimized", Object.class);
    }

    public void setEbsOptimized(@Nullable Boolean value) {
        this.jsiiSet("ebsOptimized", value);
    }

    public void setEbsOptimized(@Nullable IResolvable value) {
        this.jsiiSet("ebsOptimized", value);
    }

    @Nullable
    public Object getElasticGpuSpecifications() {
        return this.jsiiGet("elasticGpuSpecifications", Object.class);
    }

    public void setElasticGpuSpecifications(@Nullable IResolvable value) {
        this.jsiiSet("elasticGpuSpecifications", value);
    }

    public void setElasticGpuSpecifications(@Nullable List<Object> value) {
        this.jsiiSet("elasticGpuSpecifications", value);
    }

    @Nullable
    public Object getElasticInferenceAccelerators() {
        return this.jsiiGet("elasticInferenceAccelerators", Object.class);
    }

    public void setElasticInferenceAccelerators(@Nullable IResolvable value) {
        this.jsiiSet("elasticInferenceAccelerators", value);
    }

    public void setElasticInferenceAccelerators(@Nullable List<Object> value) {
        this.jsiiSet("elasticInferenceAccelerators", value);
    }

    @Nullable
    public Object getHibernationOptions() {
        return this.jsiiGet("hibernationOptions", Object.class);
    }

    public void setHibernationOptions(@Nullable IResolvable value) {
        this.jsiiSet("hibernationOptions", value);
    }

    public void setHibernationOptions(@Nullable HibernationOptionsProperty value) {
        this.jsiiSet("hibernationOptions", value);
    }

    @Nullable
    public String getHostId() {
        return (String)this.jsiiGet("hostId", String.class);
    }

    public void setHostId(@Nullable String value) {
        this.jsiiSet("hostId", value);
    }

    @Nullable
    public String getHostResourceGroupArn() {
        return (String)this.jsiiGet("hostResourceGroupArn", String.class);
    }

    public void setHostResourceGroupArn(@Nullable String value) {
        this.jsiiSet("hostResourceGroupArn", value);
    }

    @Nullable
    public String getIamInstanceProfile() {
        return (String)this.jsiiGet("iamInstanceProfile", String.class);
    }

    public void setIamInstanceProfile(@Nullable String value) {
        this.jsiiSet("iamInstanceProfile", value);
    }

    @Nullable
    public String getImageId() {
        return (String)this.jsiiGet("imageId", String.class);
    }

    public void setImageId(@Nullable String value) {
        this.jsiiSet("imageId", value);
    }

    @Nullable
    public String getInstanceInitiatedShutdownBehavior() {
        return (String)this.jsiiGet("instanceInitiatedShutdownBehavior", String.class);
    }

    public void setInstanceInitiatedShutdownBehavior(@Nullable String value) {
        this.jsiiSet("instanceInitiatedShutdownBehavior", value);
    }

    @Nullable
    public String getInstanceType() {
        return (String)this.jsiiGet("instanceType", String.class);
    }

    public void setInstanceType(@Nullable String value) {
        this.jsiiSet("instanceType", value);
    }

    @Nullable
    public Number getIpv6AddressCount() {
        return (Number)this.jsiiGet("ipv6AddressCount", Number.class);
    }

    public void setIpv6AddressCount(@Nullable Number value) {
        this.jsiiSet("ipv6AddressCount", value);
    }

    @Nullable
    public Object getIpv6Addresses() {
        return this.jsiiGet("ipv6Addresses", Object.class);
    }

    public void setIpv6Addresses(@Nullable IResolvable value) {
        this.jsiiSet("ipv6Addresses", value);
    }

    public void setIpv6Addresses(@Nullable List<Object> value) {
        this.jsiiSet("ipv6Addresses", value);
    }

    @Nullable
    public String getKernelId() {
        return (String)this.jsiiGet("kernelId", String.class);
    }

    public void setKernelId(@Nullable String value) {
        this.jsiiSet("kernelId", value);
    }

    @Nullable
    public String getKeyName() {
        return (String)this.jsiiGet("keyName", String.class);
    }

    public void setKeyName(@Nullable String value) {
        this.jsiiSet("keyName", value);
    }

    @Nullable
    public Object getLaunchTemplate() {
        return this.jsiiGet("launchTemplate", Object.class);
    }

    public void setLaunchTemplate(@Nullable IResolvable value) {
        this.jsiiSet("launchTemplate", value);
    }

    public void setLaunchTemplate(@Nullable LaunchTemplateSpecificationProperty value) {
        this.jsiiSet("launchTemplate", value);
    }

    @Nullable
    public Object getLicenseSpecifications() {
        return this.jsiiGet("licenseSpecifications", Object.class);
    }

    public void setLicenseSpecifications(@Nullable IResolvable value) {
        this.jsiiSet("licenseSpecifications", value);
    }

    public void setLicenseSpecifications(@Nullable List<Object> value) {
        this.jsiiSet("licenseSpecifications", value);
    }

    @Nullable
    public Object getMonitoring() {
        return this.jsiiGet("monitoring", Object.class);
    }

    public void setMonitoring(@Nullable Boolean value) {
        this.jsiiSet("monitoring", value);
    }

    public void setMonitoring(@Nullable IResolvable value) {
        this.jsiiSet("monitoring", value);
    }

    @Nullable
    public Object getNetworkInterfaces() {
        return this.jsiiGet("networkInterfaces", Object.class);
    }

    public void setNetworkInterfaces(@Nullable IResolvable value) {
        this.jsiiSet("networkInterfaces", value);
    }

    public void setNetworkInterfaces(@Nullable List<Object> value) {
        this.jsiiSet("networkInterfaces", value);
    }

    @Nullable
    public String getPlacementGroupName() {
        return (String)this.jsiiGet("placementGroupName", String.class);
    }

    public void setPlacementGroupName(@Nullable String value) {
        this.jsiiSet("placementGroupName", value);
    }

    @Nullable
    public String getPrivateIpAddress() {
        return (String)this.jsiiGet("privateIpAddress", String.class);
    }

    public void setPrivateIpAddress(@Nullable String value) {
        this.jsiiSet("privateIpAddress", value);
    }

    @Nullable
    public String getRamdiskId() {
        return (String)this.jsiiGet("ramdiskId", String.class);
    }

    public void setRamdiskId(@Nullable String value) {
        this.jsiiSet("ramdiskId", value);
    }

    @Nullable
    public List<String> getSecurityGroupIds() {
        return Optional.ofNullable((List)this.jsiiGet("securityGroupIds", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroupIds(@Nullable List<String> value) {
        this.jsiiSet("securityGroupIds", value);
    }

    @Nullable
    public List<String> getSecurityGroups() {
        return Optional.ofNullable((List)this.jsiiGet("securityGroups", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroups(@Nullable List<String> value) {
        this.jsiiSet("securityGroups", value);
    }

    @Nullable
    public Object getSourceDestCheck() {
        return this.jsiiGet("sourceDestCheck", Object.class);
    }

    public void setSourceDestCheck(@Nullable Boolean value) {
        this.jsiiSet("sourceDestCheck", value);
    }

    public void setSourceDestCheck(@Nullable IResolvable value) {
        this.jsiiSet("sourceDestCheck", value);
    }

    @Nullable
    public Object getSsmAssociations() {
        return this.jsiiGet("ssmAssociations", Object.class);
    }

    public void setSsmAssociations(@Nullable IResolvable value) {
        this.jsiiSet("ssmAssociations", value);
    }

    public void setSsmAssociations(@Nullable List<Object> value) {
        this.jsiiSet("ssmAssociations", value);
    }

    @Nullable
    public String getSubnetId() {
        return (String)this.jsiiGet("subnetId", String.class);
    }

    public void setSubnetId(@Nullable String value) {
        this.jsiiSet("subnetId", value);
    }

    @Nullable
    public String getTenancy() {
        return (String)this.jsiiGet("tenancy", String.class);
    }

    public void setTenancy(@Nullable String value) {
        this.jsiiSet("tenancy", value);
    }

    @Nullable
    public String getUserData() {
        return (String)this.jsiiGet("userData", String.class);
    }

    public void setUserData(@Nullable String value) {
        this.jsiiSet("userData", value);
    }

    @Nullable
    public Object getVolumes() {
        return this.jsiiGet("volumes", Object.class);
    }

    public void setVolumes(@Nullable IResolvable value) {
        this.jsiiSet("volumes", value);
    }

    public void setVolumes(@Nullable List<Object> value) {
        this.jsiiSet("volumes", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private CfnInstanceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder additionalInfo(String additionalInfo) {
            this.props().additionalInfo(additionalInfo);
            return this;
        }

        public Builder affinity(String affinity) {
            this.props().affinity(affinity);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props().availabilityZone(availabilityZone);
            return this;
        }

        public Builder blockDeviceMappings(IResolvable blockDeviceMappings) {
            this.props().blockDeviceMappings(blockDeviceMappings);
            return this;
        }

        public Builder blockDeviceMappings(List<Object> blockDeviceMappings) {
            this.props().blockDeviceMappings(blockDeviceMappings);
            return this;
        }

        public Builder cpuOptions(IResolvable cpuOptions) {
            this.props().cpuOptions(cpuOptions);
            return this;
        }

        public Builder cpuOptions(CpuOptionsProperty cpuOptions) {
            this.props().cpuOptions(cpuOptions);
            return this;
        }

        public Builder creditSpecification(IResolvable creditSpecification) {
            this.props().creditSpecification(creditSpecification);
            return this;
        }

        public Builder creditSpecification(CreditSpecificationProperty creditSpecification) {
            this.props().creditSpecification(creditSpecification);
            return this;
        }

        public Builder disableApiTermination(Boolean disableApiTermination) {
            this.props().disableApiTermination(disableApiTermination);
            return this;
        }

        public Builder disableApiTermination(IResolvable disableApiTermination) {
            this.props().disableApiTermination(disableApiTermination);
            return this;
        }

        public Builder ebsOptimized(Boolean ebsOptimized) {
            this.props().ebsOptimized(ebsOptimized);
            return this;
        }

        public Builder ebsOptimized(IResolvable ebsOptimized) {
            this.props().ebsOptimized(ebsOptimized);
            return this;
        }

        public Builder elasticGpuSpecifications(IResolvable elasticGpuSpecifications) {
            this.props().elasticGpuSpecifications(elasticGpuSpecifications);
            return this;
        }

        public Builder elasticGpuSpecifications(List<Object> elasticGpuSpecifications) {
            this.props().elasticGpuSpecifications(elasticGpuSpecifications);
            return this;
        }

        public Builder elasticInferenceAccelerators(IResolvable elasticInferenceAccelerators) {
            this.props().elasticInferenceAccelerators(elasticInferenceAccelerators);
            return this;
        }

        public Builder elasticInferenceAccelerators(List<Object> elasticInferenceAccelerators) {
            this.props().elasticInferenceAccelerators(elasticInferenceAccelerators);
            return this;
        }

        public Builder hibernationOptions(IResolvable hibernationOptions) {
            this.props().hibernationOptions(hibernationOptions);
            return this;
        }

        public Builder hibernationOptions(HibernationOptionsProperty hibernationOptions) {
            this.props().hibernationOptions(hibernationOptions);
            return this;
        }

        public Builder hostId(String hostId) {
            this.props().hostId(hostId);
            return this;
        }

        public Builder hostResourceGroupArn(String hostResourceGroupArn) {
            this.props().hostResourceGroupArn(hostResourceGroupArn);
            return this;
        }

        public Builder iamInstanceProfile(String iamInstanceProfile) {
            this.props().iamInstanceProfile(iamInstanceProfile);
            return this;
        }

        public Builder imageId(String imageId) {
            this.props().imageId(imageId);
            return this;
        }

        public Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.props().instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
            return this;
        }

        public Builder instanceType(String instanceType) {
            this.props().instanceType(instanceType);
            return this;
        }

        public Builder ipv6AddressCount(Number ipv6AddressCount) {
            this.props().ipv6AddressCount(ipv6AddressCount);
            return this;
        }

        public Builder ipv6Addresses(IResolvable ipv6Addresses) {
            this.props().ipv6Addresses(ipv6Addresses);
            return this;
        }

        public Builder ipv6Addresses(List<Object> ipv6Addresses) {
            this.props().ipv6Addresses(ipv6Addresses);
            return this;
        }

        public Builder kernelId(String kernelId) {
            this.props().kernelId(kernelId);
            return this;
        }

        public Builder keyName(String keyName) {
            this.props().keyName(keyName);
            return this;
        }

        public Builder launchTemplate(IResolvable launchTemplate) {
            this.props().launchTemplate(launchTemplate);
            return this;
        }

        public Builder launchTemplate(LaunchTemplateSpecificationProperty launchTemplate) {
            this.props().launchTemplate(launchTemplate);
            return this;
        }

        public Builder licenseSpecifications(IResolvable licenseSpecifications) {
            this.props().licenseSpecifications(licenseSpecifications);
            return this;
        }

        public Builder licenseSpecifications(List<Object> licenseSpecifications) {
            this.props().licenseSpecifications(licenseSpecifications);
            return this;
        }

        public Builder monitoring(Boolean monitoring) {
            this.props().monitoring(monitoring);
            return this;
        }

        public Builder monitoring(IResolvable monitoring) {
            this.props().monitoring(monitoring);
            return this;
        }

        public Builder networkInterfaces(IResolvable networkInterfaces) {
            this.props().networkInterfaces(networkInterfaces);
            return this;
        }

        public Builder networkInterfaces(List<Object> networkInterfaces) {
            this.props().networkInterfaces(networkInterfaces);
            return this;
        }

        public Builder placementGroupName(String placementGroupName) {
            this.props().placementGroupName(placementGroupName);
            return this;
        }

        public Builder privateIpAddress(String privateIpAddress) {
            this.props().privateIpAddress(privateIpAddress);
            return this;
        }

        public Builder ramdiskId(String ramdiskId) {
            this.props().ramdiskId(ramdiskId);
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.props().securityGroupIds(securityGroupIds);
            return this;
        }

        public Builder securityGroups(List<String> securityGroups) {
            this.props().securityGroups(securityGroups);
            return this;
        }

        public Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.props().sourceDestCheck(sourceDestCheck);
            return this;
        }

        public Builder sourceDestCheck(IResolvable sourceDestCheck) {
            this.props().sourceDestCheck(sourceDestCheck);
            return this;
        }

        public Builder ssmAssociations(IResolvable ssmAssociations) {
            this.props().ssmAssociations(ssmAssociations);
            return this;
        }

        public Builder ssmAssociations(List<Object> ssmAssociations) {
            this.props().ssmAssociations(ssmAssociations);
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.props().subnetId(subnetId);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public Builder tenancy(String tenancy) {
            this.props().tenancy(tenancy);
            return this;
        }

        public Builder userData(String userData) {
            this.props().userData(userData);
            return this;
        }

        public Builder volumes(IResolvable volumes) {
            this.props().volumes(volumes);
            return this;
        }

        public Builder volumes(List<Object> volumes) {
            this.props().volumes(volumes);
            return this;
        }

        public CfnInstance build() {
            return new CfnInstance(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnInstanceProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnInstanceProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.VolumeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumeProperty
    extends JsiiSerializable {
        public String getDevice();

        public String getVolumeId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String device;
            private String volumeId;

            public Builder device(String device) {
                this.device = device;
                return this;
            }

            public Builder volumeId(String volumeId) {
                this.volumeId = volumeId;
                return this;
            }

            public VolumeProperty build() {
                return new Jsii.Proxy(this.device, this.volumeId, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.SsmAssociationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SsmAssociationProperty
    extends JsiiSerializable {
        public String getDocumentName();

        default public Object getAssociationParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String documentName;
            private Object associationParameters;

            public Builder documentName(String documentName) {
                this.documentName = documentName;
                return this;
            }

            public Builder associationParameters(IResolvable associationParameters) {
                this.associationParameters = associationParameters;
                return this;
            }

            public Builder associationParameters(List<Object> associationParameters) {
                this.associationParameters = associationParameters;
                return this;
            }

            public SsmAssociationProperty build() {
                return new Jsii.Proxy(this.documentName, this.associationParameters, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.PrivateIpAddressSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PrivateIpAddressSpecificationProperty
    extends JsiiSerializable {
        public Object getPrimary();

        public String getPrivateIpAddress();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object primary;
            private String privateIpAddress;

            public Builder primary(Boolean primary) {
                this.primary = primary;
                return this;
            }

            public Builder primary(IResolvable primary) {
                this.primary = primary;
                return this;
            }

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public PrivateIpAddressSpecificationProperty build() {
                return new Jsii.Proxy(this.primary, this.privateIpAddress, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.NoDeviceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NoDeviceProperty
    extends JsiiSerializable {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            public NoDeviceProperty build() {
                return new Jsii.Proxy(null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.NetworkInterfaceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkInterfaceProperty
    extends JsiiSerializable {
        public String getDeviceIndex();

        default public Object getAssociatePublicIpAddress() {
            return null;
        }

        default public Object getDeleteOnTermination() {
            return null;
        }

        default public String getDescription() {
            return null;
        }

        default public List<String> getGroupSet() {
            return null;
        }

        default public Number getIpv6AddressCount() {
            return null;
        }

        default public Object getIpv6Addresses() {
            return null;
        }

        default public String getNetworkInterfaceId() {
            return null;
        }

        default public String getPrivateIpAddress() {
            return null;
        }

        default public Object getPrivateIpAddresses() {
            return null;
        }

        default public Number getSecondaryPrivateIpAddressCount() {
            return null;
        }

        default public String getSubnetId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String deviceIndex;
            private Object associatePublicIpAddress;
            private Object deleteOnTermination;
            private String description;
            private List<String> groupSet;
            private Number ipv6AddressCount;
            private Object ipv6Addresses;
            private String networkInterfaceId;
            private String privateIpAddress;
            private Object privateIpAddresses;
            private Number secondaryPrivateIpAddressCount;
            private String subnetId;

            public Builder deviceIndex(String deviceIndex) {
                this.deviceIndex = deviceIndex;
                return this;
            }

            public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder associatePublicIpAddress(IResolvable associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder groupSet(List<String> groupSet) {
                this.groupSet = groupSet;
                return this;
            }

            public Builder ipv6AddressCount(Number ipv6AddressCount) {
                this.ipv6AddressCount = ipv6AddressCount;
                return this;
            }

            public Builder ipv6Addresses(IResolvable ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder ipv6Addresses(List<Object> ipv6Addresses) {
                this.ipv6Addresses = ipv6Addresses;
                return this;
            }

            public Builder networkInterfaceId(String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            public Builder privateIpAddress(String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            public Builder privateIpAddresses(IResolvable privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder privateIpAddresses(List<Object> privateIpAddresses) {
                this.privateIpAddresses = privateIpAddresses;
                return this;
            }

            public Builder secondaryPrivateIpAddressCount(Number secondaryPrivateIpAddressCount) {
                this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public NetworkInterfaceProperty build() {
                return new Jsii.Proxy(this.deviceIndex, this.associatePublicIpAddress, this.deleteOnTermination, this.description, this.groupSet, this.ipv6AddressCount, this.ipv6Addresses, this.networkInterfaceId, this.privateIpAddress, this.privateIpAddresses, this.secondaryPrivateIpAddressCount, this.subnetId, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.LicenseSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LicenseSpecificationProperty
    extends JsiiSerializable {
        public String getLicenseConfigurationArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String licenseConfigurationArn;

            public Builder licenseConfigurationArn(String licenseConfigurationArn) {
                this.licenseConfigurationArn = licenseConfigurationArn;
                return this;
            }

            public LicenseSpecificationProperty build() {
                return new Jsii.Proxy(this.licenseConfigurationArn, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.LaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateSpecificationProperty
    extends JsiiSerializable {
        public String getVersion();

        default public String getLaunchTemplateId() {
            return null;
        }

        default public String getLaunchTemplateName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String version;
            private String launchTemplateId;
            private String launchTemplateName;

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public Builder launchTemplateId(String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            public Builder launchTemplateName(String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            public LaunchTemplateSpecificationProperty build() {
                return new Jsii.Proxy(this.version, this.launchTemplateId, this.launchTemplateName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.InstanceIpv6AddressProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InstanceIpv6AddressProperty
    extends JsiiSerializable {
        public String getIpv6Address();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String ipv6Address;

            public Builder ipv6Address(String ipv6Address) {
                this.ipv6Address = ipv6Address;
                return this;
            }

            public InstanceIpv6AddressProperty build() {
                return new Jsii.Proxy(this.ipv6Address, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.HibernationOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HibernationOptionsProperty
    extends JsiiSerializable {
        default public Object getConfigured() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object configured;

            public Builder configured(Boolean configured) {
                this.configured = configured;
                return this;
            }

            public Builder configured(IResolvable configured) {
                this.configured = configured;
                return this;
            }

            public HibernationOptionsProperty build() {
                return new Jsii.Proxy(this.configured, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.ElasticInferenceAcceleratorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticInferenceAcceleratorProperty
    extends JsiiSerializable {
        public String getType();

        default public Number getCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String type;
            private Number count;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder count(Number count) {
                this.count = count;
                return this;
            }

            public ElasticInferenceAcceleratorProperty build() {
                return new Jsii.Proxy(this.type, this.count, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.ElasticGpuSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticGpuSpecificationProperty
    extends JsiiSerializable {
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String type;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ElasticGpuSpecificationProperty build() {
                return new Jsii.Proxy(this.type, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.EbsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsProperty
    extends JsiiSerializable {
        default public Object getDeleteOnTermination() {
            return null;
        }

        default public Object getEncrypted() {
            return null;
        }

        default public Number getIops() {
            return null;
        }

        default public String getKmsKeyId() {
            return null;
        }

        default public String getSnapshotId() {
            return null;
        }

        default public Number getVolumeSize() {
            return null;
        }

        default public String getVolumeType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object deleteOnTermination;
            private Object encrypted;
            private Number iops;
            private String kmsKeyId;
            private String snapshotId;
            private Number volumeSize;
            private String volumeType;

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder encrypted(Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder encrypted(IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public Builder snapshotId(String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            public Builder volumeSize(Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            public Builder volumeType(String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public EbsProperty build() {
                return new Jsii.Proxy(this.deleteOnTermination, this.encrypted, this.iops, this.kmsKeyId, this.snapshotId, this.volumeSize, this.volumeType, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.CreditSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CreditSpecificationProperty
    extends JsiiSerializable {
        default public String getCpuCredits() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String cpuCredits;

            public Builder cpuCredits(String cpuCredits) {
                this.cpuCredits = cpuCredits;
                return this;
            }

            public CreditSpecificationProperty build() {
                return new Jsii.Proxy(this.cpuCredits, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.CpuOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CpuOptionsProperty
    extends JsiiSerializable {
        default public Number getCoreCount() {
            return null;
        }

        default public Number getThreadsPerCore() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Number coreCount;
            private Number threadsPerCore;

            public Builder coreCount(Number coreCount) {
                this.coreCount = coreCount;
                return this;
            }

            public Builder threadsPerCore(Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            public CpuOptionsProperty build() {
                return new Jsii.Proxy(this.coreCount, this.threadsPerCore, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        public String getDeviceName();

        default public Object getEbs() {
            return null;
        }

        default public Object getNoDevice() {
            return null;
        }

        default public String getVirtualName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String deviceName;
            private Object ebs;
            private Object noDevice;
            private String virtualName;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder ebs(IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder ebs(EbsProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder noDevice(IResolvable noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            public Builder noDevice(NoDeviceProperty noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            public Builder virtualName(String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new Jsii.Proxy(this.deviceName, this.ebs, this.noDevice, this.virtualName, null);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnInstance.AssociationParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AssociationParameterProperty
    extends JsiiSerializable {
        public String getKey();

        public List<String> getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private List<String> value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(List<String> value) {
                this.value = value;
                return this;
            }

            public AssociationParameterProperty build() {
                return new Jsii.Proxy(this.key, this.value, null);
            }
        }
    }
}

