/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.$Module;
import software.amazon.awscdk.services.ec2.BlockDevice;
import software.amazon.awscdk.services.ec2.CfnInstance;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IInstance;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceProps;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.OperatingSystemType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.UserData;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.Instance")
public class Instance
extends Resource
implements IInstance {
    protected Instance(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Instance(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Instance(@NotNull Construct scope, @NotNull String id, @NotNull InstanceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addSecurityGroup(@NotNull ISecurityGroup securityGroup) {
        this.jsiiCall("addSecurityGroup", NativeType.VOID, new Object[]{Objects.requireNonNull(securityGroup, "securityGroup is required")});
    }

    public void addToRolePolicy(@NotNull PolicyStatement statement) {
        this.jsiiCall("addToRolePolicy", NativeType.VOID, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    public void addUserData(String ... commands) {
        this.jsiiCall("addUserData", NativeType.VOID, Arrays.stream(commands).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)this.jsiiGet("grantPrincipal", IPrincipal.class);
    }

    @NotNull
    public CfnInstance getInstance() {
        return (CfnInstance)((Object)this.jsiiGet("instance", CfnInstance.class));
    }

    @Override
    @NotNull
    public String getInstanceAvailabilityZone() {
        return (String)this.jsiiGet("instanceAvailabilityZone", String.class);
    }

    @Override
    @NotNull
    public String getInstanceId() {
        return (String)this.jsiiGet("instanceId", String.class);
    }

    @Override
    @NotNull
    public String getInstancePrivateDnsName() {
        return (String)this.jsiiGet("instancePrivateDnsName", String.class);
    }

    @Override
    @NotNull
    public String getInstancePrivateIp() {
        return (String)this.jsiiGet("instancePrivateIp", String.class);
    }

    @Override
    @NotNull
    public String getInstancePublicDnsName() {
        return (String)this.jsiiGet("instancePublicDnsName", String.class);
    }

    @Override
    @NotNull
    public String getInstancePublicIp() {
        return (String)this.jsiiGet("instancePublicIp", String.class);
    }

    @NotNull
    public OperatingSystemType getOsType() {
        return (OperatingSystemType)((Object)this.jsiiGet("osType", OperatingSystemType.class));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)this.jsiiGet("role", IRole.class);
    }

    @NotNull
    public UserData getUserData() {
        return (UserData)((Object)this.jsiiGet("userData", UserData.class));
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final InstanceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new InstanceProps.Builder();
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder machineImage(IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder blockDevices(List<BlockDevice> blockDevices) {
            this.props.blockDevices(blockDevices);
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.props.instanceName(instanceName);
            return this;
        }

        public Builder keyName(String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        public Builder privateIpAddress(String privateIpAddress) {
            this.props.privateIpAddress(privateIpAddress);
            return this;
        }

        public Builder resourceSignalTimeout(Duration resourceSignalTimeout) {
            this.props.resourceSignalTimeout(resourceSignalTimeout);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.props.sourceDestCheck(sourceDestCheck);
            return this;
        }

        public Builder userData(UserData userData) {
            this.props.userData(userData);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Instance build() {
            return new Instance(this.scope, this.id, this.props.build());
        }
    }
}

