package software.amazon.awscdk.services.ec2;

/**
 * Properties for a NAT instance.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-03-18T10:30:21.251Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.NatInstanceProps")
@software.amazon.jsii.Jsii.Proxy(NatInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface NatInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Instance type of the NAT instance.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * Name of SSH keypair to grant access to instance.
     * <p>
     * Default: - No SSH access will be possible.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getKeyName() {
        return null;
    }

    /**
     * The machine image (AMI) to use.
     * <p>
     * By default, will do an AMI lookup for the latest NAT instance image.
     * <p>
     * If you have a specific AMI ID you want to use, pass a <code>GenericLinuxImage</code>. For example:
     * <p>
     * <blockquote><pre>
     * // Example automatically generated. See https://github.com/aws/jsii/issues/826
     * ec2.NatProvider.instance(new NatInstanceProps()
     *         .instanceType(new InstanceType("t3.micro"))
     *         .machineImage(GenericLinuxImage.Builder.create()Map.of(
     *                 "us-east-2", "ami-0f9c61b5a562a16af")));
     * </pre></blockquote>
     * <p>
     * Default: - Latest NAT instance image
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NatInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NatInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private java.lang.String keyName;
        private software.amazon.awscdk.services.ec2.IMachineImage machineImage;

        /**
         * Sets the value of {@link NatInstanceProps#getInstanceType}
         * @param instanceType Instance type of the NAT instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getKeyName}
         * @param keyName Name of SSH keypair to grant access to instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getMachineImage}
         * @param machineImage The machine image (AMI) to use.
         *                     By default, will do an AMI lookup for the latest NAT instance image.
         *                     <p>
         *                     If you have a specific AMI ID you want to use, pass a <code>GenericLinuxImage</code>. For example:
         *                     <p>
         *                     <blockquote><pre>
         *                     // Example automatically generated. See https://github.com/aws/jsii/issues/826
         *                     ec2.NatProvider.instance(new NatInstanceProps()
         *                             .instanceType(new InstanceType("t3.micro"))
         *                             .machineImage(GenericLinuxImage.Builder.create()Map.of(
         *                                     "us-east-2", "ami-0f9c61b5a562a16af")));
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder machineImage(software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NatInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public NatInstanceProps build() {
            return new Jsii$Proxy(instanceType, keyName, machineImage);
        }
    }

    /**
     * An implementation for {@link NatInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NatInstanceProps {
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final java.lang.String keyName;
        private final software.amazon.awscdk.services.ec2.IMachineImage machineImage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = this.jsiiGet("instanceType", software.amazon.awscdk.services.ec2.InstanceType.class);
            this.keyName = this.jsiiGet("keyName", java.lang.String.class);
            this.machineImage = this.jsiiGet("machineImage", software.amazon.awscdk.services.ec2.IMachineImage.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.InstanceType instanceType, final java.lang.String keyName, final software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
            this.keyName = keyName;
            this.machineImage = machineImage;
        }

        @Override
        public software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
            return this.machineImage;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getMachineImage() != null) {
                data.set("machineImage", om.valueToTree(this.getMachineImage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.NatInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NatInstanceProps.Jsii$Proxy that = (NatInstanceProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            return this.machineImage != null ? this.machineImage.equals(that.machineImage) : that.machineImage == null;
        }

        @Override
        public int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.machineImage != null ? this.machineImage.hashCode() : 0);
            return result;
        }
    }
}
