package software.amazon.awscdk.services.ec2;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-02T10:15:03.356Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpnTunnelOption extends software.amazon.jsii.JsiiSerializable {
    /**
     * The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer gateway.
     * 
     * Allowed characters are alphanumeric characters
     * and ._. Must be between 8 and 64 characters in length and cannot start with zero (0).
     * 
     * Default: an Amazon generated pre-shared key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPreSharedKey();
    /**
     * The range of inside IP addresses for the tunnel.
     * 
     * Any specified CIDR blocks must be
     * unique across all VPN connections that use the same virtual private gateway.
     * A size /30 CIDR block from the 169.254.0.0/16 range.
     * 
     * Default: an Amazon generated inside IP CIDR
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTunnelInsideCidr();

    /**
     * @return a {@link Builder} of {@link VpnTunnelOption}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link VpnTunnelOption}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _preSharedKey;
        @javax.annotation.Nullable
        private java.lang.String _tunnelInsideCidr;

        /**
         * Sets the value of PreSharedKey
         * @param value The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPreSharedKey(@javax.annotation.Nullable final java.lang.String value) {
            this._preSharedKey = value;
            return this;
        }
        /**
         * Sets the value of TunnelInsideCidr
         * @param value The range of inside IP addresses for the tunnel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTunnelInsideCidr(@javax.annotation.Nullable final java.lang.String value) {
            this._tunnelInsideCidr = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpnTunnelOption}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public VpnTunnelOption build() {
            return new VpnTunnelOption() {
                @javax.annotation.Nullable
                private final java.lang.String $preSharedKey = _preSharedKey;
                @javax.annotation.Nullable
                private final java.lang.String $tunnelInsideCidr = _tunnelInsideCidr;

                @Override
                public java.lang.String getPreSharedKey() {
                    return this.$preSharedKey;
                }

                @Override
                public java.lang.String getTunnelInsideCidr() {
                    return this.$tunnelInsideCidr;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getPreSharedKey() != null) {
                        obj.set("preSharedKey", om.valueToTree(this.getPreSharedKey()));
                    }
                    if (this.getTunnelInsideCidr() != null) {
                        obj.set("tunnelInsideCidr", om.valueToTree(this.getTunnelInsideCidr()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.VpnTunnelOption {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer gateway.
         * 
         * Allowed characters are alphanumeric characters
         * and ._. Must be between 8 and 64 characters in length and cannot start with zero (0).
         * 
         * Default: an Amazon generated pre-shared key
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPreSharedKey() {
            return this.jsiiGet("preSharedKey", java.lang.String.class);
        }

        /**
         * The range of inside IP addresses for the tunnel.
         * 
         * Any specified CIDR blocks must be
         * unique across all VPN connections that use the same virtual private gateway.
         * A size /30 CIDR block from the 169.254.0.0/16 range.
         * 
         * Default: an Amazon generated inside IP CIDR
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getTunnelInsideCidr() {
            return this.jsiiGet("tunnelInsideCidr", java.lang.String.class);
        }
    }
}
