/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ec2.CfnEC2Fleet;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnEC2FleetProps
extends JsiiSerializable {
    public Object getLaunchTemplateConfigs();

    public Object getTargetCapacitySpecification();

    public String getExcessCapacityTerminationPolicy();

    public Object getOnDemandOptions();

    public Object getReplaceUnhealthyInstances();

    public Object getSpotOptions();

    public Object getTagSpecifications();

    public Object getTerminateInstancesWithExpiration();

    public String getType();

    public String getValidFrom();

    public String getValidUntil();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Object _launchTemplateConfigs;
        private Object _targetCapacitySpecification;
        @Nullable
        private String _excessCapacityTerminationPolicy;
        @Nullable
        private Object _onDemandOptions;
        @Nullable
        private Object _replaceUnhealthyInstances;
        @Nullable
        private Object _spotOptions;
        @Nullable
        private Object _tagSpecifications;
        @Nullable
        private Object _terminateInstancesWithExpiration;
        @Nullable
        private String _type;
        @Nullable
        private String _validFrom;
        @Nullable
        private String _validUntil;

        public Builder withLaunchTemplateConfigs(IResolvable value) {
            this._launchTemplateConfigs = Objects.requireNonNull(value, "launchTemplateConfigs is required");
            return this;
        }

        public Builder withLaunchTemplateConfigs(List<Object> value) {
            this._launchTemplateConfigs = Objects.requireNonNull(value, "launchTemplateConfigs is required");
            return this;
        }

        public Builder withTargetCapacitySpecification(IResolvable value) {
            this._targetCapacitySpecification = Objects.requireNonNull(value, "targetCapacitySpecification is required");
            return this;
        }

        public Builder withTargetCapacitySpecification(CfnEC2Fleet.TargetCapacitySpecificationRequestProperty value) {
            this._targetCapacitySpecification = Objects.requireNonNull(value, "targetCapacitySpecification is required");
            return this;
        }

        public Builder withExcessCapacityTerminationPolicy(@Nullable String value) {
            this._excessCapacityTerminationPolicy = value;
            return this;
        }

        public Builder withOnDemandOptions(@Nullable IResolvable value) {
            this._onDemandOptions = value;
            return this;
        }

        public Builder withOnDemandOptions(@Nullable CfnEC2Fleet.OnDemandOptionsRequestProperty value) {
            this._onDemandOptions = value;
            return this;
        }

        public Builder withReplaceUnhealthyInstances(@Nullable Boolean value) {
            this._replaceUnhealthyInstances = value;
            return this;
        }

        public Builder withReplaceUnhealthyInstances(@Nullable IResolvable value) {
            this._replaceUnhealthyInstances = value;
            return this;
        }

        public Builder withSpotOptions(@Nullable IResolvable value) {
            this._spotOptions = value;
            return this;
        }

        public Builder withSpotOptions(@Nullable CfnEC2Fleet.SpotOptionsRequestProperty value) {
            this._spotOptions = value;
            return this;
        }

        public Builder withTagSpecifications(@Nullable IResolvable value) {
            this._tagSpecifications = value;
            return this;
        }

        public Builder withTagSpecifications(@Nullable List<Object> value) {
            this._tagSpecifications = value;
            return this;
        }

        public Builder withTerminateInstancesWithExpiration(@Nullable Boolean value) {
            this._terminateInstancesWithExpiration = value;
            return this;
        }

        public Builder withTerminateInstancesWithExpiration(@Nullable IResolvable value) {
            this._terminateInstancesWithExpiration = value;
            return this;
        }

        public Builder withType(@Nullable String value) {
            this._type = value;
            return this;
        }

        public Builder withValidFrom(@Nullable String value) {
            this._validFrom = value;
            return this;
        }

        public Builder withValidUntil(@Nullable String value) {
            this._validUntil = value;
            return this;
        }

        public CfnEC2FleetProps build() {
            return new CfnEC2FleetProps(){
                private final Object $launchTemplateConfigs;
                private final Object $targetCapacitySpecification;
                @Nullable
                private final String $excessCapacityTerminationPolicy;
                @Nullable
                private final Object $onDemandOptions;
                @Nullable
                private final Object $replaceUnhealthyInstances;
                @Nullable
                private final Object $spotOptions;
                @Nullable
                private final Object $tagSpecifications;
                @Nullable
                private final Object $terminateInstancesWithExpiration;
                @Nullable
                private final String $type;
                @Nullable
                private final String $validFrom;
                @Nullable
                private final String $validUntil;
                {
                    this.$launchTemplateConfigs = Objects.requireNonNull(_launchTemplateConfigs, "launchTemplateConfigs is required");
                    this.$targetCapacitySpecification = Objects.requireNonNull(_targetCapacitySpecification, "targetCapacitySpecification is required");
                    this.$excessCapacityTerminationPolicy = _excessCapacityTerminationPolicy;
                    this.$onDemandOptions = _onDemandOptions;
                    this.$replaceUnhealthyInstances = _replaceUnhealthyInstances;
                    this.$spotOptions = _spotOptions;
                    this.$tagSpecifications = _tagSpecifications;
                    this.$terminateInstancesWithExpiration = _terminateInstancesWithExpiration;
                    this.$type = _type;
                    this.$validFrom = _validFrom;
                    this.$validUntil = _validUntil;
                }

                @Override
                public Object getLaunchTemplateConfigs() {
                    return this.$launchTemplateConfigs;
                }

                @Override
                public Object getTargetCapacitySpecification() {
                    return this.$targetCapacitySpecification;
                }

                @Override
                public String getExcessCapacityTerminationPolicy() {
                    return this.$excessCapacityTerminationPolicy;
                }

                @Override
                public Object getOnDemandOptions() {
                    return this.$onDemandOptions;
                }

                @Override
                public Object getReplaceUnhealthyInstances() {
                    return this.$replaceUnhealthyInstances;
                }

                @Override
                public Object getSpotOptions() {
                    return this.$spotOptions;
                }

                @Override
                public Object getTagSpecifications() {
                    return this.$tagSpecifications;
                }

                @Override
                public Object getTerminateInstancesWithExpiration() {
                    return this.$terminateInstancesWithExpiration;
                }

                @Override
                public String getType() {
                    return this.$type;
                }

                @Override
                public String getValidFrom() {
                    return this.$validFrom;
                }

                @Override
                public String getValidUntil() {
                    return this.$validUntil;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("launchTemplateConfigs", om.valueToTree(this.getLaunchTemplateConfigs()));
                    obj.set("targetCapacitySpecification", om.valueToTree(this.getTargetCapacitySpecification()));
                    if (this.getExcessCapacityTerminationPolicy() != null) {
                        obj.set("excessCapacityTerminationPolicy", om.valueToTree((Object)this.getExcessCapacityTerminationPolicy()));
                    }
                    if (this.getOnDemandOptions() != null) {
                        obj.set("onDemandOptions", om.valueToTree(this.getOnDemandOptions()));
                    }
                    if (this.getReplaceUnhealthyInstances() != null) {
                        obj.set("replaceUnhealthyInstances", om.valueToTree(this.getReplaceUnhealthyInstances()));
                    }
                    if (this.getSpotOptions() != null) {
                        obj.set("spotOptions", om.valueToTree(this.getSpotOptions()));
                    }
                    if (this.getTagSpecifications() != null) {
                        obj.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                    }
                    if (this.getTerminateInstancesWithExpiration() != null) {
                        obj.set("terminateInstancesWithExpiration", om.valueToTree(this.getTerminateInstancesWithExpiration()));
                    }
                    if (this.getType() != null) {
                        obj.set("type", om.valueToTree((Object)this.getType()));
                    }
                    if (this.getValidFrom() != null) {
                        obj.set("validFrom", om.valueToTree((Object)this.getValidFrom()));
                    }
                    if (this.getValidUntil() != null) {
                        obj.set("validUntil", om.valueToTree((Object)this.getValidUntil()));
                    }
                    return obj;
                }
            };
        }
    }
}

