/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InterfaceVpcEndpointOptions;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface InterfaceVpcEndpointProps
extends JsiiSerializable,
InterfaceVpcEndpointOptions {
    public IVpc getVpc();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IVpc _vpc;
        private IInterfaceVpcEndpointService _service;
        @Nullable
        private Boolean _privateDnsEnabled;
        @Nullable
        private SubnetSelection _subnets;

        public Builder withVpc(IVpc value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withService(IInterfaceVpcEndpointService value) {
            this._service = Objects.requireNonNull(value, "service is required");
            return this;
        }

        public Builder withPrivateDnsEnabled(@Nullable Boolean value) {
            this._privateDnsEnabled = value;
            return this;
        }

        public Builder withSubnets(@Nullable SubnetSelection value) {
            this._subnets = value;
            return this;
        }

        public InterfaceVpcEndpointProps build() {
            return new InterfaceVpcEndpointProps(){
                private final IVpc $vpc;
                private final IInterfaceVpcEndpointService $service;
                @Nullable
                private final Boolean $privateDnsEnabled;
                @Nullable
                private final SubnetSelection $subnets;
                {
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$service = Objects.requireNonNull(_service, "service is required");
                    this.$privateDnsEnabled = _privateDnsEnabled;
                    this.$subnets = _subnets;
                }

                @Override
                public IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public IInterfaceVpcEndpointService getService() {
                    return this.$service;
                }

                @Override
                public Boolean getPrivateDnsEnabled() {
                    return this.$privateDnsEnabled;
                }

                @Override
                public SubnetSelection getSubnets() {
                    return this.$subnets;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("vpc", om.valueToTree((Object)this.getVpc()));
                    obj.set("service", om.valueToTree((Object)this.getService()));
                    if (this.getPrivateDnsEnabled() != null) {
                        obj.set("privateDnsEnabled", om.valueToTree((Object)this.getPrivateDnsEnabled()));
                    }
                    if (this.getSubnets() != null) {
                        obj.set("subnets", om.valueToTree((Object)this.getSubnets()));
                    }
                    return obj;
                }
            };
        }
    }
}

