package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.0 (build 8ae966b)", date = "2020-04-17T19:11:19.090Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint")
public class CfnClientVpnEndpoint extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnClientVpnEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnClientVpnEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::EC2::ClientVpnEndpoint`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnClientVpnEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnClientVpnEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAuthenticationOptions() {
        return this.jsiiGet("authenticationOptions", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthenticationOptions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("authenticationOptions", java.util.Objects.requireNonNull(value, "authenticationOptions is required"));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthenticationOptions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        this.jsiiSet("authenticationOptions", java.util.Objects.requireNonNull(value, "authenticationOptions is required"));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getClientCidrBlock() {
        return this.jsiiGet("clientCidrBlock", java.lang.String.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setClientCidrBlock(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("clientCidrBlock", java.util.Objects.requireNonNull(value, "clientCidrBlock is required"));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConnectionLogOptions() {
        return this.jsiiGet("connectionLogOptions", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setConnectionLogOptions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("connectionLogOptions", java.util.Objects.requireNonNull(value, "connectionLogOptions is required"));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setConnectionLogOptions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty value) {
        this.jsiiSet("connectionLogOptions", java.util.Objects.requireNonNull(value, "connectionLogOptions is required"));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getServerCertificateArn() {
        return this.jsiiGet("serverCertificateArn", java.lang.String.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setServerCertificateArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("serverCertificateArn", java.util.Objects.requireNonNull(value, "serverCertificateArn is required"));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.DnsServers`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDnsServers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("dnsServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.DnsServers`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDnsServers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("dnsServers", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.SecurityGroupIds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-securitygroupids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(this.jsiiGet("securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.SecurityGroupIds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-securitygroupids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        this.jsiiSet("securityGroupIds", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSplitTunnel() {
        return this.jsiiGet("splitTunnel", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSplitTunnel(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("splitTunnel", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSplitTunnel(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("splitTunnel", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return this.jsiiGet("tagSpecifications", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("tagSpecifications", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTagSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("tagSpecifications", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getTransportProtocol() {
        return this.jsiiGet("transportProtocol", java.lang.String.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTransportProtocol(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("transportProtocol", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.VpcId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return this.jsiiGet("vpcId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.VpcId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVpcId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("vpcId", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.VpnPort`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpnport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Number getVpnPort() {
        return this.jsiiGet("vpnPort", java.lang.Number.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.VpnPort`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpnport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVpnPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("vpnPort", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-certificateauthenticationrequest.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(CertificateAuthenticationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CertificateAuthenticationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty.ClientRootCertificateChainArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-certificateauthenticationrequest.html#cfn-ec2-clientvpnendpoint-certificateauthenticationrequest-clientrootcertificatechainarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getClientRootCertificateChainArn();

        /**
         * @return a {@link Builder} of {@link CertificateAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CertificateAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String clientRootCertificateChainArn;

            /**
             * Sets the value of {@link CertificateAuthenticationRequestProperty#getClientRootCertificateChainArn}
             * @param clientRootCertificateChainArn `CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty.ClientRootCertificateChainArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder clientRootCertificateChainArn(java.lang.String clientRootCertificateChainArn) {
                this.clientRootCertificateChainArn = clientRootCertificateChainArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateAuthenticationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CertificateAuthenticationRequestProperty build() {
                return new Jsii$Proxy(clientRootCertificateChainArn);
            }
        }

        /**
         * An implementation for {@link CertificateAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateAuthenticationRequestProperty {
            private final java.lang.String clientRootCertificateChainArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientRootCertificateChainArn = this.jsiiGet("clientRootCertificateChainArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String clientRootCertificateChainArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientRootCertificateChainArn = java.util.Objects.requireNonNull(clientRootCertificateChainArn, "clientRootCertificateChainArn is required");
            }

            @Override
            public java.lang.String getClientRootCertificateChainArn() {
                return this.clientRootCertificateChainArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientRootCertificateChainArn", om.valueToTree(this.getClientRootCertificateChainArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CertificateAuthenticationRequestProperty.Jsii$Proxy that = (CertificateAuthenticationRequestProperty.Jsii$Proxy) o;

                return this.clientRootCertificateChainArn.equals(that.clientRootCertificateChainArn);
            }

            @Override
            public int hashCode() {
                int result = this.clientRootCertificateChainArn.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ClientAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientAuthenticationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ClientAuthenticationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.ActiveDirectory`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-activedirectory
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActiveDirectory() {
            return null;
        }

        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.MutualAuthentication`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-mutualauthentication
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMutualAuthentication() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClientAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String type;
            private java.lang.Object activeDirectory;
            private java.lang.Object mutualAuthentication;

            /**
             * Sets the value of {@link ClientAuthenticationRequestProperty#getType}
             * @param type `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationRequestProperty#getActiveDirectory}
             * @param activeDirectory `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.ActiveDirectory`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder activeDirectory(software.amazon.awscdk.core.IResolvable activeDirectory) {
                this.activeDirectory = activeDirectory;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationRequestProperty#getActiveDirectory}
             * @param activeDirectory `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.ActiveDirectory`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder activeDirectory(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty activeDirectory) {
                this.activeDirectory = activeDirectory;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationRequestProperty#getMutualAuthentication}
             * @param mutualAuthentication `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.MutualAuthentication`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder mutualAuthentication(software.amazon.awscdk.core.IResolvable mutualAuthentication) {
                this.mutualAuthentication = mutualAuthentication;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationRequestProperty#getMutualAuthentication}
             * @param mutualAuthentication `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.MutualAuthentication`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder mutualAuthentication(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty mutualAuthentication) {
                this.mutualAuthentication = mutualAuthentication;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientAuthenticationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ClientAuthenticationRequestProperty build() {
                return new Jsii$Proxy(type, activeDirectory, mutualAuthentication);
            }
        }

        /**
         * An implementation for {@link ClientAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientAuthenticationRequestProperty {
            private final java.lang.String type;
            private final java.lang.Object activeDirectory;
            private final java.lang.Object mutualAuthentication;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.activeDirectory = this.jsiiGet("activeDirectory", java.lang.Object.class);
                this.mutualAuthentication = this.jsiiGet("mutualAuthentication", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String type, final java.lang.Object activeDirectory, final java.lang.Object mutualAuthentication) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.activeDirectory = activeDirectory;
                this.mutualAuthentication = mutualAuthentication;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.Object getActiveDirectory() {
                return this.activeDirectory;
            }

            @Override
            public java.lang.Object getMutualAuthentication() {
                return this.mutualAuthentication;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getActiveDirectory() != null) {
                    data.set("activeDirectory", om.valueToTree(this.getActiveDirectory()));
                }
                if (this.getMutualAuthentication() != null) {
                    data.set("mutualAuthentication", om.valueToTree(this.getMutualAuthentication()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ClientAuthenticationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientAuthenticationRequestProperty.Jsii$Proxy that = (ClientAuthenticationRequestProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.activeDirectory != null ? !this.activeDirectory.equals(that.activeDirectory) : that.activeDirectory != null) return false;
                return this.mutualAuthentication != null ? this.mutualAuthentication.equals(that.mutualAuthentication) : that.mutualAuthentication == null;
            }

            @Override
            public int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.activeDirectory != null ? this.activeDirectory.hashCode() : 0);
                result = 31 * result + (this.mutualAuthentication != null ? this.mutualAuthentication.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionLogOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ConnectionLogOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogGroup`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-cloudwatchloggroup
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudwatchLogGroup() {
            return null;
        }

        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogStream`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-cloudwatchlogstream
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudwatchLogStream() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectionLogOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionLogOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object enabled;
            private java.lang.String cloudwatchLogGroup;
            private java.lang.String cloudwatchLogStream;

            /**
             * Sets the value of {@link ConnectionLogOptionsProperty#getEnabled}
             * @param enabled `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionLogOptionsProperty#getEnabled}
             * @param enabled `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionLogOptionsProperty#getCloudwatchLogGroup}
             * @param cloudwatchLogGroup `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogGroup`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cloudwatchLogGroup(java.lang.String cloudwatchLogGroup) {
                this.cloudwatchLogGroup = cloudwatchLogGroup;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionLogOptionsProperty#getCloudwatchLogStream}
             * @param cloudwatchLogStream `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogStream`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cloudwatchLogStream(java.lang.String cloudwatchLogStream) {
                this.cloudwatchLogStream = cloudwatchLogStream;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionLogOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ConnectionLogOptionsProperty build() {
                return new Jsii$Proxy(enabled, cloudwatchLogGroup, cloudwatchLogStream);
            }
        }

        /**
         * An implementation for {@link ConnectionLogOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionLogOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String cloudwatchLogGroup;
            private final java.lang.String cloudwatchLogStream;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.cloudwatchLogGroup = this.jsiiGet("cloudwatchLogGroup", java.lang.String.class);
                this.cloudwatchLogStream = this.jsiiGet("cloudwatchLogStream", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object enabled, final java.lang.String cloudwatchLogGroup, final java.lang.String cloudwatchLogStream) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.cloudwatchLogGroup = cloudwatchLogGroup;
                this.cloudwatchLogStream = cloudwatchLogStream;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.lang.String getCloudwatchLogGroup() {
                return this.cloudwatchLogGroup;
            }

            @Override
            public java.lang.String getCloudwatchLogStream() {
                return this.cloudwatchLogStream;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getCloudwatchLogGroup() != null) {
                    data.set("cloudwatchLogGroup", om.valueToTree(this.getCloudwatchLogGroup()));
                }
                if (this.getCloudwatchLogStream() != null) {
                    data.set("cloudwatchLogStream", om.valueToTree(this.getCloudwatchLogStream()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionLogOptionsProperty.Jsii$Proxy that = (ConnectionLogOptionsProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.cloudwatchLogGroup != null ? !this.cloudwatchLogGroup.equals(that.cloudwatchLogGroup) : that.cloudwatchLogGroup != null) return false;
                return this.cloudwatchLogStream != null ? this.cloudwatchLogStream.equals(that.cloudwatchLogStream) : that.cloudwatchLogStream == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.cloudwatchLogGroup != null ? this.cloudwatchLogGroup.hashCode() : 0);
                result = 31 * result + (this.cloudwatchLogStream != null ? this.cloudwatchLogStream.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-directoryserviceauthenticationrequest.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(DirectoryServiceAuthenticationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DirectoryServiceAuthenticationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty.DirectoryId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-directoryserviceauthenticationrequest.html#cfn-ec2-clientvpnendpoint-directoryserviceauthenticationrequest-directoryid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getDirectoryId();

        /**
         * @return a {@link Builder} of {@link DirectoryServiceAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DirectoryServiceAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String directoryId;

            /**
             * Sets the value of {@link DirectoryServiceAuthenticationRequestProperty#getDirectoryId}
             * @param directoryId `CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty.DirectoryId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder directoryId(java.lang.String directoryId) {
                this.directoryId = directoryId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DirectoryServiceAuthenticationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DirectoryServiceAuthenticationRequestProperty build() {
                return new Jsii$Proxy(directoryId);
            }
        }

        /**
         * An implementation for {@link DirectoryServiceAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DirectoryServiceAuthenticationRequestProperty {
            private final java.lang.String directoryId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.directoryId = this.jsiiGet("directoryId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String directoryId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.directoryId = java.util.Objects.requireNonNull(directoryId, "directoryId is required");
            }

            @Override
            public java.lang.String getDirectoryId() {
                return this.directoryId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("directoryId", om.valueToTree(this.getDirectoryId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DirectoryServiceAuthenticationRequestProperty.Jsii$Proxy that = (DirectoryServiceAuthenticationRequestProperty.Jsii$Proxy) o;

                return this.directoryId.equals(that.directoryId);
            }

            @Override
            public int hashCode() {
                int result = this.directoryId.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint.TagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(TagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnClientVpnEndpoint.TagSpecificationProperty.ResourceType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html#cfn-ec2-clientvpnendpoint-tagspecification-resourcetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

        /**
         * `CfnClientVpnEndpoint.TagSpecificationProperty.Tags`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html#cfn-ec2-clientvpnendpoint-tagspecification-tags
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String resourceType;
            private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of {@link TagSpecificationProperty#getResourceType}
             * @param resourceType `CfnClientVpnEndpoint.TagSpecificationProperty.ResourceType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link TagSpecificationProperty#getTags}
             * @param tags `CfnClientVpnEndpoint.TagSpecificationProperty.Tags`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(resourceType, tags);
            }
        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = this.jsiiGet("resourceType", java.lang.String.class);
                this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String resourceType, final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = java.util.Objects.requireNonNull(resourceType, "resourceType is required");
                this.tags = java.util.Objects.requireNonNull(tags, "tags is required");
            }

            @Override
            public java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceType", om.valueToTree(this.getResourceType()));
                data.set("tags", om.valueToTree(this.getTags()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnClientVpnEndpoint.TagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (!resourceType.equals(that.resourceType)) return false;
                return this.tags.equals(that.tags);
            }

            @Override
            public int hashCode() {
                int result = this.resourceType.hashCode();
                result = 31 * result + (this.tags.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnClientVpnEndpointProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnClientVpnEndpointProps.Builder();
        }

        /**
         * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
         * @param authenticationOptions `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authenticationOptions(final software.amazon.awscdk.core.IResolvable authenticationOptions) {
            this.props.authenticationOptions(authenticationOptions);
            return this;
        }
        /**
         * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
         * @param authenticationOptions `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authenticationOptions(final java.util.List<java.lang.Object> authenticationOptions) {
            this.props.authenticationOptions(authenticationOptions);
            return this;
        }

        /**
         * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
         * @param clientCidrBlock `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder clientCidrBlock(final java.lang.String clientCidrBlock) {
            this.props.clientCidrBlock(clientCidrBlock);
            return this;
        }

        /**
         * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
         * @param connectionLogOptions `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder connectionLogOptions(final software.amazon.awscdk.core.IResolvable connectionLogOptions) {
            this.props.connectionLogOptions(connectionLogOptions);
            return this;
        }
        /**
         * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
         * @param connectionLogOptions `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder connectionLogOptions(final software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty connectionLogOptions) {
            this.props.connectionLogOptions(connectionLogOptions);
            return this;
        }

        /**
         * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
         * @param serverCertificateArn `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder serverCertificateArn(final java.lang.String serverCertificateArn) {
            this.props.serverCertificateArn(serverCertificateArn);
            return this;
        }

        /**
         * `AWS::EC2::ClientVpnEndpoint.Description`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
         * @param description `AWS::EC2::ClientVpnEndpoint.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * `AWS::EC2::ClientVpnEndpoint.DnsServers`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
         * @param dnsServers `AWS::EC2::ClientVpnEndpoint.DnsServers`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder dnsServers(final java.util.List<java.lang.String> dnsServers) {
            this.props.dnsServers(dnsServers);
            return this;
        }

        /**
         * `AWS::EC2::ClientVpnEndpoint.SecurityGroupIds`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-securitygroupids
         * @param securityGroupIds `AWS::EC2::ClientVpnEndpoint.SecurityGroupIds`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder securityGroupIds(final java.util.List<java.lang.String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        /**
         * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
         * @param splitTunnel `AWS::EC2::ClientVpnEndpoint.SplitTunnel`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder splitTunnel(final java.lang.Boolean splitTunnel) {
            this.props.splitTunnel(splitTunnel);
            return this;
        }
        /**
         * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
         * @param splitTunnel `AWS::EC2::ClientVpnEndpoint.SplitTunnel`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder splitTunnel(final software.amazon.awscdk.core.IResolvable splitTunnel) {
            this.props.splitTunnel(splitTunnel);
            return this;
        }

        /**
         * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
         * @param tagSpecifications `AWS::EC2::ClientVpnEndpoint.TagSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tagSpecifications(final software.amazon.awscdk.core.IResolvable tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }
        /**
         * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
         * @param tagSpecifications `AWS::EC2::ClientVpnEndpoint.TagSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tagSpecifications(final java.util.List<java.lang.Object> tagSpecifications) {
            this.props.tagSpecifications(tagSpecifications);
            return this;
        }

        /**
         * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
         * @param transportProtocol `AWS::EC2::ClientVpnEndpoint.TransportProtocol`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder transportProtocol(final java.lang.String transportProtocol) {
            this.props.transportProtocol(transportProtocol);
            return this;
        }

        /**
         * `AWS::EC2::ClientVpnEndpoint.VpcId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpcid
         * @param vpcId `AWS::EC2::ClientVpnEndpoint.VpcId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * `AWS::EC2::ClientVpnEndpoint.VpnPort`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-vpnport
         * @param vpnPort `AWS::EC2::ClientVpnEndpoint.VpnPort`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpnPort(final java.lang.Number vpnPort) {
            this.props.vpnPort(vpnPort);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint build() {
            return new software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
