package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::VPNConnection`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.0 (build 8ae966b)", date = "2020-04-17T19:11:19.195Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPNConnection")
public class CfnVPNConnection extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnVPNConnection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVPNConnection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnVPNConnection.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::EC2::VPNConnection`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnVPNConnection(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnVPNConnectionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::EC2::VPNConnection.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::EC2::VPNConnection.CustomerGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-customergatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getCustomerGatewayId() {
        return this.jsiiGet("customerGatewayId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::VPNConnection.CustomerGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-customergatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCustomerGatewayId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("customerGatewayId", java.util.Objects.requireNonNull(value, "customerGatewayId is required"));
    }

    /**
     * `AWS::EC2::VPNConnection.Type`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return this.jsiiGet("type", java.lang.String.class);
    }

    /**
     * `AWS::EC2::VPNConnection.Type`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * `AWS::EC2::VPNConnection.StaticRoutesOnly`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStaticRoutesOnly() {
        return this.jsiiGet("staticRoutesOnly", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::VPNConnection.StaticRoutesOnly`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStaticRoutesOnly(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        this.jsiiSet("staticRoutesOnly", value);
    }

    /**
     * `AWS::EC2::VPNConnection.StaticRoutesOnly`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStaticRoutesOnly(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("staticRoutesOnly", value);
    }

    /**
     * `AWS::EC2::VPNConnection.TransitGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-transitgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayId() {
        return this.jsiiGet("transitGatewayId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::VPNConnection.TransitGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-transitgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTransitGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("transitGatewayId", value);
    }

    /**
     * `AWS::EC2::VPNConnection.VpnGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpngatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpnGatewayId() {
        return this.jsiiGet("vpnGatewayId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::VPNConnection.VpnGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpngatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVpnGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("vpnGatewayId", value);
    }

    /**
     * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpnTunnelOptionsSpecifications() {
        return this.jsiiGet("vpnTunnelOptionsSpecifications", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVpnTunnelOptionsSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("vpnTunnelOptionsSpecifications", value);
    }

    /**
     * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVpnTunnelOptionsSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("vpnTunnelOptionsSpecifications", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(VpnTunnelOptionsSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface VpnTunnelOptionsSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnVPNConnection.VpnTunnelOptionsSpecificationProperty.PreSharedKey`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreSharedKey() {
            return null;
        }

        /**
         * `CfnVPNConnection.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getTunnelInsideCidr() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpnTunnelOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpnTunnelOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String preSharedKey;
            private java.lang.String tunnelInsideCidr;

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPreSharedKey}
             * @param preSharedKey `CfnVPNConnection.VpnTunnelOptionsSpecificationProperty.PreSharedKey`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder preSharedKey(java.lang.String preSharedKey) {
                this.preSharedKey = preSharedKey;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getTunnelInsideCidr}
             * @param tunnelInsideCidr `CfnVPNConnection.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tunnelInsideCidr(java.lang.String tunnelInsideCidr) {
                this.tunnelInsideCidr = tunnelInsideCidr;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpnTunnelOptionsSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public VpnTunnelOptionsSpecificationProperty build() {
                return new Jsii$Proxy(preSharedKey, tunnelInsideCidr);
            }
        }

        /**
         * An implementation for {@link VpnTunnelOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpnTunnelOptionsSpecificationProperty {
            private final java.lang.String preSharedKey;
            private final java.lang.String tunnelInsideCidr;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.preSharedKey = this.jsiiGet("preSharedKey", java.lang.String.class);
                this.tunnelInsideCidr = this.jsiiGet("tunnelInsideCidr", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String preSharedKey, final java.lang.String tunnelInsideCidr) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.preSharedKey = preSharedKey;
                this.tunnelInsideCidr = tunnelInsideCidr;
            }

            @Override
            public java.lang.String getPreSharedKey() {
                return this.preSharedKey;
            }

            @Override
            public java.lang.String getTunnelInsideCidr() {
                return this.tunnelInsideCidr;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPreSharedKey() != null) {
                    data.set("preSharedKey", om.valueToTree(this.getPreSharedKey()));
                }
                if (this.getTunnelInsideCidr() != null) {
                    data.set("tunnelInsideCidr", om.valueToTree(this.getTunnelInsideCidr()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpnTunnelOptionsSpecificationProperty.Jsii$Proxy that = (VpnTunnelOptionsSpecificationProperty.Jsii$Proxy) o;

                if (this.preSharedKey != null ? !this.preSharedKey.equals(that.preSharedKey) : that.preSharedKey != null) return false;
                return this.tunnelInsideCidr != null ? this.tunnelInsideCidr.equals(that.tunnelInsideCidr) : that.tunnelInsideCidr == null;
            }

            @Override
            public int hashCode() {
                int result = this.preSharedKey != null ? this.preSharedKey.hashCode() : 0;
                result = 31 * result + (this.tunnelInsideCidr != null ? this.tunnelInsideCidr.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnVPNConnection}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnVPNConnectionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnVPNConnectionProps.Builder();
        }

        /**
         * `AWS::EC2::VPNConnection.CustomerGatewayId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-customergatewayid
         * @param customerGatewayId `AWS::EC2::VPNConnection.CustomerGatewayId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder customerGatewayId(final java.lang.String customerGatewayId) {
            this.props.customerGatewayId(customerGatewayId);
            return this;
        }

        /**
         * `AWS::EC2::VPNConnection.Type`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-type
         * @param type `AWS::EC2::VPNConnection.Type`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * `AWS::EC2::VPNConnection.StaticRoutesOnly`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
         * @param staticRoutesOnly `AWS::EC2::VPNConnection.StaticRoutesOnly`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder staticRoutesOnly(final java.lang.Boolean staticRoutesOnly) {
            this.props.staticRoutesOnly(staticRoutesOnly);
            return this;
        }
        /**
         * `AWS::EC2::VPNConnection.StaticRoutesOnly`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
         * @param staticRoutesOnly `AWS::EC2::VPNConnection.StaticRoutesOnly`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder staticRoutesOnly(final software.amazon.awscdk.core.IResolvable staticRoutesOnly) {
            this.props.staticRoutesOnly(staticRoutesOnly);
            return this;
        }

        /**
         * `AWS::EC2::VPNConnection.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-tags
         * @param tags `AWS::EC2::VPNConnection.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * `AWS::EC2::VPNConnection.TransitGatewayId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-transitgatewayid
         * @param transitGatewayId `AWS::EC2::VPNConnection.TransitGatewayId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder transitGatewayId(final java.lang.String transitGatewayId) {
            this.props.transitGatewayId(transitGatewayId);
            return this;
        }

        /**
         * `AWS::EC2::VPNConnection.VpnGatewayId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpngatewayid
         * @param vpnGatewayId `AWS::EC2::VPNConnection.VpnGatewayId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpnGatewayId(final java.lang.String vpnGatewayId) {
            this.props.vpnGatewayId(vpnGatewayId);
            return this;
        }

        /**
         * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
         * @param vpnTunnelOptionsSpecifications `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpnTunnelOptionsSpecifications(final software.amazon.awscdk.core.IResolvable vpnTunnelOptionsSpecifications) {
            this.props.vpnTunnelOptionsSpecifications(vpnTunnelOptionsSpecifications);
            return this;
        }
        /**
         * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
         * @param vpnTunnelOptionsSpecifications `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpnTunnelOptionsSpecifications(final java.util.List<java.lang.Object> vpnTunnelOptionsSpecifications) {
            this.props.vpnTunnelOptionsSpecifications(vpnTunnelOptionsSpecifications);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnVPNConnection}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.ec2.CfnVPNConnection build() {
            return new software.amazon.awscdk.services.ec2.CfnVPNConnection(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
