package software.amazon.awscdk.services.ec2;

/**
 * Properties of a VPC Flow Log.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.0 (build 8ae966b)", date = "2020-04-17T19:11:19.211Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.FlowLogProps")
@software.amazon.jsii.Jsii.Proxy(FlowLogProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FlowLogProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.FlowLogOptions {

    /**
     * The type of resource for which to create the flow log.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogResourceType getResourceType();

    /**
     * The name of the FlowLog.
     * <p>
     * It is not recommended to use an explicit name.
     * <p>
     * Default: If you don't specify a flowLogName, AWS CloudFormation generates a
     * unique physical ID and uses that ID for the group name.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getFlowLogName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.FlowLogResourceType resourceType;
        private java.lang.String flowLogName;
        private software.amazon.awscdk.services.ec2.FlowLogDestination destination;
        private software.amazon.awscdk.services.ec2.FlowLogTrafficType trafficType;

        /**
         * Sets the value of {@link FlowLogProps#getResourceType}
         * @param resourceType The type of resource for which to create the flow log. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resourceType(software.amazon.awscdk.services.ec2.FlowLogResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogProps#getFlowLogName}
         * @param flowLogName The name of the FlowLog.
         *                    It is not recommended to use an explicit name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder flowLogName(java.lang.String flowLogName) {
            this.flowLogName = flowLogName;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogProps#getDestination}
         * @param destination Specifies the type of destination to which the flow log data is to be published.
         *                    Flow log data can be published to CloudWatch Logs or Amazon S3
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder destination(software.amazon.awscdk.services.ec2.FlowLogDestination destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogProps#getTrafficType}
         * @param trafficType The type of traffic to log.
         *                    You can log traffic that the resource accepts or rejects, or all traffic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder trafficType(software.amazon.awscdk.services.ec2.FlowLogTrafficType trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FlowLogProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public FlowLogProps build() {
            return new Jsii$Proxy(resourceType, flowLogName, destination, trafficType);
        }
    }

    /**
     * An implementation for {@link FlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowLogProps {
        private final software.amazon.awscdk.services.ec2.FlowLogResourceType resourceType;
        private final java.lang.String flowLogName;
        private final software.amazon.awscdk.services.ec2.FlowLogDestination destination;
        private final software.amazon.awscdk.services.ec2.FlowLogTrafficType trafficType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceType = this.jsiiGet("resourceType", software.amazon.awscdk.services.ec2.FlowLogResourceType.class);
            this.flowLogName = this.jsiiGet("flowLogName", java.lang.String.class);
            this.destination = this.jsiiGet("destination", software.amazon.awscdk.services.ec2.FlowLogDestination.class);
            this.trafficType = this.jsiiGet("trafficType", software.amazon.awscdk.services.ec2.FlowLogTrafficType.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.FlowLogResourceType resourceType, final java.lang.String flowLogName, final software.amazon.awscdk.services.ec2.FlowLogDestination destination, final software.amazon.awscdk.services.ec2.FlowLogTrafficType trafficType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceType = java.util.Objects.requireNonNull(resourceType, "resourceType is required");
            this.flowLogName = flowLogName;
            this.destination = destination;
            this.trafficType = trafficType;
        }

        @Override
        public software.amazon.awscdk.services.ec2.FlowLogResourceType getResourceType() {
            return this.resourceType;
        }

        @Override
        public java.lang.String getFlowLogName() {
            return this.flowLogName;
        }

        @Override
        public software.amazon.awscdk.services.ec2.FlowLogDestination getDestination() {
            return this.destination;
        }

        @Override
        public software.amazon.awscdk.services.ec2.FlowLogTrafficType getTrafficType() {
            return this.trafficType;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceType", om.valueToTree(this.getResourceType()));
            if (this.getFlowLogName() != null) {
                data.set("flowLogName", om.valueToTree(this.getFlowLogName()));
            }
            if (this.getDestination() != null) {
                data.set("destination", om.valueToTree(this.getDestination()));
            }
            if (this.getTrafficType() != null) {
                data.set("trafficType", om.valueToTree(this.getTrafficType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.FlowLogProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FlowLogProps.Jsii$Proxy that = (FlowLogProps.Jsii$Proxy) o;

            if (!resourceType.equals(that.resourceType)) return false;
            if (this.flowLogName != null ? !this.flowLogName.equals(that.flowLogName) : that.flowLogName != null) return false;
            if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
            return this.trafficType != null ? this.trafficType.equals(that.trafficType) : that.trafficType == null;
        }

        @Override
        public int hashCode() {
            int result = this.resourceType.hashCode();
            result = 31 * result + (this.flowLogName != null ? this.flowLogName.hashCode() : 0);
            result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
            result = 31 * result + (this.trafficType != null ? this.trafficType.hashCode() : 0);
            return result;
        }
    }
}
