package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::Route`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.1.0 (build df55f5e)", date = "2020-04-19T13:00:05.540Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnRoute")
public class CfnRoute extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnRoute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRoute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnRoute.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::EC2::Route`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnRoute(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnRouteProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::EC2::Route.RouteTableId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getRouteTableId() {
        return this.jsiiGet("routeTableId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Route.RouteTableId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRouteTableId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("routeTableId", java.util.Objects.requireNonNull(value, "routeTableId is required"));
    }

    /**
     * `AWS::EC2::Route.DestinationCidrBlock`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getDestinationCidrBlock() {
        return this.jsiiGet("destinationCidrBlock", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Route.DestinationCidrBlock`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDestinationCidrBlock(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("destinationCidrBlock", value);
    }

    /**
     * `AWS::EC2::Route.DestinationIpv6CidrBlock`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getDestinationIpv6CidrBlock() {
        return this.jsiiGet("destinationIpv6CidrBlock", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Route.DestinationIpv6CidrBlock`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDestinationIpv6CidrBlock(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("destinationIpv6CidrBlock", value);
    }

    /**
     * `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getEgressOnlyInternetGatewayId() {
        return this.jsiiGet("egressOnlyInternetGatewayId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEgressOnlyInternetGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("egressOnlyInternetGatewayId", value);
    }

    /**
     * `AWS::EC2::Route.GatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getGatewayId() {
        return this.jsiiGet("gatewayId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Route.GatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("gatewayId", value);
    }

    /**
     * `AWS::EC2::Route.InstanceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return this.jsiiGet("instanceId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Route.InstanceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setInstanceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("instanceId", value);
    }

    /**
     * `AWS::EC2::Route.NatGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getNatGatewayId() {
        return this.jsiiGet("natGatewayId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Route.NatGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNatGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("natGatewayId", value);
    }

    /**
     * `AWS::EC2::Route.NetworkInterfaceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getNetworkInterfaceId() {
        return this.jsiiGet("networkInterfaceId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Route.NetworkInterfaceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNetworkInterfaceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("networkInterfaceId", value);
    }

    /**
     * `AWS::EC2::Route.TransitGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayId() {
        return this.jsiiGet("transitGatewayId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Route.TransitGatewayId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTransitGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("transitGatewayId", value);
    }

    /**
     * `AWS::EC2::Route.VpcPeeringConnectionId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcPeeringConnectionId() {
        return this.jsiiGet("vpcPeeringConnectionId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Route.VpcPeeringConnectionId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVpcPeeringConnectionId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("vpcPeeringConnectionId", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnRoute}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnRouteProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnRouteProps.Builder();
        }

        /**
         * `AWS::EC2::Route.RouteTableId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
         * @param routeTableId `AWS::EC2::Route.RouteTableId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder routeTableId(final java.lang.String routeTableId) {
            this.props.routeTableId(routeTableId);
            return this;
        }

        /**
         * `AWS::EC2::Route.DestinationCidrBlock`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
         * @param destinationCidrBlock `AWS::EC2::Route.DestinationCidrBlock`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder destinationCidrBlock(final java.lang.String destinationCidrBlock) {
            this.props.destinationCidrBlock(destinationCidrBlock);
            return this;
        }

        /**
         * `AWS::EC2::Route.DestinationIpv6CidrBlock`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
         * @param destinationIpv6CidrBlock `AWS::EC2::Route.DestinationIpv6CidrBlock`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder destinationIpv6CidrBlock(final java.lang.String destinationIpv6CidrBlock) {
            this.props.destinationIpv6CidrBlock(destinationIpv6CidrBlock);
            return this;
        }

        /**
         * `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
         * @param egressOnlyInternetGatewayId `AWS::EC2::Route.EgressOnlyInternetGatewayId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder egressOnlyInternetGatewayId(final java.lang.String egressOnlyInternetGatewayId) {
            this.props.egressOnlyInternetGatewayId(egressOnlyInternetGatewayId);
            return this;
        }

        /**
         * `AWS::EC2::Route.GatewayId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
         * @param gatewayId `AWS::EC2::Route.GatewayId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder gatewayId(final java.lang.String gatewayId) {
            this.props.gatewayId(gatewayId);
            return this;
        }

        /**
         * `AWS::EC2::Route.InstanceId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
         * @param instanceId `AWS::EC2::Route.InstanceId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instanceId(final java.lang.String instanceId) {
            this.props.instanceId(instanceId);
            return this;
        }

        /**
         * `AWS::EC2::Route.NatGatewayId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
         * @param natGatewayId `AWS::EC2::Route.NatGatewayId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder natGatewayId(final java.lang.String natGatewayId) {
            this.props.natGatewayId(natGatewayId);
            return this;
        }

        /**
         * `AWS::EC2::Route.NetworkInterfaceId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
         * @param networkInterfaceId `AWS::EC2::Route.NetworkInterfaceId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder networkInterfaceId(final java.lang.String networkInterfaceId) {
            this.props.networkInterfaceId(networkInterfaceId);
            return this;
        }

        /**
         * `AWS::EC2::Route.TransitGatewayId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
         * @param transitGatewayId `AWS::EC2::Route.TransitGatewayId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder transitGatewayId(final java.lang.String transitGatewayId) {
            this.props.transitGatewayId(transitGatewayId);
            return this;
        }

        /**
         * `AWS::EC2::Route.VpcPeeringConnectionId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
         * @param vpcPeeringConnectionId `AWS::EC2::Route.VpcPeeringConnectionId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpcPeeringConnectionId(final java.lang.String vpcPeeringConnectionId) {
            this.props.vpcPeeringConnectionId(vpcPeeringConnectionId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnRoute}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.ec2.CfnRoute build() {
            return new software.amazon.awscdk.services.ec2.CfnRoute(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
