package software.amazon.awscdk.services.ec2;

/**
 * Flow Log Destination configuration.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.1.0 (build df55f5e)", date = "2020-04-19T13:00:05.572Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.FlowLogDestinationConfig")
@software.amazon.jsii.Jsii.Proxy(FlowLogDestinationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FlowLogDestinationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of destination to publish the flow logs to.
     * <p>
     * Default: - CLOUD_WATCH_LOGS
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.FlowLogDestinationType getLogDestinationType();

    /**
     * The IAM Role that has access to publish to CloudWatch logs.
     * <p>
     * Default: - default IAM role is created for you
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getIamRole() {
        return null;
    }

    /**
     * The CloudWatch Logs Log Group to publish the flow logs to.
     * <p>
     * Default: - default log group is created for you
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return null;
    }

    /**
     * S3 bucket to publish the flow logs to.
     * <p>
     * Default: - undefined
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getS3Bucket() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FlowLogDestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FlowLogDestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.FlowLogDestinationType logDestinationType;
        private software.amazon.awscdk.services.iam.IRole iamRole;
        private software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private software.amazon.awscdk.services.s3.IBucket s3Bucket;

        /**
         * Sets the value of {@link FlowLogDestinationConfig#getLogDestinationType}
         * @param logDestinationType The type of destination to publish the flow logs to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logDestinationType(software.amazon.awscdk.services.ec2.FlowLogDestinationType logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogDestinationConfig#getIamRole}
         * @param iamRole The IAM Role that has access to publish to CloudWatch logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder iamRole(software.amazon.awscdk.services.iam.IRole iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogDestinationConfig#getLogGroup}
         * @param logGroup The CloudWatch Logs Log Group to publish the flow logs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link FlowLogDestinationConfig#getS3Bucket}
         * @param s3Bucket S3 bucket to publish the flow logs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3Bucket(software.amazon.awscdk.services.s3.IBucket s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FlowLogDestinationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public FlowLogDestinationConfig build() {
            return new Jsii$Proxy(logDestinationType, iamRole, logGroup, s3Bucket);
        }
    }

    /**
     * An implementation for {@link FlowLogDestinationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowLogDestinationConfig {
        private final software.amazon.awscdk.services.ec2.FlowLogDestinationType logDestinationType;
        private final software.amazon.awscdk.services.iam.IRole iamRole;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final software.amazon.awscdk.services.s3.IBucket s3Bucket;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logDestinationType = this.jsiiGet("logDestinationType", software.amazon.awscdk.services.ec2.FlowLogDestinationType.class);
            this.iamRole = this.jsiiGet("iamRole", software.amazon.awscdk.services.iam.IRole.class);
            this.logGroup = this.jsiiGet("logGroup", software.amazon.awscdk.services.logs.ILogGroup.class);
            this.s3Bucket = this.jsiiGet("s3Bucket", software.amazon.awscdk.services.s3.IBucket.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.FlowLogDestinationType logDestinationType, final software.amazon.awscdk.services.iam.IRole iamRole, final software.amazon.awscdk.services.logs.ILogGroup logGroup, final software.amazon.awscdk.services.s3.IBucket s3Bucket) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logDestinationType = java.util.Objects.requireNonNull(logDestinationType, "logDestinationType is required");
            this.iamRole = iamRole;
            this.logGroup = logGroup;
            this.s3Bucket = s3Bucket;
        }

        @Override
        public software.amazon.awscdk.services.ec2.FlowLogDestinationType getLogDestinationType() {
            return this.logDestinationType;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getIamRole() {
            return this.iamRole;
        }

        @Override
        public software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public software.amazon.awscdk.services.s3.IBucket getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logDestinationType", om.valueToTree(this.getLogDestinationType()));
            if (this.getIamRole() != null) {
                data.set("iamRole", om.valueToTree(this.getIamRole()));
            }
            if (this.getLogGroup() != null) {
                data.set("logGroup", om.valueToTree(this.getLogGroup()));
            }
            if (this.getS3Bucket() != null) {
                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.FlowLogDestinationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FlowLogDestinationConfig.Jsii$Proxy that = (FlowLogDestinationConfig.Jsii$Proxy) o;

            if (!logDestinationType.equals(that.logDestinationType)) return false;
            if (this.iamRole != null ? !this.iamRole.equals(that.iamRole) : that.iamRole != null) return false;
            if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
            return this.s3Bucket != null ? this.s3Bucket.equals(that.s3Bucket) : that.s3Bucket == null;
        }

        @Override
        public int hashCode() {
            int result = this.logDestinationType.hashCode();
            result = 31 * result + (this.iamRole != null ? this.iamRole.hashCode() : 0);
            result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
            result = 31 * result + (this.s3Bucket != null ? this.s3Bucket.hashCode() : 0);
            return result;
        }
    }
}
