package software.amazon.awscdk.services.ec2;

/**
 * Properties to create NetworkAcl.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.1.0 (build df55f5e)", date = "2020-04-19T13:00:05.599Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.NetworkAclProps")
@software.amazon.jsii.Jsii.Proxy(NetworkAclProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface NetworkAclProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The VPC in which to create the NetworkACL.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * The name of the NetworkAcl.
     * <p>
     * It is not recommended to use an explicit name.
     * <p>
     * Default: If you don't specify a networkAclName, AWS CloudFormation generates a
     * unique physical ID and uses that ID for the group name.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkAclName() {
        return null;
    }

    /**
     * Subnets in the given VPC to associate the ACL with.
     * <p>
     * More subnets can always be added later by calling
     * <code>associateWithSubnets()</code>.
     * <p>
     * Default: - No subnets associated
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkAclProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkAclProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.lang.String networkAclName;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;

        /**
         * Sets the value of {@link NetworkAclProps#getVpc}
         * @param vpc The VPC in which to create the NetworkACL. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link NetworkAclProps#getNetworkAclName}
         * @param networkAclName The name of the NetworkAcl.
         *                       It is not recommended to use an explicit name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder networkAclName(java.lang.String networkAclName) {
            this.networkAclName = networkAclName;
            return this;
        }

        /**
         * Sets the value of {@link NetworkAclProps#getSubnetSelection}
         * @param subnetSelection Subnets in the given VPC to associate the ACL with.
         *                        More subnets can always be added later by calling
         *                        <code>associateWithSubnets()</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkAclProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public NetworkAclProps build() {
            return new Jsii$Proxy(vpc, networkAclName, subnetSelection);
        }
    }

    /**
     * An implementation for {@link NetworkAclProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkAclProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.String networkAclName;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.networkAclName = this.jsiiGet("networkAclName", java.lang.String.class);
            this.subnetSelection = this.jsiiGet("subnetSelection", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.IVpc vpc, final java.lang.String networkAclName, final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.networkAclName = networkAclName;
            this.subnetSelection = subnetSelection;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public java.lang.String getNetworkAclName() {
            return this.networkAclName;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getNetworkAclName() != null) {
                data.set("networkAclName", om.valueToTree(this.getNetworkAclName()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.NetworkAclProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkAclProps.Jsii$Proxy that = (NetworkAclProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (this.networkAclName != null ? !this.networkAclName.equals(that.networkAclName) : that.networkAclName != null) return false;
            return this.subnetSelection != null ? this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection == null;
        }

        @Override
        public int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.networkAclName != null ? this.networkAclName.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            return result;
        }
    }
}
