package software.amazon.awscdk.services.ec2;

/**
 * Interface for security group-like objects.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.2 (build 237c474)", date = "2020-04-21T17:16:08.445Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.ISecurityGroup")
@software.amazon.jsii.Jsii.Proxy(ISecurityGroup.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ISecurityGroup extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource, software.amazon.awscdk.services.ec2.IPeer {

    /**
     * Whether the SecurityGroup has been configured to allow all outbound traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getAllowAllOutbound();

    /**
     * ID for the current security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupId();

    /**
     * Add an egress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     * @param remoteRule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description, final @org.jetbrains.annotations.Nullable java.lang.Boolean remoteRule);

    /**
     * Add an egress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description);

    /**
     * Add an egress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection);

    /**
     * Add an ingress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     * @param remoteRule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description, final @org.jetbrains.annotations.Nullable java.lang.Boolean remoteRule);

    /**
     * Add an ingress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     * @param description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description);

    /**
     * Add an ingress rule for the current security group.
     * <p>
     * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
     * securityGroup and they are in different stack. If false (default) the
     * rule object is created under the current SecurityGroup object. If true and the
     * peer is also a SecurityGroup, the rule object is created under the remote
     * SecurityGroup object.
     * <p>
     * @param peer This parameter is required.
     * @param connection This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.ISecurityGroup {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Whether the SecurityGroup has been configured to allow all outbound traffic.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.Boolean getAllowAllOutbound() {
            return this.jsiiGet("allowAllOutbound", java.lang.Boolean.class);
        }

        /**
         * ID for the current security group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupId() {
            return this.jsiiGet("securityGroupId", java.lang.String.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Whether the rule can be inlined into a SecurityGroup or not.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.Boolean getCanInlineRule() {
            return this.jsiiGet("canInlineRule", java.lang.Boolean.class);
        }

        /**
         * A unique identifier for this connection peer.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getUniqueId() {
            return this.jsiiGet("uniqueId", java.lang.String.class);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
            return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
        }

        /**
         * Add an egress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         * @param description
         * @param remoteRule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description, final @org.jetbrains.annotations.Nullable java.lang.Boolean remoteRule) {
            this.jsiiCall("addEgressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description, remoteRule });
        }

        /**
         * Add an egress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         * @param description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description) {
            this.jsiiCall("addEgressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description });
        }

        /**
         * Add an egress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addEgressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection) {
            this.jsiiCall("addEgressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required") });
        }

        /**
         * Add an ingress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         * @param description
         * @param remoteRule
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description, final @org.jetbrains.annotations.Nullable java.lang.Boolean remoteRule) {
            this.jsiiCall("addIngressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description, remoteRule });
        }

        /**
         * Add an ingress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         * @param description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection, final @org.jetbrains.annotations.Nullable java.lang.String description) {
            this.jsiiCall("addIngressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required"), description });
        }

        /**
         * Add an ingress rule for the current security group.
         * <p>
         * <code>remoteRule</code> controls where the Rule object is created if the peer is also a
         * securityGroup and they are in different stack. If false (default) the
         * rule object is created under the current SecurityGroup object. If true and the
         * peer is also a SecurityGroup, the rule object is created under the remote
         * SecurityGroup object.
         * <p>
         * @param peer This parameter is required.
         * @param connection This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public void addIngressRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IPeer peer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port connection) {
            this.jsiiCall("addIngressRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(peer, "peer is required"), java.util.Objects.requireNonNull(connection, "connection is required") });
        }

        /**
         * Produce the egress rule JSON for the given connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.Object toEgressRuleConfig() {
            return this.jsiiCall("toEgressRuleConfig", java.lang.Object.class);
        }

        /**
         * Produce the ingress rule JSON for the given connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull java.lang.Object toIngressRuleConfig() {
            return this.jsiiCall("toIngressRuleConfig", java.lang.Object.class);
        }
    }
}
