/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Stack;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.BastionHostLinuxProps;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IInstance;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.IPeer;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.Instance;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.BastionHostLinux")
public class BastionHostLinux
extends Construct
implements IInstance {
    protected BastionHostLinux(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BastionHostLinux(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public BastionHostLinux(@NotNull Construct scope, @NotNull String id, @NotNull BastionHostLinuxProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void allowSshAccessFrom(IPeer ... peer) {
        this.jsiiCall("allowSshAccessFrom", NativeType.VOID, Arrays.stream(peer).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)this.jsiiGet("grantPrincipal", IPrincipal.class);
    }

    @NotNull
    public Instance getInstance() {
        return (Instance)this.jsiiGet("instance", Instance.class);
    }

    @Override
    @NotNull
    public String getInstanceAvailabilityZone() {
        return (String)this.jsiiGet("instanceAvailabilityZone", String.class);
    }

    @Override
    @NotNull
    public String getInstanceId() {
        return (String)this.jsiiGet("instanceId", String.class);
    }

    @Override
    @NotNull
    public String getInstancePrivateDnsName() {
        return (String)this.jsiiGet("instancePrivateDnsName", String.class);
    }

    @Override
    @NotNull
    public String getInstancePrivateIp() {
        return (String)this.jsiiGet("instancePrivateIp", String.class);
    }

    @Override
    @NotNull
    public String getInstancePublicDnsName() {
        return (String)this.jsiiGet("instancePublicDnsName", String.class);
    }

    @Override
    @NotNull
    public String getInstancePublicIp() {
        return (String)this.jsiiGet("instancePublicIp", String.class);
    }

    @NotNull
    public IRole getRole() {
        return (IRole)this.jsiiGet("role", IRole.class);
    }

    @NotNull
    public Stack getStack() {
        return (Stack)this.jsiiGet("stack", Stack.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final BastionHostLinuxProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new BastionHostLinuxProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.props.instanceName(instanceName);
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder machineImage(IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public BastionHostLinux build() {
            return new BastionHostLinux(this.scope, this.id, this.props.build());
        }
    }
}

