/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.;
import software.amazon.awscdk.services.ec2.CommonNetworkAclEntryOptions;
import software.amazon.awscdk.services.ec2.INetworkAcl;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.NetworkAclEntry;
import software.amazon.awscdk.services.ec2.NetworkAclProps;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ec2.NetworkAcl")
public class NetworkAcl
extends Resource
implements INetworkAcl {
    protected NetworkAcl(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkAcl(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NetworkAcl(@NotNull Construct scope, @NotNull String id, @NotNull NetworkAclProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static INetworkAcl fromNetworkAclId(@NotNull Construct scope, @NotNull String id, @NotNull String networkAclId) {
        return (INetworkAcl)JsiiObject.jsiiStaticCall(NetworkAcl.class, (String)"fromNetworkAclId", INetworkAcl.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(networkAclId, "networkAclId is required")});
    }

    @Override
    @NotNull
    public NetworkAclEntry addEntry(@NotNull String id, @NotNull CommonNetworkAclEntryOptions options) {
        return (NetworkAclEntry)this.jsiiCall("addEntry", NetworkAclEntry.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    public void associateWithSubnet(@NotNull String id, @NotNull SubnetSelection selection) {
        this.jsiiCall("associateWithSubnet", NativeType.VOID, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(selection, "selection is required")});
    }

    @Override
    @NotNull
    public String getNetworkAclId() {
        return (String)this.jsiiGet("networkAclId", String.class);
    }

    @NotNull
    public String getNetworkAclVpcId() {
        return (String)this.jsiiGet("networkAclVpcId", String.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final NetworkAclProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new NetworkAclProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder networkAclName(String networkAclName) {
            this.props.networkAclName(networkAclName);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public NetworkAcl build() {
            return new NetworkAcl(this.scope, this.id, this.props.build());
        }
    }
}

