package software.amazon.awscdk.services.ec2;

/**
 * Options for adding a new route to a subnet.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-28T11:04:06.120Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.AddRouteOptions")
@software.amazon.jsii.Jsii.Proxy(AddRouteOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddRouteOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the router.
     * <p>
     * Can be an instance ID, gateway ID, etc, depending on the router type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouterId();

    /**
     * What type of router to route this traffic to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.RouterType getRouterType();

    /**
     * IPv4 range this route applies to.
     * <p>
     * Default: '0.0.0.0/0'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationCidrBlock() {
        return null;
    }

    /**
     * IPv6 range this route applies to.
     * <p>
     * Default: - Uses IPv6
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationIpv6CidrBlock() {
        return null;
    }

    /**
     * Whether this route will enable internet connectivity.
     * <p>
     * If true, this route will be added before any AWS resources that depend
     * on internet connectivity in the VPC will be created.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnablesInternetConnectivity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String routerId;
        private software.amazon.awscdk.services.ec2.RouterType routerType;
        private java.lang.String destinationCidrBlock;
        private java.lang.String destinationIpv6CidrBlock;
        private java.lang.Boolean enablesInternetConnectivity;

        /**
         * Sets the value of {@link AddRouteOptions#getRouterId}
         * @param routerId The ID of the router. This parameter is required.
         *                 Can be an instance ID, gateway ID, etc, depending on the router type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routerId(java.lang.String routerId) {
            this.routerId = routerId;
            return this;
        }

        /**
         * Sets the value of {@link AddRouteOptions#getRouterType}
         * @param routerType What type of router to route this traffic to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routerType(software.amazon.awscdk.services.ec2.RouterType routerType) {
            this.routerType = routerType;
            return this;
        }

        /**
         * Sets the value of {@link AddRouteOptions#getDestinationCidrBlock}
         * @param destinationCidrBlock IPv4 range this route applies to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationCidrBlock(java.lang.String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link AddRouteOptions#getDestinationIpv6CidrBlock}
         * @param destinationIpv6CidrBlock IPv6 range this route applies to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationIpv6CidrBlock(java.lang.String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link AddRouteOptions#getEnablesInternetConnectivity}
         * @param enablesInternetConnectivity Whether this route will enable internet connectivity.
         *                                    If true, this route will be added before any AWS resources that depend
         *                                    on internet connectivity in the VPC will be created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablesInternetConnectivity(java.lang.Boolean enablesInternetConnectivity) {
            this.enablesInternetConnectivity = enablesInternetConnectivity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddRouteOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AddRouteOptions build() {
            return new Jsii$Proxy(routerId, routerType, destinationCidrBlock, destinationIpv6CidrBlock, enablesInternetConnectivity);
        }
    }

    /**
     * An implementation for {@link AddRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddRouteOptions {
        private final java.lang.String routerId;
        private final software.amazon.awscdk.services.ec2.RouterType routerType;
        private final java.lang.String destinationCidrBlock;
        private final java.lang.String destinationIpv6CidrBlock;
        private final java.lang.Boolean enablesInternetConnectivity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.routerId = this.jsiiGet("routerId", java.lang.String.class);
            this.routerType = this.jsiiGet("routerType", software.amazon.awscdk.services.ec2.RouterType.class);
            this.destinationCidrBlock = this.jsiiGet("destinationCidrBlock", java.lang.String.class);
            this.destinationIpv6CidrBlock = this.jsiiGet("destinationIpv6CidrBlock", java.lang.String.class);
            this.enablesInternetConnectivity = this.jsiiGet("enablesInternetConnectivity", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String routerId, final software.amazon.awscdk.services.ec2.RouterType routerType, final java.lang.String destinationCidrBlock, final java.lang.String destinationIpv6CidrBlock, final java.lang.Boolean enablesInternetConnectivity) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routerId = java.util.Objects.requireNonNull(routerId, "routerId is required");
            this.routerType = java.util.Objects.requireNonNull(routerType, "routerType is required");
            this.destinationCidrBlock = destinationCidrBlock;
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            this.enablesInternetConnectivity = enablesInternetConnectivity;
        }

        @Override
        public java.lang.String getRouterId() {
            return this.routerId;
        }

        @Override
        public software.amazon.awscdk.services.ec2.RouterType getRouterType() {
            return this.routerType;
        }

        @Override
        public java.lang.String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public java.lang.String getDestinationIpv6CidrBlock() {
            return this.destinationIpv6CidrBlock;
        }

        @Override
        public java.lang.Boolean getEnablesInternetConnectivity() {
            return this.enablesInternetConnectivity;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("routerId", om.valueToTree(this.getRouterId()));
            data.set("routerType", om.valueToTree(this.getRouterType()));
            if (this.getDestinationCidrBlock() != null) {
                data.set("destinationCidrBlock", om.valueToTree(this.getDestinationCidrBlock()));
            }
            if (this.getDestinationIpv6CidrBlock() != null) {
                data.set("destinationIpv6CidrBlock", om.valueToTree(this.getDestinationIpv6CidrBlock()));
            }
            if (this.getEnablesInternetConnectivity() != null) {
                data.set("enablesInternetConnectivity", om.valueToTree(this.getEnablesInternetConnectivity()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.AddRouteOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddRouteOptions.Jsii$Proxy that = (AddRouteOptions.Jsii$Proxy) o;

            if (!routerId.equals(that.routerId)) return false;
            if (!routerType.equals(that.routerType)) return false;
            if (this.destinationCidrBlock != null ? !this.destinationCidrBlock.equals(that.destinationCidrBlock) : that.destinationCidrBlock != null) return false;
            if (this.destinationIpv6CidrBlock != null ? !this.destinationIpv6CidrBlock.equals(that.destinationIpv6CidrBlock) : that.destinationIpv6CidrBlock != null) return false;
            return this.enablesInternetConnectivity != null ? this.enablesInternetConnectivity.equals(that.enablesInternetConnectivity) : that.enablesInternetConnectivity == null;
        }

        @Override
        public int hashCode() {
            int result = this.routerId.hashCode();
            result = 31 * result + (this.routerType.hashCode());
            result = 31 * result + (this.destinationCidrBlock != null ? this.destinationCidrBlock.hashCode() : 0);
            result = 31 * result + (this.destinationIpv6CidrBlock != null ? this.destinationIpv6CidrBlock.hashCode() : 0);
            result = 31 * result + (this.enablesInternetConnectivity != null ? this.enablesInternetConnectivity.hashCode() : 0);
            return result;
        }
    }
}
