package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::SecurityGroup`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-28T11:04:06.193Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSecurityGroup")
public class CfnSecurityGroup extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnSecurityGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSecurityGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnSecurityGroup.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::EC2::SecurityGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnSecurityGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnSecurityGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGroupId() {
        return this.jsiiGet("attrGroupId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVpcId() {
        return this.jsiiGet("attrVpcId", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::EC2::SecurityGroup.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.GroupDescription`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getGroupDescription() {
        return this.jsiiGet("groupDescription", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.GroupDescription`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setGroupDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("groupDescription", java.util.Objects.requireNonNull(value, "groupDescription is required"));
    }

    /**
     * `AWS::EC2::SecurityGroup.GroupName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
        return this.jsiiGet("groupName", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.GroupName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("groupName", value);
    }

    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSecurityGroupEgress() {
        return this.jsiiGet("securityGroupEgress", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroupEgress(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("securityGroupEgress", value);
    }

    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroupEgress(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("securityGroupEgress", value);
    }

    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSecurityGroupIngress() {
        return this.jsiiGet("securityGroupIngress", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroupIngress(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("securityGroupIngress", value);
    }

    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroupIngress(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("securityGroupIngress", value);
    }

    /**
     * `AWS::EC2::SecurityGroup.VpcId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return this.jsiiGet("vpcId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroup.VpcId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVpcId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("vpcId", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSecurityGroup.EgressProperty")
    @software.amazon.jsii.Jsii.Proxy(EgressProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EgressProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSecurityGroup.EgressProperty.IpProtocol`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getIpProtocol();

        /**
         * `CfnSecurityGroup.EgressProperty.CidrIp`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getCidrIp() {
            return null;
        }

        /**
         * `CfnSecurityGroup.EgressProperty.CidrIpv6`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getCidrIpv6() {
            return null;
        }

        /**
         * `CfnSecurityGroup.EgressProperty.Description`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationPrefixListId() {
            return null;
        }

        /**
         * `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationSecurityGroupId() {
            return null;
        }

        /**
         * `CfnSecurityGroup.EgressProperty.FromPort`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFromPort() {
            return null;
        }

        /**
         * `CfnSecurityGroup.EgressProperty.ToPort`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Number getToPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EgressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EgressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String ipProtocol;
            private java.lang.String cidrIp;
            private java.lang.String cidrIpv6;
            private java.lang.String description;
            private java.lang.String destinationPrefixListId;
            private java.lang.String destinationSecurityGroupId;
            private java.lang.Number fromPort;
            private java.lang.Number toPort;

            /**
             * Sets the value of {@link EgressProperty#getIpProtocol}
             * @param ipProtocol `CfnSecurityGroup.EgressProperty.IpProtocol`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ipProtocol(java.lang.String ipProtocol) {
                this.ipProtocol = ipProtocol;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getCidrIp}
             * @param cidrIp `CfnSecurityGroup.EgressProperty.CidrIp`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cidrIp(java.lang.String cidrIp) {
                this.cidrIp = cidrIp;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getCidrIpv6}
             * @param cidrIpv6 `CfnSecurityGroup.EgressProperty.CidrIpv6`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cidrIpv6(java.lang.String cidrIpv6) {
                this.cidrIpv6 = cidrIpv6;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getDescription}
             * @param description `CfnSecurityGroup.EgressProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getDestinationPrefixListId}
             * @param destinationPrefixListId `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destinationPrefixListId(java.lang.String destinationPrefixListId) {
                this.destinationPrefixListId = destinationPrefixListId;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getDestinationSecurityGroupId}
             * @param destinationSecurityGroupId `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destinationSecurityGroupId(java.lang.String destinationSecurityGroupId) {
                this.destinationSecurityGroupId = destinationSecurityGroupId;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getFromPort}
             * @param fromPort `CfnSecurityGroup.EgressProperty.FromPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder fromPort(java.lang.Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            /**
             * Sets the value of {@link EgressProperty#getToPort}
             * @param toPort `CfnSecurityGroup.EgressProperty.ToPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder toPort(java.lang.Number toPort) {
                this.toPort = toPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EgressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EgressProperty build() {
                return new Jsii$Proxy(ipProtocol, cidrIp, cidrIpv6, description, destinationPrefixListId, destinationSecurityGroupId, fromPort, toPort);
            }
        }

        /**
         * An implementation for {@link EgressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EgressProperty {
            private final java.lang.String ipProtocol;
            private final java.lang.String cidrIp;
            private final java.lang.String cidrIpv6;
            private final java.lang.String description;
            private final java.lang.String destinationPrefixListId;
            private final java.lang.String destinationSecurityGroupId;
            private final java.lang.Number fromPort;
            private final java.lang.Number toPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipProtocol = this.jsiiGet("ipProtocol", java.lang.String.class);
                this.cidrIp = this.jsiiGet("cidrIp", java.lang.String.class);
                this.cidrIpv6 = this.jsiiGet("cidrIpv6", java.lang.String.class);
                this.description = this.jsiiGet("description", java.lang.String.class);
                this.destinationPrefixListId = this.jsiiGet("destinationPrefixListId", java.lang.String.class);
                this.destinationSecurityGroupId = this.jsiiGet("destinationSecurityGroupId", java.lang.String.class);
                this.fromPort = this.jsiiGet("fromPort", java.lang.Number.class);
                this.toPort = this.jsiiGet("toPort", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String ipProtocol, final java.lang.String cidrIp, final java.lang.String cidrIpv6, final java.lang.String description, final java.lang.String destinationPrefixListId, final java.lang.String destinationSecurityGroupId, final java.lang.Number fromPort, final java.lang.Number toPort) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipProtocol = java.util.Objects.requireNonNull(ipProtocol, "ipProtocol is required");
                this.cidrIp = cidrIp;
                this.cidrIpv6 = cidrIpv6;
                this.description = description;
                this.destinationPrefixListId = destinationPrefixListId;
                this.destinationSecurityGroupId = destinationSecurityGroupId;
                this.fromPort = fromPort;
                this.toPort = toPort;
            }

            @Override
            public java.lang.String getIpProtocol() {
                return this.ipProtocol;
            }

            @Override
            public java.lang.String getCidrIp() {
                return this.cidrIp;
            }

            @Override
            public java.lang.String getCidrIpv6() {
                return this.cidrIpv6;
            }

            @Override
            public java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public java.lang.String getDestinationPrefixListId() {
                return this.destinationPrefixListId;
            }

            @Override
            public java.lang.String getDestinationSecurityGroupId() {
                return this.destinationSecurityGroupId;
            }

            @Override
            public java.lang.Number getFromPort() {
                return this.fromPort;
            }

            @Override
            public java.lang.Number getToPort() {
                return this.toPort;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ipProtocol", om.valueToTree(this.getIpProtocol()));
                if (this.getCidrIp() != null) {
                    data.set("cidrIp", om.valueToTree(this.getCidrIp()));
                }
                if (this.getCidrIpv6() != null) {
                    data.set("cidrIpv6", om.valueToTree(this.getCidrIpv6()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getDestinationPrefixListId() != null) {
                    data.set("destinationPrefixListId", om.valueToTree(this.getDestinationPrefixListId()));
                }
                if (this.getDestinationSecurityGroupId() != null) {
                    data.set("destinationSecurityGroupId", om.valueToTree(this.getDestinationSecurityGroupId()));
                }
                if (this.getFromPort() != null) {
                    data.set("fromPort", om.valueToTree(this.getFromPort()));
                }
                if (this.getToPort() != null) {
                    data.set("toPort", om.valueToTree(this.getToPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSecurityGroup.EgressProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EgressProperty.Jsii$Proxy that = (EgressProperty.Jsii$Proxy) o;

                if (!ipProtocol.equals(that.ipProtocol)) return false;
                if (this.cidrIp != null ? !this.cidrIp.equals(that.cidrIp) : that.cidrIp != null) return false;
                if (this.cidrIpv6 != null ? !this.cidrIpv6.equals(that.cidrIpv6) : that.cidrIpv6 != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.destinationPrefixListId != null ? !this.destinationPrefixListId.equals(that.destinationPrefixListId) : that.destinationPrefixListId != null) return false;
                if (this.destinationSecurityGroupId != null ? !this.destinationSecurityGroupId.equals(that.destinationSecurityGroupId) : that.destinationSecurityGroupId != null) return false;
                if (this.fromPort != null ? !this.fromPort.equals(that.fromPort) : that.fromPort != null) return false;
                return this.toPort != null ? this.toPort.equals(that.toPort) : that.toPort == null;
            }

            @Override
            public int hashCode() {
                int result = this.ipProtocol.hashCode();
                result = 31 * result + (this.cidrIp != null ? this.cidrIp.hashCode() : 0);
                result = 31 * result + (this.cidrIpv6 != null ? this.cidrIpv6.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.destinationPrefixListId != null ? this.destinationPrefixListId.hashCode() : 0);
                result = 31 * result + (this.destinationSecurityGroupId != null ? this.destinationSecurityGroupId.hashCode() : 0);
                result = 31 * result + (this.fromPort != null ? this.fromPort.hashCode() : 0);
                result = 31 * result + (this.toPort != null ? this.toPort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSecurityGroup.IngressProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IngressProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSecurityGroup.IngressProperty.IpProtocol`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @org.jetbrains.annotations.NotNull java.lang.String getIpProtocol();

        /**
         * `CfnSecurityGroup.IngressProperty.CidrIp`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getCidrIp() {
            return null;
        }

        /**
         * `CfnSecurityGroup.IngressProperty.CidrIpv6`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getCidrIpv6() {
            return null;
        }

        /**
         * `CfnSecurityGroup.IngressProperty.Description`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * `CfnSecurityGroup.IngressProperty.FromPort`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFromPort() {
            return null;
        }

        /**
         * `CfnSecurityGroup.IngressProperty.SourcePrefixListId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourcePrefixListId() {
            return null;
        }

        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceSecurityGroupId() {
            return null;
        }

        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceSecurityGroupName() {
            return null;
        }

        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceSecurityGroupOwnerId() {
            return null;
        }

        /**
         * `CfnSecurityGroup.IngressProperty.ToPort`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default @org.jetbrains.annotations.Nullable java.lang.Number getToPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IngressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String ipProtocol;
            private java.lang.String cidrIp;
            private java.lang.String cidrIpv6;
            private java.lang.String description;
            private java.lang.Number fromPort;
            private java.lang.String sourcePrefixListId;
            private java.lang.String sourceSecurityGroupId;
            private java.lang.String sourceSecurityGroupName;
            private java.lang.String sourceSecurityGroupOwnerId;
            private java.lang.Number toPort;

            /**
             * Sets the value of {@link IngressProperty#getIpProtocol}
             * @param ipProtocol `CfnSecurityGroup.IngressProperty.IpProtocol`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder ipProtocol(java.lang.String ipProtocol) {
                this.ipProtocol = ipProtocol;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getCidrIp}
             * @param cidrIp `CfnSecurityGroup.IngressProperty.CidrIp`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cidrIp(java.lang.String cidrIp) {
                this.cidrIp = cidrIp;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getCidrIpv6}
             * @param cidrIpv6 `CfnSecurityGroup.IngressProperty.CidrIpv6`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cidrIpv6(java.lang.String cidrIpv6) {
                this.cidrIpv6 = cidrIpv6;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getDescription}
             * @param description `CfnSecurityGroup.IngressProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getFromPort}
             * @param fromPort `CfnSecurityGroup.IngressProperty.FromPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder fromPort(java.lang.Number fromPort) {
                this.fromPort = fromPort;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getSourcePrefixListId}
             * @param sourcePrefixListId `CfnSecurityGroup.IngressProperty.SourcePrefixListId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sourcePrefixListId(java.lang.String sourcePrefixListId) {
                this.sourcePrefixListId = sourcePrefixListId;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getSourceSecurityGroupId}
             * @param sourceSecurityGroupId `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sourceSecurityGroupId(java.lang.String sourceSecurityGroupId) {
                this.sourceSecurityGroupId = sourceSecurityGroupId;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getSourceSecurityGroupName}
             * @param sourceSecurityGroupName `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sourceSecurityGroupName(java.lang.String sourceSecurityGroupName) {
                this.sourceSecurityGroupName = sourceSecurityGroupName;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getSourceSecurityGroupOwnerId}
             * @param sourceSecurityGroupOwnerId `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sourceSecurityGroupOwnerId(java.lang.String sourceSecurityGroupOwnerId) {
                this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getToPort}
             * @param toPort `CfnSecurityGroup.IngressProperty.ToPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder toPort(java.lang.Number toPort) {
                this.toPort = toPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IngressProperty build() {
                return new Jsii$Proxy(ipProtocol, cidrIp, cidrIpv6, description, fromPort, sourcePrefixListId, sourceSecurityGroupId, sourceSecurityGroupName, sourceSecurityGroupOwnerId, toPort);
            }
        }

        /**
         * An implementation for {@link IngressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressProperty {
            private final java.lang.String ipProtocol;
            private final java.lang.String cidrIp;
            private final java.lang.String cidrIpv6;
            private final java.lang.String description;
            private final java.lang.Number fromPort;
            private final java.lang.String sourcePrefixListId;
            private final java.lang.String sourceSecurityGroupId;
            private final java.lang.String sourceSecurityGroupName;
            private final java.lang.String sourceSecurityGroupOwnerId;
            private final java.lang.Number toPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ipProtocol = this.jsiiGet("ipProtocol", java.lang.String.class);
                this.cidrIp = this.jsiiGet("cidrIp", java.lang.String.class);
                this.cidrIpv6 = this.jsiiGet("cidrIpv6", java.lang.String.class);
                this.description = this.jsiiGet("description", java.lang.String.class);
                this.fromPort = this.jsiiGet("fromPort", java.lang.Number.class);
                this.sourcePrefixListId = this.jsiiGet("sourcePrefixListId", java.lang.String.class);
                this.sourceSecurityGroupId = this.jsiiGet("sourceSecurityGroupId", java.lang.String.class);
                this.sourceSecurityGroupName = this.jsiiGet("sourceSecurityGroupName", java.lang.String.class);
                this.sourceSecurityGroupOwnerId = this.jsiiGet("sourceSecurityGroupOwnerId", java.lang.String.class);
                this.toPort = this.jsiiGet("toPort", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String ipProtocol, final java.lang.String cidrIp, final java.lang.String cidrIpv6, final java.lang.String description, final java.lang.Number fromPort, final java.lang.String sourcePrefixListId, final java.lang.String sourceSecurityGroupId, final java.lang.String sourceSecurityGroupName, final java.lang.String sourceSecurityGroupOwnerId, final java.lang.Number toPort) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ipProtocol = java.util.Objects.requireNonNull(ipProtocol, "ipProtocol is required");
                this.cidrIp = cidrIp;
                this.cidrIpv6 = cidrIpv6;
                this.description = description;
                this.fromPort = fromPort;
                this.sourcePrefixListId = sourcePrefixListId;
                this.sourceSecurityGroupId = sourceSecurityGroupId;
                this.sourceSecurityGroupName = sourceSecurityGroupName;
                this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
                this.toPort = toPort;
            }

            @Override
            public java.lang.String getIpProtocol() {
                return this.ipProtocol;
            }

            @Override
            public java.lang.String getCidrIp() {
                return this.cidrIp;
            }

            @Override
            public java.lang.String getCidrIpv6() {
                return this.cidrIpv6;
            }

            @Override
            public java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public java.lang.Number getFromPort() {
                return this.fromPort;
            }

            @Override
            public java.lang.String getSourcePrefixListId() {
                return this.sourcePrefixListId;
            }

            @Override
            public java.lang.String getSourceSecurityGroupId() {
                return this.sourceSecurityGroupId;
            }

            @Override
            public java.lang.String getSourceSecurityGroupName() {
                return this.sourceSecurityGroupName;
            }

            @Override
            public java.lang.String getSourceSecurityGroupOwnerId() {
                return this.sourceSecurityGroupOwnerId;
            }

            @Override
            public java.lang.Number getToPort() {
                return this.toPort;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ipProtocol", om.valueToTree(this.getIpProtocol()));
                if (this.getCidrIp() != null) {
                    data.set("cidrIp", om.valueToTree(this.getCidrIp()));
                }
                if (this.getCidrIpv6() != null) {
                    data.set("cidrIpv6", om.valueToTree(this.getCidrIpv6()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getFromPort() != null) {
                    data.set("fromPort", om.valueToTree(this.getFromPort()));
                }
                if (this.getSourcePrefixListId() != null) {
                    data.set("sourcePrefixListId", om.valueToTree(this.getSourcePrefixListId()));
                }
                if (this.getSourceSecurityGroupId() != null) {
                    data.set("sourceSecurityGroupId", om.valueToTree(this.getSourceSecurityGroupId()));
                }
                if (this.getSourceSecurityGroupName() != null) {
                    data.set("sourceSecurityGroupName", om.valueToTree(this.getSourceSecurityGroupName()));
                }
                if (this.getSourceSecurityGroupOwnerId() != null) {
                    data.set("sourceSecurityGroupOwnerId", om.valueToTree(this.getSourceSecurityGroupOwnerId()));
                }
                if (this.getToPort() != null) {
                    data.set("toPort", om.valueToTree(this.getToPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnSecurityGroup.IngressProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressProperty.Jsii$Proxy that = (IngressProperty.Jsii$Proxy) o;

                if (!ipProtocol.equals(that.ipProtocol)) return false;
                if (this.cidrIp != null ? !this.cidrIp.equals(that.cidrIp) : that.cidrIp != null) return false;
                if (this.cidrIpv6 != null ? !this.cidrIpv6.equals(that.cidrIpv6) : that.cidrIpv6 != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.fromPort != null ? !this.fromPort.equals(that.fromPort) : that.fromPort != null) return false;
                if (this.sourcePrefixListId != null ? !this.sourcePrefixListId.equals(that.sourcePrefixListId) : that.sourcePrefixListId != null) return false;
                if (this.sourceSecurityGroupId != null ? !this.sourceSecurityGroupId.equals(that.sourceSecurityGroupId) : that.sourceSecurityGroupId != null) return false;
                if (this.sourceSecurityGroupName != null ? !this.sourceSecurityGroupName.equals(that.sourceSecurityGroupName) : that.sourceSecurityGroupName != null) return false;
                if (this.sourceSecurityGroupOwnerId != null ? !this.sourceSecurityGroupOwnerId.equals(that.sourceSecurityGroupOwnerId) : that.sourceSecurityGroupOwnerId != null) return false;
                return this.toPort != null ? this.toPort.equals(that.toPort) : that.toPort == null;
            }

            @Override
            public int hashCode() {
                int result = this.ipProtocol.hashCode();
                result = 31 * result + (this.cidrIp != null ? this.cidrIp.hashCode() : 0);
                result = 31 * result + (this.cidrIpv6 != null ? this.cidrIpv6.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.fromPort != null ? this.fromPort.hashCode() : 0);
                result = 31 * result + (this.sourcePrefixListId != null ? this.sourcePrefixListId.hashCode() : 0);
                result = 31 * result + (this.sourceSecurityGroupId != null ? this.sourceSecurityGroupId.hashCode() : 0);
                result = 31 * result + (this.sourceSecurityGroupName != null ? this.sourceSecurityGroupName.hashCode() : 0);
                result = 31 * result + (this.sourceSecurityGroupOwnerId != null ? this.sourceSecurityGroupOwnerId.hashCode() : 0);
                result = 31 * result + (this.toPort != null ? this.toPort.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnSecurityGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnSecurityGroupProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnSecurityGroupProps.Builder();
        }

        /**
         * `AWS::EC2::SecurityGroup.GroupDescription`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
         * @param groupDescription `AWS::EC2::SecurityGroup.GroupDescription`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder groupDescription(final java.lang.String groupDescription) {
            this.props.groupDescription(groupDescription);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroup.GroupName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
         * @param groupName `AWS::EC2::SecurityGroup.GroupName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder groupName(final java.lang.String groupName) {
            this.props.groupName(groupName);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
         * @param securityGroupEgress `AWS::EC2::SecurityGroup.SecurityGroupEgress`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder securityGroupEgress(final software.amazon.awscdk.core.IResolvable securityGroupEgress) {
            this.props.securityGroupEgress(securityGroupEgress);
            return this;
        }
        /**
         * `AWS::EC2::SecurityGroup.SecurityGroupEgress`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
         * @param securityGroupEgress `AWS::EC2::SecurityGroup.SecurityGroupEgress`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder securityGroupEgress(final java.util.List<java.lang.Object> securityGroupEgress) {
            this.props.securityGroupEgress(securityGroupEgress);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
         * @param securityGroupIngress `AWS::EC2::SecurityGroup.SecurityGroupIngress`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder securityGroupIngress(final software.amazon.awscdk.core.IResolvable securityGroupIngress) {
            this.props.securityGroupIngress(securityGroupIngress);
            return this;
        }
        /**
         * `AWS::EC2::SecurityGroup.SecurityGroupIngress`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
         * @param securityGroupIngress `AWS::EC2::SecurityGroup.SecurityGroupIngress`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder securityGroupIngress(final java.util.List<java.lang.Object> securityGroupIngress) {
            this.props.securityGroupIngress(securityGroupIngress);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroup.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
         * @param tags `AWS::EC2::SecurityGroup.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroup.VpcId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
         * @param vpcId `AWS::EC2::SecurityGroup.VpcId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnSecurityGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.ec2.CfnSecurityGroup build() {
            return new software.amazon.awscdk.services.ec2.CfnSecurityGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
