package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPCEndpointServicePermissions`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-28T11:04:06.233Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPCEndpointServicePermissionsProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPCEndpointServicePermissionsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnVPCEndpointServicePermissionsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::VPCEndpointServicePermissions.ServiceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-serviceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceId();

    /**
     * `AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-allowedprincipals
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedPrincipals() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPCEndpointServicePermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCEndpointServicePermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String serviceId;
        private java.util.List<java.lang.String> allowedPrincipals;

        /**
         * Sets the value of {@link CfnVPCEndpointServicePermissionsProps#getServiceId}
         * @param serviceId `AWS::EC2::VPCEndpointServicePermissions.ServiceId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder serviceId(java.lang.String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointServicePermissionsProps#getAllowedPrincipals}
         * @param allowedPrincipals `AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder allowedPrincipals(java.util.List<java.lang.String> allowedPrincipals) {
            this.allowedPrincipals = allowedPrincipals;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCEndpointServicePermissionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnVPCEndpointServicePermissionsProps build() {
            return new Jsii$Proxy(serviceId, allowedPrincipals);
        }
    }

    /**
     * An implementation for {@link CfnVPCEndpointServicePermissionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCEndpointServicePermissionsProps {
        private final java.lang.String serviceId;
        private final java.util.List<java.lang.String> allowedPrincipals;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceId = this.jsiiGet("serviceId", java.lang.String.class);
            this.allowedPrincipals = this.jsiiGet("allowedPrincipals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String serviceId, final java.util.List<java.lang.String> allowedPrincipals) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceId = java.util.Objects.requireNonNull(serviceId, "serviceId is required");
            this.allowedPrincipals = allowedPrincipals;
        }

        @Override
        public java.lang.String getServiceId() {
            return this.serviceId;
        }

        @Override
        public java.util.List<java.lang.String> getAllowedPrincipals() {
            return this.allowedPrincipals;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serviceId", om.valueToTree(this.getServiceId()));
            if (this.getAllowedPrincipals() != null) {
                data.set("allowedPrincipals", om.valueToTree(this.getAllowedPrincipals()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVPCEndpointServicePermissionsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCEndpointServicePermissionsProps.Jsii$Proxy that = (CfnVPCEndpointServicePermissionsProps.Jsii$Proxy) o;

            if (!serviceId.equals(that.serviceId)) return false;
            return this.allowedPrincipals != null ? this.allowedPrincipals.equals(that.allowedPrincipals) : that.allowedPrincipals == null;
        }

        @Override
        public int hashCode() {
            int result = this.serviceId.hashCode();
            result = 31 * result + (this.allowedPrincipals != null ? this.allowedPrincipals.hashCode() : 0);
            return result;
        }
    }
}
