package software.amazon.awscdk.services.ec2;

/**
 * Amazon Linux image properties.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-29T22:49:48.121Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.AmazonLinuxImageProps")
@software.amazon.jsii.Jsii.Proxy(AmazonLinuxImageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AmazonLinuxImageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * What edition of Amazon Linux to use.
     * <p>
     * Default: Standard
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition() {
        return null;
    }

    /**
     * What generation of Amazon Linux to use.
     * <p>
     * Default: AmazonLinux
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxGeneration getGeneration() {
        return null;
    }

    /**
     * What storage backed image to use.
     * <p>
     * Default: GeneralPurpose
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage() {
        return null;
    }

    /**
     * Initial user data.
     * <p>
     * Default: - Empty UserData for Linux machines
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData getUserData() {
        return null;
    }

    /**
     * Virtualization type.
     * <p>
     * Default: HVM
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AmazonLinuxImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AmazonLinuxImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.AmazonLinuxEdition edition;
        private software.amazon.awscdk.services.ec2.AmazonLinuxGeneration generation;
        private software.amazon.awscdk.services.ec2.AmazonLinuxStorage storage;
        private software.amazon.awscdk.services.ec2.UserData userData;
        private software.amazon.awscdk.services.ec2.AmazonLinuxVirt virtualization;

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getEdition}
         * @param edition What edition of Amazon Linux to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edition(software.amazon.awscdk.services.ec2.AmazonLinuxEdition edition) {
            this.edition = edition;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getGeneration}
         * @param generation What generation of Amazon Linux to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generation(software.amazon.awscdk.services.ec2.AmazonLinuxGeneration generation) {
            this.generation = generation;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getStorage}
         * @param storage What storage backed image to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storage(software.amazon.awscdk.services.ec2.AmazonLinuxStorage storage) {
            this.storage = storage;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getUserData}
         * @param userData Initial user data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Sets the value of {@link AmazonLinuxImageProps#getVirtualization}
         * @param virtualization Virtualization type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualization(software.amazon.awscdk.services.ec2.AmazonLinuxVirt virtualization) {
            this.virtualization = virtualization;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AmazonLinuxImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AmazonLinuxImageProps build() {
            return new Jsii$Proxy(edition, generation, storage, userData, virtualization);
        }
    }

    /**
     * An implementation for {@link AmazonLinuxImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonLinuxImageProps {
        private final software.amazon.awscdk.services.ec2.AmazonLinuxEdition edition;
        private final software.amazon.awscdk.services.ec2.AmazonLinuxGeneration generation;
        private final software.amazon.awscdk.services.ec2.AmazonLinuxStorage storage;
        private final software.amazon.awscdk.services.ec2.UserData userData;
        private final software.amazon.awscdk.services.ec2.AmazonLinuxVirt virtualization;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.edition = this.jsiiGet("edition", software.amazon.awscdk.services.ec2.AmazonLinuxEdition.class);
            this.generation = this.jsiiGet("generation", software.amazon.awscdk.services.ec2.AmazonLinuxGeneration.class);
            this.storage = this.jsiiGet("storage", software.amazon.awscdk.services.ec2.AmazonLinuxStorage.class);
            this.userData = this.jsiiGet("userData", software.amazon.awscdk.services.ec2.UserData.class);
            this.virtualization = this.jsiiGet("virtualization", software.amazon.awscdk.services.ec2.AmazonLinuxVirt.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.AmazonLinuxEdition edition, final software.amazon.awscdk.services.ec2.AmazonLinuxGeneration generation, final software.amazon.awscdk.services.ec2.AmazonLinuxStorage storage, final software.amazon.awscdk.services.ec2.UserData userData, final software.amazon.awscdk.services.ec2.AmazonLinuxVirt virtualization) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.edition = edition;
            this.generation = generation;
            this.storage = storage;
            this.userData = userData;
            this.virtualization = virtualization;
        }

        @Override
        public software.amazon.awscdk.services.ec2.AmazonLinuxEdition getEdition() {
            return this.edition;
        }

        @Override
        public software.amazon.awscdk.services.ec2.AmazonLinuxGeneration getGeneration() {
            return this.generation;
        }

        @Override
        public software.amazon.awscdk.services.ec2.AmazonLinuxStorage getStorage() {
            return this.storage;
        }

        @Override
        public software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        public software.amazon.awscdk.services.ec2.AmazonLinuxVirt getVirtualization() {
            return this.virtualization;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEdition() != null) {
                data.set("edition", om.valueToTree(this.getEdition()));
            }
            if (this.getGeneration() != null) {
                data.set("generation", om.valueToTree(this.getGeneration()));
            }
            if (this.getStorage() != null) {
                data.set("storage", om.valueToTree(this.getStorage()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }
            if (this.getVirtualization() != null) {
                data.set("virtualization", om.valueToTree(this.getVirtualization()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.AmazonLinuxImageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AmazonLinuxImageProps.Jsii$Proxy that = (AmazonLinuxImageProps.Jsii$Proxy) o;

            if (this.edition != null ? !this.edition.equals(that.edition) : that.edition != null) return false;
            if (this.generation != null ? !this.generation.equals(that.generation) : that.generation != null) return false;
            if (this.storage != null ? !this.storage.equals(that.storage) : that.storage != null) return false;
            if (this.userData != null ? !this.userData.equals(that.userData) : that.userData != null) return false;
            return this.virtualization != null ? this.virtualization.equals(that.virtualization) : that.virtualization == null;
        }

        @Override
        public int hashCode() {
            int result = this.edition != null ? this.edition.hashCode() : 0;
            result = 31 * result + (this.generation != null ? this.generation.hashCode() : 0);
            result = 31 * result + (this.storage != null ? this.storage.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            result = 31 * result + (this.virtualization != null ? this.virtualization.hashCode() : 0);
            return result;
        }
    }
}
