package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::NetworkInterface`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-29T22:49:48.179Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnNetworkInterfaceProps")
@software.amazon.jsii.Jsii.Proxy(CfnNetworkInterfaceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnNetworkInterfaceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::NetworkInterface.SubnetId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @org.jetbrains.annotations.NotNull java.lang.String getSubnetId();

    /**
     * `AWS::EC2::NetworkInterface.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::EC2::NetworkInterface.GroupSet`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroupSet() {
        return null;
    }

    /**
     * `AWS::EC2::NetworkInterface.InterfaceType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.String getInterfaceType() {
        return null;
    }

    /**
     * `AWS::EC2::NetworkInterface.Ipv6AddressCount`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIpv6AddressCount() {
        return null;
    }

    /**
     * `AWS::EC2::NetworkInterface.Ipv6Addresses`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Addresses() {
        return null;
    }

    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddress`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
        return null;
    }

    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddresses`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateIpAddresses() {
        return null;
    }

    /**
     * `AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSecondaryPrivateIpAddressCount() {
        return null;
    }

    /**
     * `AWS::EC2::NetworkInterface.SourceDestCheck`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceDestCheck() {
        return null;
    }

    /**
     * `AWS::EC2::NetworkInterface.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNetworkInterfaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNetworkInterfaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String subnetId;
        private java.lang.String description;
        private java.util.List<java.lang.String> groupSet;
        private java.lang.String interfaceType;
        private java.lang.Number ipv6AddressCount;
        private java.lang.Object ipv6Addresses;
        private java.lang.String privateIpAddress;
        private java.lang.Object privateIpAddresses;
        private java.lang.Number secondaryPrivateIpAddressCount;
        private java.lang.Object sourceDestCheck;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getSubnetId}
         * @param subnetId `AWS::EC2::NetworkInterface.SubnetId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getDescription}
         * @param description `AWS::EC2::NetworkInterface.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getGroupSet}
         * @param groupSet `AWS::EC2::NetworkInterface.GroupSet`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder groupSet(java.util.List<java.lang.String> groupSet) {
            this.groupSet = groupSet;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getInterfaceType}
         * @param interfaceType `AWS::EC2::NetworkInterface.InterfaceType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder interfaceType(java.lang.String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getIpv6AddressCount}
         * @param ipv6AddressCount `AWS::EC2::NetworkInterface.Ipv6AddressCount`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipv6AddressCount(java.lang.Number ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getIpv6Addresses}
         * @param ipv6Addresses `AWS::EC2::NetworkInterface.Ipv6Addresses`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipv6Addresses(software.amazon.awscdk.core.IResolvable ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getIpv6Addresses}
         * @param ipv6Addresses `AWS::EC2::NetworkInterface.Ipv6Addresses`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipv6Addresses(software.amazon.awscdk.services.ec2.CfnNetworkInterface.InstanceIpv6AddressProperty ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getPrivateIpAddress}
         * @param privateIpAddress `AWS::EC2::NetworkInterface.PrivateIpAddress`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder privateIpAddress(java.lang.String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getPrivateIpAddresses}
         * @param privateIpAddresses `AWS::EC2::NetworkInterface.PrivateIpAddresses`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder privateIpAddresses(software.amazon.awscdk.core.IResolvable privateIpAddresses) {
            this.privateIpAddresses = privateIpAddresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getPrivateIpAddresses}
         * @param privateIpAddresses `AWS::EC2::NetworkInterface.PrivateIpAddresses`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder privateIpAddresses(java.util.List<java.lang.Object> privateIpAddresses) {
            this.privateIpAddresses = privateIpAddresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getSecondaryPrivateIpAddressCount}
         * @param secondaryPrivateIpAddressCount `AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder secondaryPrivateIpAddressCount(java.lang.Number secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getSourceDestCheck}
         * @param sourceDestCheck `AWS::EC2::NetworkInterface.SourceDestCheck`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceDestCheck(java.lang.Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getSourceDestCheck}
         * @param sourceDestCheck `AWS::EC2::NetworkInterface.SourceDestCheck`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceDestCheck(software.amazon.awscdk.core.IResolvable sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getTags}
         * @param tags `AWS::EC2::NetworkInterface.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkInterfaceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnNetworkInterfaceProps build() {
            return new Jsii$Proxy(subnetId, description, groupSet, interfaceType, ipv6AddressCount, ipv6Addresses, privateIpAddress, privateIpAddresses, secondaryPrivateIpAddressCount, sourceDestCheck, tags);
        }
    }

    /**
     * An implementation for {@link CfnNetworkInterfaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNetworkInterfaceProps {
        private final java.lang.String subnetId;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> groupSet;
        private final java.lang.String interfaceType;
        private final java.lang.Number ipv6AddressCount;
        private final java.lang.Object ipv6Addresses;
        private final java.lang.String privateIpAddress;
        private final java.lang.Object privateIpAddresses;
        private final java.lang.Number secondaryPrivateIpAddressCount;
        private final java.lang.Object sourceDestCheck;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.subnetId = this.jsiiGet("subnetId", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.groupSet = this.jsiiGet("groupSet", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.interfaceType = this.jsiiGet("interfaceType", java.lang.String.class);
            this.ipv6AddressCount = this.jsiiGet("ipv6AddressCount", java.lang.Number.class);
            this.ipv6Addresses = this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            this.privateIpAddress = this.jsiiGet("privateIpAddress", java.lang.String.class);
            this.privateIpAddresses = this.jsiiGet("privateIpAddresses", java.lang.Object.class);
            this.secondaryPrivateIpAddressCount = this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Number.class);
            this.sourceDestCheck = this.jsiiGet("sourceDestCheck", java.lang.Object.class);
            this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String subnetId, final java.lang.String description, final java.util.List<java.lang.String> groupSet, final java.lang.String interfaceType, final java.lang.Number ipv6AddressCount, final java.lang.Object ipv6Addresses, final java.lang.String privateIpAddress, final java.lang.Object privateIpAddresses, final java.lang.Number secondaryPrivateIpAddressCount, final java.lang.Object sourceDestCheck, final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.subnetId = java.util.Objects.requireNonNull(subnetId, "subnetId is required");
            this.description = description;
            this.groupSet = groupSet;
            this.interfaceType = interfaceType;
            this.ipv6AddressCount = ipv6AddressCount;
            this.ipv6Addresses = ipv6Addresses;
            this.privateIpAddress = privateIpAddress;
            this.privateIpAddresses = privateIpAddresses;
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            this.sourceDestCheck = sourceDestCheck;
            this.tags = tags;
        }

        @Override
        public java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.util.List<java.lang.String> getGroupSet() {
            return this.groupSet;
        }

        @Override
        public java.lang.String getInterfaceType() {
            return this.interfaceType;
        }

        @Override
        public java.lang.Number getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        @Override
        public java.lang.Object getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        @Override
        public java.lang.String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public java.lang.Object getPrivateIpAddresses() {
            return this.privateIpAddresses;
        }

        @Override
        public java.lang.Number getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        @Override
        public java.lang.Object getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("subnetId", om.valueToTree(this.getSubnetId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGroupSet() != null) {
                data.set("groupSet", om.valueToTree(this.getGroupSet()));
            }
            if (this.getInterfaceType() != null) {
                data.set("interfaceType", om.valueToTree(this.getInterfaceType()));
            }
            if (this.getIpv6AddressCount() != null) {
                data.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
            }
            if (this.getIpv6Addresses() != null) {
                data.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
            }
            if (this.getPrivateIpAddress() != null) {
                data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
            }
            if (this.getPrivateIpAddresses() != null) {
                data.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
            }
            if (this.getSecondaryPrivateIpAddressCount() != null) {
                data.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
            }
            if (this.getSourceDestCheck() != null) {
                data.set("sourceDestCheck", om.valueToTree(this.getSourceDestCheck()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnNetworkInterfaceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNetworkInterfaceProps.Jsii$Proxy that = (CfnNetworkInterfaceProps.Jsii$Proxy) o;

            if (!subnetId.equals(that.subnetId)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.groupSet != null ? !this.groupSet.equals(that.groupSet) : that.groupSet != null) return false;
            if (this.interfaceType != null ? !this.interfaceType.equals(that.interfaceType) : that.interfaceType != null) return false;
            if (this.ipv6AddressCount != null ? !this.ipv6AddressCount.equals(that.ipv6AddressCount) : that.ipv6AddressCount != null) return false;
            if (this.ipv6Addresses != null ? !this.ipv6Addresses.equals(that.ipv6Addresses) : that.ipv6Addresses != null) return false;
            if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
            if (this.privateIpAddresses != null ? !this.privateIpAddresses.equals(that.privateIpAddresses) : that.privateIpAddresses != null) return false;
            if (this.secondaryPrivateIpAddressCount != null ? !this.secondaryPrivateIpAddressCount.equals(that.secondaryPrivateIpAddressCount) : that.secondaryPrivateIpAddressCount != null) return false;
            if (this.sourceDestCheck != null ? !this.sourceDestCheck.equals(that.sourceDestCheck) : that.sourceDestCheck != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.subnetId.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.groupSet != null ? this.groupSet.hashCode() : 0);
            result = 31 * result + (this.interfaceType != null ? this.interfaceType.hashCode() : 0);
            result = 31 * result + (this.ipv6AddressCount != null ? this.ipv6AddressCount.hashCode() : 0);
            result = 31 * result + (this.ipv6Addresses != null ? this.ipv6Addresses.hashCode() : 0);
            result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
            result = 31 * result + (this.privateIpAddresses != null ? this.privateIpAddresses.hashCode() : 0);
            result = 31 * result + (this.secondaryPrivateIpAddressCount != null ? this.secondaryPrivateIpAddressCount.hashCode() : 0);
            result = 31 * result + (this.sourceDestCheck != null ? this.sourceDestCheck.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
