package software.amazon.awscdk.services.ec2;

/**
 * Properties to create a port range.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-08T05:31:19.431Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.PortProps")
@software.amazon.jsii.Jsii.Proxy(PortProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PortProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The protocol for the range.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Protocol getProtocol();

    /**
     * String representation for this object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStringRepresentation();

    /**
     * The starting port for the range.
     * <p>
     * Default: - Not included in the rule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getFromPort() {
        return null;
    }

    /**
     * The ending port for the range.
     * <p>
     * Default: - Not included in the rule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getToPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PortProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PortProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.Protocol protocol;
        private java.lang.String stringRepresentation;
        private java.lang.Number fromPort;
        private java.lang.Number toPort;

        /**
         * Sets the value of {@link PortProps#getProtocol}
         * @param protocol The protocol for the range. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.ec2.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link PortProps#getStringRepresentation}
         * @param stringRepresentation String representation for this object. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stringRepresentation(java.lang.String stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
            return this;
        }

        /**
         * Sets the value of {@link PortProps#getFromPort}
         * @param fromPort The starting port for the range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fromPort(java.lang.Number fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        /**
         * Sets the value of {@link PortProps#getToPort}
         * @param toPort The ending port for the range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder toPort(java.lang.Number toPort) {
            this.toPort = toPort;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PortProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public PortProps build() {
            return new Jsii$Proxy(protocol, stringRepresentation, fromPort, toPort);
        }
    }

    /**
     * An implementation for {@link PortProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortProps {
        private final software.amazon.awscdk.services.ec2.Protocol protocol;
        private final java.lang.String stringRepresentation;
        private final java.lang.Number fromPort;
        private final java.lang.Number toPort;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.protocol = this.jsiiGet("protocol", software.amazon.awscdk.services.ec2.Protocol.class);
            this.stringRepresentation = this.jsiiGet("stringRepresentation", java.lang.String.class);
            this.fromPort = this.jsiiGet("fromPort", java.lang.Number.class);
            this.toPort = this.jsiiGet("toPort", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.Protocol protocol, final java.lang.String stringRepresentation, final java.lang.Number fromPort, final java.lang.Number toPort) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
            this.stringRepresentation = java.util.Objects.requireNonNull(stringRepresentation, "stringRepresentation is required");
            this.fromPort = fromPort;
            this.toPort = toPort;
        }

        @Override
        public software.amazon.awscdk.services.ec2.Protocol getProtocol() {
            return this.protocol;
        }

        @Override
        public java.lang.String getStringRepresentation() {
            return this.stringRepresentation;
        }

        @Override
        public java.lang.Number getFromPort() {
            return this.fromPort;
        }

        @Override
        public java.lang.Number getToPort() {
            return this.toPort;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("protocol", om.valueToTree(this.getProtocol()));
            data.set("stringRepresentation", om.valueToTree(this.getStringRepresentation()));
            if (this.getFromPort() != null) {
                data.set("fromPort", om.valueToTree(this.getFromPort()));
            }
            if (this.getToPort() != null) {
                data.set("toPort", om.valueToTree(this.getToPort()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.PortProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PortProps.Jsii$Proxy that = (PortProps.Jsii$Proxy) o;

            if (!protocol.equals(that.protocol)) return false;
            if (!stringRepresentation.equals(that.stringRepresentation)) return false;
            if (this.fromPort != null ? !this.fromPort.equals(that.fromPort) : that.fromPort != null) return false;
            return this.toPort != null ? this.toPort.equals(that.toPort) : that.toPort == null;
        }

        @Override
        public int hashCode() {
            int result = this.protocol.hashCode();
            result = 31 * result + (this.stringRepresentation.hashCode());
            result = 31 * result + (this.fromPort != null ? this.fromPort.hashCode() : 0);
            result = 31 * result + (this.toPort != null ? this.toPort.hashCode() : 0);
            return result;
        }
    }
}
