package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::SecurityGroupIngress`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-15T23:35:58.293Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnSecurityGroupIngress")
public class CfnSecurityGroupIngress extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnSecurityGroupIngress(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSecurityGroupIngress(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::EC2::SecurityGroupIngress`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnSecurityGroupIngress(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnSecurityGroupIngressProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A factory method that creates a new instance of this class from an object containing the CloudFormation properties of this resource.
     * <p>
     * Used in the &#64;aws-cdk/cloudformation-include module.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param resourceAttributes This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress fromCloudFormation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.Object resourceAttributes) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress.class, "fromCloudFormation", software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), resourceAttributes });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.IpProtocol`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.NotNull java.lang.String getIpProtocol() {
        return this.jsiiGet("ipProtocol", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.IpProtocol`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIpProtocol(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("ipProtocol", java.util.Objects.requireNonNull(value, "ipProtocol is required"));
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIp`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getCidrIp() {
        return this.jsiiGet("cidrIp", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIp`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCidrIp(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("cidrIp", value);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIpv6`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getCidrIpv6() {
        return this.jsiiGet("cidrIpv6", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIpv6`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCidrIpv6(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("cidrIpv6", value);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.FromPort`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Number getFromPort() {
        return this.jsiiGet("fromPort", java.lang.Number.class);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.FromPort`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setFromPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("fromPort", value);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.GroupId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getGroupId() {
        return this.jsiiGet("groupId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.GroupId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setGroupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("groupId", value);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.GroupName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getGroupName() {
        return this.jsiiGet("groupName", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.GroupName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("groupName", value);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.SourcePrefixListId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-securitygroupingress-sourceprefixlistid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourcePrefixListId() {
        return this.jsiiGet("sourcePrefixListId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.SourcePrefixListId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-securitygroupingress-sourceprefixlistid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSourcePrefixListId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("sourcePrefixListId", value);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceSecurityGroupId() {
        return this.jsiiGet("sourceSecurityGroupId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSourceSecurityGroupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("sourceSecurityGroupId", value);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceSecurityGroupName() {
        return this.jsiiGet("sourceSecurityGroupName", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSourceSecurityGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("sourceSecurityGroupName", value);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceSecurityGroupOwnerId() {
        return this.jsiiGet("sourceSecurityGroupOwnerId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSourceSecurityGroupOwnerId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("sourceSecurityGroupOwnerId", value);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.ToPort`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public @org.jetbrains.annotations.Nullable java.lang.Number getToPort() {
        return this.jsiiGet("toPort", java.lang.Number.class);
    }

    /**
     * `AWS::EC2::SecurityGroupIngress.ToPort`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setToPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        this.jsiiSet("toPort", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnSecurityGroupIngressProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnSecurityGroupIngressProps.Builder();
        }

        /**
         * `AWS::EC2::SecurityGroupIngress.IpProtocol`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
         * @param ipProtocol `AWS::EC2::SecurityGroupIngress.IpProtocol`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder ipProtocol(final java.lang.String ipProtocol) {
            this.props.ipProtocol(ipProtocol);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroupIngress.CidrIp`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
         * @param cidrIp `AWS::EC2::SecurityGroupIngress.CidrIp`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cidrIp(final java.lang.String cidrIp) {
            this.props.cidrIp(cidrIp);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroupIngress.CidrIpv6`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
         * @param cidrIpv6 `AWS::EC2::SecurityGroupIngress.CidrIpv6`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cidrIpv6(final java.lang.String cidrIpv6) {
            this.props.cidrIpv6(cidrIpv6);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroupIngress.Description`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
         * @param description `AWS::EC2::SecurityGroupIngress.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroupIngress.FromPort`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
         * @param fromPort `AWS::EC2::SecurityGroupIngress.FromPort`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder fromPort(final java.lang.Number fromPort) {
            this.props.fromPort(fromPort);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroupIngress.GroupId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
         * @param groupId `AWS::EC2::SecurityGroupIngress.GroupId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder groupId(final java.lang.String groupId) {
            this.props.groupId(groupId);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroupIngress.GroupName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
         * @param groupName `AWS::EC2::SecurityGroupIngress.GroupName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder groupName(final java.lang.String groupName) {
            this.props.groupName(groupName);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroupIngress.SourcePrefixListId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-securitygroupingress-sourceprefixlistid
         * @param sourcePrefixListId `AWS::EC2::SecurityGroupIngress.SourcePrefixListId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourcePrefixListId(final java.lang.String sourcePrefixListId) {
            this.props.sourcePrefixListId(sourcePrefixListId);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
         * @param sourceSecurityGroupId `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceSecurityGroupId(final java.lang.String sourceSecurityGroupId) {
            this.props.sourceSecurityGroupId(sourceSecurityGroupId);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
         * @param sourceSecurityGroupName `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceSecurityGroupName(final java.lang.String sourceSecurityGroupName) {
            this.props.sourceSecurityGroupName(sourceSecurityGroupName);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
         * @param sourceSecurityGroupOwnerId `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceSecurityGroupOwnerId(final java.lang.String sourceSecurityGroupOwnerId) {
            this.props.sourceSecurityGroupOwnerId(sourceSecurityGroupOwnerId);
            return this;
        }

        /**
         * `AWS::EC2::SecurityGroupIngress.ToPort`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
         * @param toPort `AWS::EC2::SecurityGroupIngress.ToPort`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder toPort(final java.lang.Number toPort) {
            this.props.toPort(toPort);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress build() {
            return new software.amazon.awscdk.services.ec2.CfnSecurityGroupIngress(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
