package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPCPeeringConnection`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-15T23:35:58.332Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPCPeeringConnectionProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPCPeeringConnectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnVPCPeeringConnectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::VPCPeeringConnection.PeerVpcId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peervpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @org.jetbrains.annotations.NotNull java.lang.String getPeerVpcId();

    /**
     * `AWS::EC2::VPCPeeringConnection.VpcId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-vpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * `AWS::EC2::VPCPeeringConnection.PeerOwnerId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerownerid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.String getPeerOwnerId() {
        return null;
    }

    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRegion`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerregion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.String getPeerRegion() {
        return null;
    }

    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRoleArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerrolearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.lang.String getPeerRoleArn() {
        return null;
    }

    /**
     * `AWS::EC2::VPCPeeringConnection.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPCPeeringConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCPeeringConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String peerVpcId;
        private java.lang.String vpcId;
        private java.lang.String peerOwnerId;
        private java.lang.String peerRegion;
        private java.lang.String peerRoleArn;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnVPCPeeringConnectionProps#getPeerVpcId}
         * @param peerVpcId `AWS::EC2::VPCPeeringConnection.PeerVpcId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder peerVpcId(java.lang.String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCPeeringConnectionProps#getVpcId}
         * @param vpcId `AWS::EC2::VPCPeeringConnection.VpcId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCPeeringConnectionProps#getPeerOwnerId}
         * @param peerOwnerId `AWS::EC2::VPCPeeringConnection.PeerOwnerId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder peerOwnerId(java.lang.String peerOwnerId) {
            this.peerOwnerId = peerOwnerId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCPeeringConnectionProps#getPeerRegion}
         * @param peerRegion `AWS::EC2::VPCPeeringConnection.PeerRegion`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder peerRegion(java.lang.String peerRegion) {
            this.peerRegion = peerRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCPeeringConnectionProps#getPeerRoleArn}
         * @param peerRoleArn `AWS::EC2::VPCPeeringConnection.PeerRoleArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder peerRoleArn(java.lang.String peerRoleArn) {
            this.peerRoleArn = peerRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCPeeringConnectionProps#getTags}
         * @param tags `AWS::EC2::VPCPeeringConnection.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCPeeringConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnVPCPeeringConnectionProps build() {
            return new Jsii$Proxy(peerVpcId, vpcId, peerOwnerId, peerRegion, peerRoleArn, tags);
        }
    }

    /**
     * An implementation for {@link CfnVPCPeeringConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCPeeringConnectionProps {
        private final java.lang.String peerVpcId;
        private final java.lang.String vpcId;
        private final java.lang.String peerOwnerId;
        private final java.lang.String peerRegion;
        private final java.lang.String peerRoleArn;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.peerVpcId = this.jsiiGet("peerVpcId", java.lang.String.class);
            this.vpcId = this.jsiiGet("vpcId", java.lang.String.class);
            this.peerOwnerId = this.jsiiGet("peerOwnerId", java.lang.String.class);
            this.peerRegion = this.jsiiGet("peerRegion", java.lang.String.class);
            this.peerRoleArn = this.jsiiGet("peerRoleArn", java.lang.String.class);
            this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String peerVpcId, final java.lang.String vpcId, final java.lang.String peerOwnerId, final java.lang.String peerRegion, final java.lang.String peerRoleArn, final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.peerVpcId = java.util.Objects.requireNonNull(peerVpcId, "peerVpcId is required");
            this.vpcId = java.util.Objects.requireNonNull(vpcId, "vpcId is required");
            this.peerOwnerId = peerOwnerId;
            this.peerRegion = peerRegion;
            this.peerRoleArn = peerRoleArn;
            this.tags = tags;
        }

        @Override
        public java.lang.String getPeerVpcId() {
            return this.peerVpcId;
        }

        @Override
        public java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public java.lang.String getPeerOwnerId() {
            return this.peerOwnerId;
        }

        @Override
        public java.lang.String getPeerRegion() {
            return this.peerRegion;
        }

        @Override
        public java.lang.String getPeerRoleArn() {
            return this.peerRoleArn;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("peerVpcId", om.valueToTree(this.getPeerVpcId()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getPeerOwnerId() != null) {
                data.set("peerOwnerId", om.valueToTree(this.getPeerOwnerId()));
            }
            if (this.getPeerRegion() != null) {
                data.set("peerRegion", om.valueToTree(this.getPeerRegion()));
            }
            if (this.getPeerRoleArn() != null) {
                data.set("peerRoleArn", om.valueToTree(this.getPeerRoleArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVPCPeeringConnectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCPeeringConnectionProps.Jsii$Proxy that = (CfnVPCPeeringConnectionProps.Jsii$Proxy) o;

            if (!peerVpcId.equals(that.peerVpcId)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.peerOwnerId != null ? !this.peerOwnerId.equals(that.peerOwnerId) : that.peerOwnerId != null) return false;
            if (this.peerRegion != null ? !this.peerRegion.equals(that.peerRegion) : that.peerRegion != null) return false;
            if (this.peerRoleArn != null ? !this.peerRoleArn.equals(that.peerRoleArn) : that.peerRoleArn != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public int hashCode() {
            int result = this.peerVpcId.hashCode();
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.peerOwnerId != null ? this.peerOwnerId.hashCode() : 0);
            result = 31 * result + (this.peerRegion != null ? this.peerRegion.hashCode() : 0);
            result = 31 * result + (this.peerRoleArn != null ? this.peerRoleArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
