package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::Instance`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:19:46.909Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnInstance")
public class CfnInstance extends software.amazon.awscdk.core.CfnResource {
    protected CfnInstance(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnInstance.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::EC2::Instance`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnInstance(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }
    /**
     * Create a new `AWS::EC2::Instance`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnInstance(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrAvailabilityZone() {
        return this.jsiiGet("attrAvailabilityZone", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrPrivateDnsName() {
        return this.jsiiGet("attrPrivateDnsName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrPrivateIp() {
        return this.jsiiGet("attrPrivateIp", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrPublicDnsName() {
        return this.jsiiGet("attrPublicDnsName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrPublicIp() {
        return this.jsiiGet("attrPublicIp", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::EC2::Instance.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::EC2::Instance.AdditionalInfo`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getAdditionalInfo() {
        return this.jsiiGet("additionalInfo", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.AdditionalInfo`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAdditionalInfo(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("additionalInfo", value);
    }

    /**
     * `AWS::EC2::Instance.Affinity`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getAffinity() {
        return this.jsiiGet("affinity", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.Affinity`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAffinity(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("affinity", value);
    }

    /**
     * `AWS::EC2::Instance.AvailabilityZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getAvailabilityZone() {
        return this.jsiiGet("availabilityZone", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.AvailabilityZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAvailabilityZone(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("availabilityZone", value);
    }

    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getBlockDeviceMappings() {
        return this.jsiiGet("blockDeviceMappings", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setBlockDeviceMappings(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("blockDeviceMappings", value);
    }

    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setBlockDeviceMappings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("blockDeviceMappings", value);
    }

    /**
     * `AWS::EC2::Instance.CreditSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getCreditSpecification() {
        return this.jsiiGet("creditSpecification", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.CreditSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("creditSpecification", value);
    }

    /**
     * `AWS::EC2::Instance.CreditSpecification`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCreditSpecification(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnInstance.CreditSpecificationProperty value) {
        this.jsiiSet("creditSpecification", value);
    }

    /**
     * `AWS::EC2::Instance.DisableApiTermination`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getDisableApiTermination() {
        return this.jsiiGet("disableApiTermination", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.DisableApiTermination`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDisableApiTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
        this.jsiiSet("disableApiTermination", value);
    }

    /**
     * `AWS::EC2::Instance.DisableApiTermination`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDisableApiTermination(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("disableApiTermination", value);
    }

    /**
     * `AWS::EC2::Instance.EbsOptimized`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getEbsOptimized() {
        return this.jsiiGet("ebsOptimized", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.EbsOptimized`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEbsOptimized(@javax.annotation.Nullable final java.lang.Boolean value) {
        this.jsiiSet("ebsOptimized", value);
    }

    /**
     * `AWS::EC2::Instance.EbsOptimized`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEbsOptimized(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("ebsOptimized", value);
    }

    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getElasticGpuSpecifications() {
        return this.jsiiGet("elasticGpuSpecifications", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setElasticGpuSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("elasticGpuSpecifications", value);
    }

    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setElasticGpuSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("elasticGpuSpecifications", value);
    }

    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getElasticInferenceAccelerators() {
        return this.jsiiGet("elasticInferenceAccelerators", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setElasticInferenceAccelerators(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("elasticInferenceAccelerators", value);
    }

    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setElasticInferenceAccelerators(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("elasticInferenceAccelerators", value);
    }

    /**
     * `AWS::EC2::Instance.HostId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getHostId() {
        return this.jsiiGet("hostId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.HostId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHostId(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("hostId", value);
    }

    /**
     * `AWS::EC2::Instance.IamInstanceProfile`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getIamInstanceProfile() {
        return this.jsiiGet("iamInstanceProfile", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.IamInstanceProfile`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIamInstanceProfile(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("iamInstanceProfile", value);
    }

    /**
     * `AWS::EC2::Instance.ImageId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getImageId() {
        return this.jsiiGet("imageId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.ImageId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setImageId(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("imageId", value);
    }

    /**
     * `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getInstanceInitiatedShutdownBehavior() {
        return this.jsiiGet("instanceInitiatedShutdownBehavior", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setInstanceInitiatedShutdownBehavior(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("instanceInitiatedShutdownBehavior", value);
    }

    /**
     * `AWS::EC2::Instance.InstanceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getInstanceType() {
        return this.jsiiGet("instanceType", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.InstanceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setInstanceType(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("instanceType", value);
    }

    /**
     * `AWS::EC2::Instance.Ipv6AddressCount`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Number getIpv6AddressCount() {
        return this.jsiiGet("ipv6AddressCount", java.lang.Number.class);
    }

    /**
     * `AWS::EC2::Instance.Ipv6AddressCount`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
        this.jsiiSet("ipv6AddressCount", value);
    }

    /**
     * `AWS::EC2::Instance.Ipv6Addresses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getIpv6Addresses() {
        return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.Ipv6Addresses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("ipv6Addresses", value);
    }

    /**
     * `AWS::EC2::Instance.Ipv6Addresses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("ipv6Addresses", value);
    }

    /**
     * `AWS::EC2::Instance.KernelId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getKernelId() {
        return this.jsiiGet("kernelId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.KernelId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setKernelId(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("kernelId", value);
    }

    /**
     * `AWS::EC2::Instance.KeyName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getKeyName() {
        return this.jsiiGet("keyName", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.KeyName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setKeyName(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("keyName", value);
    }

    /**
     * `AWS::EC2::Instance.LaunchTemplate`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getLaunchTemplate() {
        return this.jsiiGet("launchTemplate", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.LaunchTemplate`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLaunchTemplate(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("launchTemplate", value);
    }

    /**
     * `AWS::EC2::Instance.LaunchTemplate`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLaunchTemplate(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnInstance.LaunchTemplateSpecificationProperty value) {
        this.jsiiSet("launchTemplate", value);
    }

    /**
     * `AWS::EC2::Instance.LicenseSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getLicenseSpecifications() {
        return this.jsiiGet("licenseSpecifications", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.LicenseSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLicenseSpecifications(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("licenseSpecifications", value);
    }

    /**
     * `AWS::EC2::Instance.LicenseSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLicenseSpecifications(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("licenseSpecifications", value);
    }

    /**
     * `AWS::EC2::Instance.Monitoring`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getMonitoring() {
        return this.jsiiGet("monitoring", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.Monitoring`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMonitoring(@javax.annotation.Nullable final java.lang.Boolean value) {
        this.jsiiSet("monitoring", value);
    }

    /**
     * `AWS::EC2::Instance.Monitoring`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMonitoring(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("monitoring", value);
    }

    /**
     * `AWS::EC2::Instance.NetworkInterfaces`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getNetworkInterfaces() {
        return this.jsiiGet("networkInterfaces", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.NetworkInterfaces`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNetworkInterfaces(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("networkInterfaces", value);
    }

    /**
     * `AWS::EC2::Instance.NetworkInterfaces`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setNetworkInterfaces(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("networkInterfaces", value);
    }

    /**
     * `AWS::EC2::Instance.PlacementGroupName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getPlacementGroupName() {
        return this.jsiiGet("placementGroupName", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.PlacementGroupName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPlacementGroupName(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("placementGroupName", value);
    }

    /**
     * `AWS::EC2::Instance.PrivateIpAddress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getPrivateIpAddress() {
        return this.jsiiGet("privateIpAddress", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.PrivateIpAddress`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("privateIpAddress", value);
    }

    /**
     * `AWS::EC2::Instance.RamdiskId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getRamdiskId() {
        return this.jsiiGet("ramdiskId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.RamdiskId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRamdiskId(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("ramdiskId", value);
    }

    /**
     * `AWS::EC2::Instance.SecurityGroupIds`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.util.List<java.lang.String> getSecurityGroupIds() {
        return this.jsiiGet("securityGroupIds", java.util.List.class);
    }

    /**
     * `AWS::EC2::Instance.SecurityGroupIds`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroupIds(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
        this.jsiiSet("securityGroupIds", value);
    }

    /**
     * `AWS::EC2::Instance.SecurityGroups`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.util.List<java.lang.String> getSecurityGroups() {
        return this.jsiiGet("securityGroups", java.util.List.class);
    }

    /**
     * `AWS::EC2::Instance.SecurityGroups`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroups(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
        this.jsiiSet("securityGroups", value);
    }

    /**
     * `AWS::EC2::Instance.SourceDestCheck`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getSourceDestCheck() {
        return this.jsiiGet("sourceDestCheck", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.SourceDestCheck`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSourceDestCheck(@javax.annotation.Nullable final java.lang.Boolean value) {
        this.jsiiSet("sourceDestCheck", value);
    }

    /**
     * `AWS::EC2::Instance.SourceDestCheck`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSourceDestCheck(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("sourceDestCheck", value);
    }

    /**
     * `AWS::EC2::Instance.SsmAssociations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getSsmAssociations() {
        return this.jsiiGet("ssmAssociations", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.SsmAssociations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSsmAssociations(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("ssmAssociations", value);
    }

    /**
     * `AWS::EC2::Instance.SsmAssociations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSsmAssociations(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("ssmAssociations", value);
    }

    /**
     * `AWS::EC2::Instance.SubnetId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getSubnetId() {
        return this.jsiiGet("subnetId", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.SubnetId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSubnetId(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("subnetId", value);
    }

    /**
     * `AWS::EC2::Instance.Tenancy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getTenancy() {
        return this.jsiiGet("tenancy", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.Tenancy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTenancy(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("tenancy", value);
    }

    /**
     * `AWS::EC2::Instance.UserData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.String getUserData() {
        return this.jsiiGet("userData", java.lang.String.class);
    }

    /**
     * `AWS::EC2::Instance.UserData`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setUserData(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("userData", value);
    }

    /**
     * `AWS::EC2::Instance.Volumes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @javax.annotation.Nullable
    public java.lang.Object getVolumes() {
        return this.jsiiGet("volumes", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::Instance.Volumes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVolumes(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("volumes", value);
    }

    /**
     * `AWS::EC2::Instance.Volumes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVolumes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
        this.jsiiSet("volumes", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AssociationParameterProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.AssociationParameterProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();
        /**
         * `CfnInstance.AssociationParameterProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getValue();

        /**
         * @return a {@link Builder} of {@link AssociationParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AssociationParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _key;
            private java.util.List<java.lang.String> _value;

            /**
             * Sets the value of Key
             * @param value `CfnInstance.AssociationParameterProperty.Key`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withKey(final java.lang.String value) {
                this._key = java.util.Objects.requireNonNull(value, "key is required");
                return this;
            }
            /**
             * Sets the value of Value
             * @param value `CfnInstance.AssociationParameterProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withValue(final java.util.List<java.lang.String> value) {
                this._value = java.util.Objects.requireNonNull(value, "value is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssociationParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AssociationParameterProperty build() {
                return new AssociationParameterProperty() {
                    private final java.lang.String $key = java.util.Objects.requireNonNull(_key, "key is required");
                    private final java.util.List<java.lang.String> $value = java.util.Objects.requireNonNull(_value, "value is required");

                    @Override
                    public java.lang.String getKey() {
                        return this.$key;
                    }

                    @Override
                    public java.util.List<java.lang.String> getValue() {
                        return this.$value;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("key", om.valueToTree(this.getKey()));
                        obj.set("value", om.valueToTree(this.getValue()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.AssociationParameterProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.AssociationParameterProperty.Key`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getKey() {
                return this.jsiiGet("key", java.lang.String.class);
            }

            /**
             * `CfnInstance.AssociationParameterProperty.Value`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.util.List<java.lang.String> getValue() {
                return this.jsiiGet("value", java.util.List.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface BlockDeviceMappingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.BlockDeviceMappingProperty.DeviceName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDeviceName();
        /**
         * `CfnInstance.BlockDeviceMappingProperty.Ebs`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEbs();
        /**
         * `CfnInstance.BlockDeviceMappingProperty.NoDevice`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getNoDevice();
        /**
         * `CfnInstance.BlockDeviceMappingProperty.VirtualName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVirtualName();

        /**
         * @return a {@link Builder} of {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link BlockDeviceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _deviceName;
            @javax.annotation.Nullable
            private java.lang.Object _ebs;
            @javax.annotation.Nullable
            private java.lang.Object _noDevice;
            @javax.annotation.Nullable
            private java.lang.String _virtualName;

            /**
             * Sets the value of DeviceName
             * @param value `CfnInstance.BlockDeviceMappingProperty.DeviceName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDeviceName(final java.lang.String value) {
                this._deviceName = java.util.Objects.requireNonNull(value, "deviceName is required");
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value `CfnInstance.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of Ebs
             * @param value `CfnInstance.BlockDeviceMappingProperty.Ebs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEbs(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnInstance.EbsProperty value) {
                this._ebs = value;
                return this;
            }
            /**
             * Sets the value of NoDevice
             * @param value `CfnInstance.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._noDevice = value;
                return this;
            }
            /**
             * Sets the value of NoDevice
             * @param value `CfnInstance.BlockDeviceMappingProperty.NoDevice`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withNoDevice(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.CfnInstance.NoDeviceProperty value) {
                this._noDevice = value;
                return this;
            }
            /**
             * Sets the value of VirtualName
             * @param value `CfnInstance.BlockDeviceMappingProperty.VirtualName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVirtualName(@javax.annotation.Nullable final java.lang.String value) {
                this._virtualName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockDeviceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public BlockDeviceMappingProperty build() {
                return new BlockDeviceMappingProperty() {
                    private final java.lang.String $deviceName = java.util.Objects.requireNonNull(_deviceName, "deviceName is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $ebs = _ebs;
                    @javax.annotation.Nullable
                    private final java.lang.Object $noDevice = _noDevice;
                    @javax.annotation.Nullable
                    private final java.lang.String $virtualName = _virtualName;

                    @Override
                    public java.lang.String getDeviceName() {
                        return this.$deviceName;
                    }

                    @Override
                    public java.lang.Object getEbs() {
                        return this.$ebs;
                    }

                    @Override
                    public java.lang.Object getNoDevice() {
                        return this.$noDevice;
                    }

                    @Override
                    public java.lang.String getVirtualName() {
                        return this.$virtualName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("deviceName", om.valueToTree(this.getDeviceName()));
                        if (this.getEbs() != null) {
                            obj.set("ebs", om.valueToTree(this.getEbs()));
                        }
                        if (this.getNoDevice() != null) {
                            obj.set("noDevice", om.valueToTree(this.getNoDevice()));
                        }
                        if (this.getVirtualName() != null) {
                            obj.set("virtualName", om.valueToTree(this.getVirtualName()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.BlockDeviceMappingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.BlockDeviceMappingProperty.DeviceName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getDeviceName() {
                return this.jsiiGet("deviceName", java.lang.String.class);
            }

            /**
             * `CfnInstance.BlockDeviceMappingProperty.Ebs`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getEbs() {
                return this.jsiiGet("ebs", java.lang.Object.class);
            }

            /**
             * `CfnInstance.BlockDeviceMappingProperty.NoDevice`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getNoDevice() {
                return this.jsiiGet("noDevice", java.lang.Object.class);
            }

            /**
             * `CfnInstance.BlockDeviceMappingProperty.VirtualName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getVirtualName() {
                return this.jsiiGet("virtualName", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CreditSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.CreditSpecificationProperty.CPUCredits`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCpuCredits();

        /**
         * @return a {@link Builder} of {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CreditSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _cpuCredits;

            /**
             * Sets the value of CpuCredits
             * @param value `CfnInstance.CreditSpecificationProperty.CPUCredits`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withCpuCredits(@javax.annotation.Nullable final java.lang.String value) {
                this._cpuCredits = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreditSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CreditSpecificationProperty build() {
                return new CreditSpecificationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $cpuCredits = _cpuCredits;

                    @Override
                    public java.lang.String getCpuCredits() {
                        return this.$cpuCredits;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getCpuCredits() != null) {
                            obj.set("cpuCredits", om.valueToTree(this.getCpuCredits()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.CreditSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.CreditSpecificationProperty.CPUCredits`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getCpuCredits() {
                return this.jsiiGet("cpuCredits", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface EbsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.EbsProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDeleteOnTermination();
        /**
         * `CfnInstance.EbsProperty.Encrypted`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEncrypted();
        /**
         * `CfnInstance.EbsProperty.Iops`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getIops();
        /**
         * `CfnInstance.EbsProperty.SnapshotId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSnapshotId();
        /**
         * `CfnInstance.EbsProperty.VolumeSize`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getVolumeSize();
        /**
         * `CfnInstance.EbsProperty.VolumeType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVolumeType();

        /**
         * @return a {@link Builder} of {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EbsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.Object _encrypted;
            @javax.annotation.Nullable
            private java.lang.Number _iops;
            @javax.annotation.Nullable
            private java.lang.String _snapshotId;
            @javax.annotation.Nullable
            private java.lang.Number _volumeSize;
            @javax.annotation.Nullable
            private java.lang.String _volumeType;

            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnInstance.EbsProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnInstance.EbsProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value `CfnInstance.EbsProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Encrypted
             * @param value `CfnInstance.EbsProperty.Encrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._encrypted = value;
                return this;
            }
            /**
             * Sets the value of Iops
             * @param value `CfnInstance.EbsProperty.Iops`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIops(@javax.annotation.Nullable final java.lang.Number value) {
                this._iops = value;
                return this;
            }
            /**
             * Sets the value of SnapshotId
             * @param value `CfnInstance.EbsProperty.SnapshotId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSnapshotId(@javax.annotation.Nullable final java.lang.String value) {
                this._snapshotId = value;
                return this;
            }
            /**
             * Sets the value of VolumeSize
             * @param value `CfnInstance.EbsProperty.VolumeSize`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVolumeSize(@javax.annotation.Nullable final java.lang.Number value) {
                this._volumeSize = value;
                return this;
            }
            /**
             * Sets the value of VolumeType
             * @param value `CfnInstance.EbsProperty.VolumeType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVolumeType(@javax.annotation.Nullable final java.lang.String value) {
                this._volumeType = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public EbsProperty build() {
                return new EbsProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private final java.lang.Object $encrypted = _encrypted;
                    @javax.annotation.Nullable
                    private final java.lang.Number $iops = _iops;
                    @javax.annotation.Nullable
                    private final java.lang.String $snapshotId = _snapshotId;
                    @javax.annotation.Nullable
                    private final java.lang.Number $volumeSize = _volumeSize;
                    @javax.annotation.Nullable
                    private final java.lang.String $volumeType = _volumeType;

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public java.lang.Object getEncrypted() {
                        return this.$encrypted;
                    }

                    @Override
                    public java.lang.Number getIops() {
                        return this.$iops;
                    }

                    @Override
                    public java.lang.String getSnapshotId() {
                        return this.$snapshotId;
                    }

                    @Override
                    public java.lang.Number getVolumeSize() {
                        return this.$volumeSize;
                    }

                    @Override
                    public java.lang.String getVolumeType() {
                        return this.$volumeType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getDeleteOnTermination() != null) {
                            obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                        }
                        if (this.getEncrypted() != null) {
                            obj.set("encrypted", om.valueToTree(this.getEncrypted()));
                        }
                        if (this.getIops() != null) {
                            obj.set("iops", om.valueToTree(this.getIops()));
                        }
                        if (this.getSnapshotId() != null) {
                            obj.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                        }
                        if (this.getVolumeSize() != null) {
                            obj.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                        }
                        if (this.getVolumeType() != null) {
                            obj.set("volumeType", om.valueToTree(this.getVolumeType()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.EbsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.EbsProperty.DeleteOnTermination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * `CfnInstance.EbsProperty.Encrypted`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getEncrypted() {
                return this.jsiiGet("encrypted", java.lang.Object.class);
            }

            /**
             * `CfnInstance.EbsProperty.Iops`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getIops() {
                return this.jsiiGet("iops", java.lang.Number.class);
            }

            /**
             * `CfnInstance.EbsProperty.SnapshotId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getSnapshotId() {
                return this.jsiiGet("snapshotId", java.lang.String.class);
            }

            /**
             * `CfnInstance.EbsProperty.VolumeSize`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getVolumeSize() {
                return this.jsiiGet("volumeSize", java.lang.Number.class);
            }

            /**
             * `CfnInstance.EbsProperty.VolumeType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getVolumeType() {
                return this.jsiiGet("volumeType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ElasticGpuSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.ElasticGpuSpecificationProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ElasticGpuSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _type;

            /**
             * Sets the value of Type
             * @param value `CfnInstance.ElasticGpuSpecificationProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticGpuSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ElasticGpuSpecificationProperty build() {
                return new ElasticGpuSpecificationProperty() {
                    private final java.lang.String $type = java.util.Objects.requireNonNull(_type, "type is required");

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("type", om.valueToTree(this.getType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.ElasticGpuSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.ElasticGpuSpecificationProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ElasticInferenceAcceleratorProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.ElasticInferenceAcceleratorProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ElasticInferenceAcceleratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _type;

            /**
             * Sets the value of Type
             * @param value `CfnInstance.ElasticInferenceAcceleratorProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticInferenceAcceleratorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ElasticInferenceAcceleratorProperty build() {
                return new ElasticInferenceAcceleratorProperty() {
                    private final java.lang.String $type = java.util.Objects.requireNonNull(_type, "type is required");

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("type", om.valueToTree(this.getType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.ElasticInferenceAcceleratorProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.ElasticInferenceAcceleratorProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface InstanceIpv6AddressProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.InstanceIpv6AddressProperty.Ipv6Address`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIpv6Address();

        /**
         * @return a {@link Builder} of {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InstanceIpv6AddressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _ipv6Address;

            /**
             * Sets the value of Ipv6Address
             * @param value `CfnInstance.InstanceIpv6AddressProperty.Ipv6Address`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIpv6Address(final java.lang.String value) {
                this._ipv6Address = java.util.Objects.requireNonNull(value, "ipv6Address is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceIpv6AddressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public InstanceIpv6AddressProperty build() {
                return new InstanceIpv6AddressProperty() {
                    private final java.lang.String $ipv6Address = java.util.Objects.requireNonNull(_ipv6Address, "ipv6Address is required");

                    @Override
                    public java.lang.String getIpv6Address() {
                        return this.$ipv6Address;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("ipv6Address", om.valueToTree(this.getIpv6Address()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.InstanceIpv6AddressProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.InstanceIpv6AddressProperty.Ipv6Address`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getIpv6Address() {
                return this.jsiiGet("ipv6Address", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LaunchTemplateSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.Version`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVersion();
        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLaunchTemplateId();
        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLaunchTemplateName();

        /**
         * @return a {@link Builder} of {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LaunchTemplateSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _version;
            @javax.annotation.Nullable
            private java.lang.String _launchTemplateId;
            @javax.annotation.Nullable
            private java.lang.String _launchTemplateName;

            /**
             * Sets the value of Version
             * @param value `CfnInstance.LaunchTemplateSpecificationProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVersion(final java.lang.String value) {
                this._version = java.util.Objects.requireNonNull(value, "version is required");
                return this;
            }
            /**
             * Sets the value of LaunchTemplateId
             * @param value `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withLaunchTemplateId(@javax.annotation.Nullable final java.lang.String value) {
                this._launchTemplateId = value;
                return this;
            }
            /**
             * Sets the value of LaunchTemplateName
             * @param value `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withLaunchTemplateName(@javax.annotation.Nullable final java.lang.String value) {
                this._launchTemplateName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LaunchTemplateSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LaunchTemplateSpecificationProperty build() {
                return new LaunchTemplateSpecificationProperty() {
                    private final java.lang.String $version = java.util.Objects.requireNonNull(_version, "version is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $launchTemplateId = _launchTemplateId;
                    @javax.annotation.Nullable
                    private final java.lang.String $launchTemplateName = _launchTemplateName;

                    @Override
                    public java.lang.String getVersion() {
                        return this.$version;
                    }

                    @Override
                    public java.lang.String getLaunchTemplateId() {
                        return this.$launchTemplateId;
                    }

                    @Override
                    public java.lang.String getLaunchTemplateName() {
                        return this.$launchTemplateName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("version", om.valueToTree(this.getVersion()));
                        if (this.getLaunchTemplateId() != null) {
                            obj.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
                        }
                        if (this.getLaunchTemplateName() != null) {
                            obj.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.LaunchTemplateSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.LaunchTemplateSpecificationProperty.Version`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getVersion() {
                return this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getLaunchTemplateId() {
                return this.jsiiGet("launchTemplateId", java.lang.String.class);
            }

            /**
             * `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getLaunchTemplateName() {
                return this.jsiiGet("launchTemplateName", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LicenseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLicenseConfigurationArn();

        /**
         * @return a {@link Builder} of {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link LicenseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _licenseConfigurationArn;

            /**
             * Sets the value of LicenseConfigurationArn
             * @param value `CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withLicenseConfigurationArn(final java.lang.String value) {
                this._licenseConfigurationArn = java.util.Objects.requireNonNull(value, "licenseConfigurationArn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LicenseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LicenseSpecificationProperty build() {
                return new LicenseSpecificationProperty() {
                    private final java.lang.String $licenseConfigurationArn = java.util.Objects.requireNonNull(_licenseConfigurationArn, "licenseConfigurationArn is required");

                    @Override
                    public java.lang.String getLicenseConfigurationArn() {
                        return this.$licenseConfigurationArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("licenseConfigurationArn", om.valueToTree(this.getLicenseConfigurationArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.LicenseSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getLicenseConfigurationArn() {
                return this.jsiiGet("licenseConfigurationArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.NetworkInterfaceProperty.DeviceIndex`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDeviceIndex();
        /**
         * `CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAssociatePublicIpAddress();
        /**
         * `CfnInstance.NetworkInterfaceProperty.DeleteOnTermination`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getDeleteOnTermination();
        /**
         * `CfnInstance.NetworkInterfaceProperty.Description`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDescription();
        /**
         * `CfnInstance.NetworkInterfaceProperty.GroupSet`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getGroupSet();
        /**
         * `CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getIpv6AddressCount();
        /**
         * `CfnInstance.NetworkInterfaceProperty.Ipv6Addresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getIpv6Addresses();
        /**
         * `CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getNetworkInterfaceId();
        /**
         * `CfnInstance.NetworkInterfaceProperty.PrivateIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrivateIpAddress();
        /**
         * `CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPrivateIpAddresses();
        /**
         * `CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getSecondaryPrivateIpAddressCount();
        /**
         * `CfnInstance.NetworkInterfaceProperty.SubnetId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSubnetId();

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _deviceIndex;
            @javax.annotation.Nullable
            private java.lang.Object _associatePublicIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _deleteOnTermination;
            @javax.annotation.Nullable
            private java.lang.String _description;
            @javax.annotation.Nullable
            private java.util.List<java.lang.String> _groupSet;
            @javax.annotation.Nullable
            private java.lang.Number _ipv6AddressCount;
            @javax.annotation.Nullable
            private java.lang.Object _ipv6Addresses;
            @javax.annotation.Nullable
            private java.lang.String _networkInterfaceId;
            @javax.annotation.Nullable
            private java.lang.String _privateIpAddress;
            @javax.annotation.Nullable
            private java.lang.Object _privateIpAddresses;
            @javax.annotation.Nullable
            private java.lang.Number _secondaryPrivateIpAddressCount;
            @javax.annotation.Nullable
            private java.lang.String _subnetId;

            /**
             * Sets the value of DeviceIndex
             * @param value `CfnInstance.NetworkInterfaceProperty.DeviceIndex`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDeviceIndex(final java.lang.String value) {
                this._deviceIndex = java.util.Objects.requireNonNull(value, "deviceIndex is required");
                return this;
            }
            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value `CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of AssociatePublicIpAddress
             * @param value `CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withAssociatePublicIpAddress(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._associatePublicIpAddress = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnInstance.NetworkInterfaceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of DeleteOnTermination
             * @param value `CfnInstance.NetworkInterfaceProperty.DeleteOnTermination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDeleteOnTermination(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._deleteOnTermination = value;
                return this;
            }
            /**
             * Sets the value of Description
             * @param value `CfnInstance.NetworkInterfaceProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
                this._description = value;
                return this;
            }
            /**
             * Sets the value of GroupSet
             * @param value `CfnInstance.NetworkInterfaceProperty.GroupSet`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withGroupSet(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                this._groupSet = value;
                return this;
            }
            /**
             * Sets the value of Ipv6AddressCount
             * @param value `CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIpv6AddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._ipv6AddressCount = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value `CfnInstance.NetworkInterfaceProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIpv6Addresses(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of Ipv6Addresses
             * @param value `CfnInstance.NetworkInterfaceProperty.Ipv6Addresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withIpv6Addresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._ipv6Addresses = value;
                return this;
            }
            /**
             * Sets the value of NetworkInterfaceId
             * @param value `CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
                this._networkInterfaceId = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value `CfnInstance.NetworkInterfaceProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPrivateIpAddress(@javax.annotation.Nullable final java.lang.String value) {
                this._privateIpAddress = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value `CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of PrivateIpAddresses
             * @param value `CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPrivateIpAddresses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._privateIpAddresses = value;
                return this;
            }
            /**
             * Sets the value of SecondaryPrivateIpAddressCount
             * @param value `CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSecondaryPrivateIpAddressCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._secondaryPrivateIpAddressCount = value;
                return this;
            }
            /**
             * Sets the value of SubnetId
             * @param value `CfnInstance.NetworkInterfaceProperty.SubnetId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withSubnetId(@javax.annotation.Nullable final java.lang.String value) {
                this._subnetId = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NetworkInterfaceProperty build() {
                return new NetworkInterfaceProperty() {
                    private final java.lang.String $deviceIndex = java.util.Objects.requireNonNull(_deviceIndex, "deviceIndex is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $associatePublicIpAddress = _associatePublicIpAddress;
                    @javax.annotation.Nullable
                    private final java.lang.Object $deleteOnTermination = _deleteOnTermination;
                    @javax.annotation.Nullable
                    private final java.lang.String $description = _description;
                    @javax.annotation.Nullable
                    private final java.util.List<java.lang.String> $groupSet = _groupSet;
                    @javax.annotation.Nullable
                    private final java.lang.Number $ipv6AddressCount = _ipv6AddressCount;
                    @javax.annotation.Nullable
                    private final java.lang.Object $ipv6Addresses = _ipv6Addresses;
                    @javax.annotation.Nullable
                    private final java.lang.String $networkInterfaceId = _networkInterfaceId;
                    @javax.annotation.Nullable
                    private final java.lang.String $privateIpAddress = _privateIpAddress;
                    @javax.annotation.Nullable
                    private final java.lang.Object $privateIpAddresses = _privateIpAddresses;
                    @javax.annotation.Nullable
                    private final java.lang.Number $secondaryPrivateIpAddressCount = _secondaryPrivateIpAddressCount;
                    @javax.annotation.Nullable
                    private final java.lang.String $subnetId = _subnetId;

                    @Override
                    public java.lang.String getDeviceIndex() {
                        return this.$deviceIndex;
                    }

                    @Override
                    public java.lang.Object getAssociatePublicIpAddress() {
                        return this.$associatePublicIpAddress;
                    }

                    @Override
                    public java.lang.Object getDeleteOnTermination() {
                        return this.$deleteOnTermination;
                    }

                    @Override
                    public java.lang.String getDescription() {
                        return this.$description;
                    }

                    @Override
                    public java.util.List<java.lang.String> getGroupSet() {
                        return this.$groupSet;
                    }

                    @Override
                    public java.lang.Number getIpv6AddressCount() {
                        return this.$ipv6AddressCount;
                    }

                    @Override
                    public java.lang.Object getIpv6Addresses() {
                        return this.$ipv6Addresses;
                    }

                    @Override
                    public java.lang.String getNetworkInterfaceId() {
                        return this.$networkInterfaceId;
                    }

                    @Override
                    public java.lang.String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    @Override
                    public java.lang.Object getPrivateIpAddresses() {
                        return this.$privateIpAddresses;
                    }

                    @Override
                    public java.lang.Number getSecondaryPrivateIpAddressCount() {
                        return this.$secondaryPrivateIpAddressCount;
                    }

                    @Override
                    public java.lang.String getSubnetId() {
                        return this.$subnetId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("deviceIndex", om.valueToTree(this.getDeviceIndex()));
                        if (this.getAssociatePublicIpAddress() != null) {
                            obj.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
                        }
                        if (this.getDeleteOnTermination() != null) {
                            obj.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
                        }
                        if (this.getDescription() != null) {
                            obj.set("description", om.valueToTree(this.getDescription()));
                        }
                        if (this.getGroupSet() != null) {
                            obj.set("groupSet", om.valueToTree(this.getGroupSet()));
                        }
                        if (this.getIpv6AddressCount() != null) {
                            obj.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
                        }
                        if (this.getIpv6Addresses() != null) {
                            obj.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
                        }
                        if (this.getNetworkInterfaceId() != null) {
                            obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                        }
                        if (this.getPrivateIpAddress() != null) {
                            obj.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                        }
                        if (this.getPrivateIpAddresses() != null) {
                            obj.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
                        }
                        if (this.getSecondaryPrivateIpAddressCount() != null) {
                            obj.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
                        }
                        if (this.getSubnetId() != null) {
                            obj.set("subnetId", om.valueToTree(this.getSubnetId()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.NetworkInterfaceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.NetworkInterfaceProperty.DeviceIndex`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getDeviceIndex() {
                return this.jsiiGet("deviceIndex", java.lang.String.class);
            }

            /**
             * `CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getAssociatePublicIpAddress() {
                return this.jsiiGet("associatePublicIpAddress", java.lang.Object.class);
            }

            /**
             * `CfnInstance.NetworkInterfaceProperty.DeleteOnTermination`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getDeleteOnTermination() {
                return this.jsiiGet("deleteOnTermination", java.lang.Object.class);
            }

            /**
             * `CfnInstance.NetworkInterfaceProperty.Description`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getDescription() {
                return this.jsiiGet("description", java.lang.String.class);
            }

            /**
             * `CfnInstance.NetworkInterfaceProperty.GroupSet`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.util.List<java.lang.String> getGroupSet() {
                return this.jsiiGet("groupSet", java.util.List.class);
            }

            /**
             * `CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getIpv6AddressCount() {
                return this.jsiiGet("ipv6AddressCount", java.lang.Number.class);
            }

            /**
             * `CfnInstance.NetworkInterfaceProperty.Ipv6Addresses`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getIpv6Addresses() {
                return this.jsiiGet("ipv6Addresses", java.lang.Object.class);
            }

            /**
             * `CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getNetworkInterfaceId() {
                return this.jsiiGet("networkInterfaceId", java.lang.String.class);
            }

            /**
             * `CfnInstance.NetworkInterfaceProperty.PrivateIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.String.class);
            }

            /**
             * `CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getPrivateIpAddresses() {
                return this.jsiiGet("privateIpAddresses", java.lang.Object.class);
            }

            /**
             * `CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Number getSecondaryPrivateIpAddressCount() {
                return this.jsiiGet("secondaryPrivateIpAddressCount", java.lang.Number.class);
            }

            /**
             * `CfnInstance.NetworkInterfaceProperty.SubnetId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.String getSubnetId() {
                return this.jsiiGet("subnetId", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-nodevice.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface NoDeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link NoDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link NoDeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {


            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoDeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public NoDeviceProperty build() {
                return new NoDeviceProperty() {

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.NoDeviceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PrivateIpAddressSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.PrivateIpAddressSpecificationProperty.Primary`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getPrimary();
        /**
         * `CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPrivateIpAddress();

        /**
         * @return a {@link Builder} of {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PrivateIpAddressSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object _primary;
            private java.lang.String _privateIpAddress;

            /**
             * Sets the value of Primary
             * @param value `CfnInstance.PrivateIpAddressSpecificationProperty.Primary`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPrimary(final java.lang.Boolean value) {
                this._primary = java.util.Objects.requireNonNull(value, "primary is required");
                return this;
            }
            /**
             * Sets the value of Primary
             * @param value `CfnInstance.PrivateIpAddressSpecificationProperty.Primary`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPrimary(final software.amazon.awscdk.core.IResolvable value) {
                this._primary = java.util.Objects.requireNonNull(value, "primary is required");
                return this;
            }
            /**
             * Sets the value of PrivateIpAddress
             * @param value `CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withPrivateIpAddress(final java.lang.String value) {
                this._privateIpAddress = java.util.Objects.requireNonNull(value, "privateIpAddress is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrivateIpAddressSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PrivateIpAddressSpecificationProperty build() {
                return new PrivateIpAddressSpecificationProperty() {
                    private final java.lang.Object $primary = java.util.Objects.requireNonNull(_primary, "primary is required");
                    private final java.lang.String $privateIpAddress = java.util.Objects.requireNonNull(_privateIpAddress, "privateIpAddress is required");

                    @Override
                    public java.lang.Object getPrimary() {
                        return this.$primary;
                    }

                    @Override
                    public java.lang.String getPrivateIpAddress() {
                        return this.$privateIpAddress;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("primary", om.valueToTree(this.getPrimary()));
                        obj.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.PrivateIpAddressSpecificationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.PrivateIpAddressSpecificationProperty.Primary`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.Object getPrimary() {
                return this.jsiiGet("primary", java.lang.Object.class);
            }

            /**
             * `CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getPrivateIpAddress() {
                return this.jsiiGet("privateIpAddress", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface SsmAssociationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.SsmAssociationProperty.DocumentName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDocumentName();
        /**
         * `CfnInstance.SsmAssociationProperty.AssociationParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAssociationParameters();

        /**
         * @return a {@link Builder} of {@link SsmAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SsmAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _documentName;
            @javax.annotation.Nullable
            private java.lang.Object _associationParameters;

            /**
             * Sets the value of DocumentName
             * @param value `CfnInstance.SsmAssociationProperty.DocumentName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDocumentName(final java.lang.String value) {
                this._documentName = java.util.Objects.requireNonNull(value, "documentName is required");
                return this;
            }
            /**
             * Sets the value of AssociationParameters
             * @param value `CfnInstance.SsmAssociationProperty.AssociationParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withAssociationParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._associationParameters = value;
                return this;
            }
            /**
             * Sets the value of AssociationParameters
             * @param value `CfnInstance.SsmAssociationProperty.AssociationParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withAssociationParameters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._associationParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SsmAssociationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public SsmAssociationProperty build() {
                return new SsmAssociationProperty() {
                    private final java.lang.String $documentName = java.util.Objects.requireNonNull(_documentName, "documentName is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $associationParameters = _associationParameters;

                    @Override
                    public java.lang.String getDocumentName() {
                        return this.$documentName;
                    }

                    @Override
                    public java.lang.Object getAssociationParameters() {
                        return this.$associationParameters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("documentName", om.valueToTree(this.getDocumentName()));
                        if (this.getAssociationParameters() != null) {
                            obj.set("associationParameters", om.valueToTree(this.getAssociationParameters()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.SsmAssociationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.SsmAssociationProperty.DocumentName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getDocumentName() {
                return this.jsiiGet("documentName", java.lang.String.class);
            }

            /**
             * `CfnInstance.SsmAssociationProperty.AssociationParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            @javax.annotation.Nullable
            public java.lang.Object getAssociationParameters() {
                return this.jsiiGet("associationParameters", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface VolumeProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnInstance.VolumeProperty.Device`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDevice();
        /**
         * `CfnInstance.VolumeProperty.VolumeId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVolumeId();

        /**
         * @return a {@link Builder} of {@link VolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link VolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String _device;
            private java.lang.String _volumeId;

            /**
             * Sets the value of Device
             * @param value `CfnInstance.VolumeProperty.Device`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withDevice(final java.lang.String value) {
                this._device = java.util.Objects.requireNonNull(value, "device is required");
                return this;
            }
            /**
             * Sets the value of VolumeId
             * @param value `CfnInstance.VolumeProperty.VolumeId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder withVolumeId(final java.lang.String value) {
                this._volumeId = java.util.Objects.requireNonNull(value, "volumeId is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public VolumeProperty build() {
                return new VolumeProperty() {
                    private final java.lang.String $device = java.util.Objects.requireNonNull(_device, "device is required");
                    private final java.lang.String $volumeId = java.util.Objects.requireNonNull(_volumeId, "volumeId is required");

                    @Override
                    public java.lang.String getDevice() {
                        return this.$device;
                    }

                    @Override
                    public java.lang.String getVolumeId() {
                        return this.$volumeId;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("device", om.valueToTree(this.getDevice()));
                        obj.set("volumeId", om.valueToTree(this.getVolumeId()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnInstance.VolumeProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnInstance.VolumeProperty.Device`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getDevice() {
                return this.jsiiGet("device", java.lang.String.class);
            }

            /**
             * `CfnInstance.VolumeProperty.VolumeId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public java.lang.String getVolumeId() {
                return this.jsiiGet("volumeId", java.lang.String.class);
            }
        }
    }
}
