package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::Route`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:19:46.946Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnRouteProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::EC2::Route.RouteTableId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRouteTableId();
    /**
     * `AWS::EC2::Route.DestinationCidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDestinationCidrBlock();
    /**
     * `AWS::EC2::Route.DestinationIpv6CidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDestinationIpv6CidrBlock();
    /**
     * `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getEgressOnlyInternetGatewayId();
    /**
     * `AWS::EC2::Route.GatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getGatewayId();
    /**
     * `AWS::EC2::Route.InstanceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getInstanceId();
    /**
     * `AWS::EC2::Route.NatGatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getNatGatewayId();
    /**
     * `AWS::EC2::Route.NetworkInterfaceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getNetworkInterfaceId();
    /**
     * `AWS::EC2::Route.TransitGatewayId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getTransitGatewayId();
    /**
     * `AWS::EC2::Route.VpcPeeringConnectionId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getVpcPeeringConnectionId();

    /**
     * @return a {@link Builder} of {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Builder {
        private java.lang.String _routeTableId;
        @javax.annotation.Nullable
        private java.lang.String _destinationCidrBlock;
        @javax.annotation.Nullable
        private java.lang.String _destinationIpv6CidrBlock;
        @javax.annotation.Nullable
        private java.lang.String _egressOnlyInternetGatewayId;
        @javax.annotation.Nullable
        private java.lang.String _gatewayId;
        @javax.annotation.Nullable
        private java.lang.String _instanceId;
        @javax.annotation.Nullable
        private java.lang.String _natGatewayId;
        @javax.annotation.Nullable
        private java.lang.String _networkInterfaceId;
        @javax.annotation.Nullable
        private java.lang.String _transitGatewayId;
        @javax.annotation.Nullable
        private java.lang.String _vpcPeeringConnectionId;

        /**
         * Sets the value of RouteTableId
         * @param value `AWS::EC2::Route.RouteTableId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withRouteTableId(final java.lang.String value) {
            this._routeTableId = java.util.Objects.requireNonNull(value, "routeTableId is required");
            return this;
        }
        /**
         * Sets the value of DestinationCidrBlock
         * @param value `AWS::EC2::Route.DestinationCidrBlock`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withDestinationCidrBlock(@javax.annotation.Nullable final java.lang.String value) {
            this._destinationCidrBlock = value;
            return this;
        }
        /**
         * Sets the value of DestinationIpv6CidrBlock
         * @param value `AWS::EC2::Route.DestinationIpv6CidrBlock`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withDestinationIpv6CidrBlock(@javax.annotation.Nullable final java.lang.String value) {
            this._destinationIpv6CidrBlock = value;
            return this;
        }
        /**
         * Sets the value of EgressOnlyInternetGatewayId
         * @param value `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withEgressOnlyInternetGatewayId(@javax.annotation.Nullable final java.lang.String value) {
            this._egressOnlyInternetGatewayId = value;
            return this;
        }
        /**
         * Sets the value of GatewayId
         * @param value `AWS::EC2::Route.GatewayId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withGatewayId(@javax.annotation.Nullable final java.lang.String value) {
            this._gatewayId = value;
            return this;
        }
        /**
         * Sets the value of InstanceId
         * @param value `AWS::EC2::Route.InstanceId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withInstanceId(@javax.annotation.Nullable final java.lang.String value) {
            this._instanceId = value;
            return this;
        }
        /**
         * Sets the value of NatGatewayId
         * @param value `AWS::EC2::Route.NatGatewayId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withNatGatewayId(@javax.annotation.Nullable final java.lang.String value) {
            this._natGatewayId = value;
            return this;
        }
        /**
         * Sets the value of NetworkInterfaceId
         * @param value `AWS::EC2::Route.NetworkInterfaceId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withNetworkInterfaceId(@javax.annotation.Nullable final java.lang.String value) {
            this._networkInterfaceId = value;
            return this;
        }
        /**
         * Sets the value of TransitGatewayId
         * @param value `AWS::EC2::Route.TransitGatewayId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withTransitGatewayId(@javax.annotation.Nullable final java.lang.String value) {
            this._transitGatewayId = value;
            return this;
        }
        /**
         * Sets the value of VpcPeeringConnectionId
         * @param value `AWS::EC2::Route.VpcPeeringConnectionId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder withVpcPeeringConnectionId(@javax.annotation.Nullable final java.lang.String value) {
            this._vpcPeeringConnectionId = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnRouteProps build() {
            return new CfnRouteProps() {
                private final java.lang.String $routeTableId = java.util.Objects.requireNonNull(_routeTableId, "routeTableId is required");
                @javax.annotation.Nullable
                private final java.lang.String $destinationCidrBlock = _destinationCidrBlock;
                @javax.annotation.Nullable
                private final java.lang.String $destinationIpv6CidrBlock = _destinationIpv6CidrBlock;
                @javax.annotation.Nullable
                private final java.lang.String $egressOnlyInternetGatewayId = _egressOnlyInternetGatewayId;
                @javax.annotation.Nullable
                private final java.lang.String $gatewayId = _gatewayId;
                @javax.annotation.Nullable
                private final java.lang.String $instanceId = _instanceId;
                @javax.annotation.Nullable
                private final java.lang.String $natGatewayId = _natGatewayId;
                @javax.annotation.Nullable
                private final java.lang.String $networkInterfaceId = _networkInterfaceId;
                @javax.annotation.Nullable
                private final java.lang.String $transitGatewayId = _transitGatewayId;
                @javax.annotation.Nullable
                private final java.lang.String $vpcPeeringConnectionId = _vpcPeeringConnectionId;

                @Override
                public java.lang.String getRouteTableId() {
                    return this.$routeTableId;
                }

                @Override
                public java.lang.String getDestinationCidrBlock() {
                    return this.$destinationCidrBlock;
                }

                @Override
                public java.lang.String getDestinationIpv6CidrBlock() {
                    return this.$destinationIpv6CidrBlock;
                }

                @Override
                public java.lang.String getEgressOnlyInternetGatewayId() {
                    return this.$egressOnlyInternetGatewayId;
                }

                @Override
                public java.lang.String getGatewayId() {
                    return this.$gatewayId;
                }

                @Override
                public java.lang.String getInstanceId() {
                    return this.$instanceId;
                }

                @Override
                public java.lang.String getNatGatewayId() {
                    return this.$natGatewayId;
                }

                @Override
                public java.lang.String getNetworkInterfaceId() {
                    return this.$networkInterfaceId;
                }

                @Override
                public java.lang.String getTransitGatewayId() {
                    return this.$transitGatewayId;
                }

                @Override
                public java.lang.String getVpcPeeringConnectionId() {
                    return this.$vpcPeeringConnectionId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("routeTableId", om.valueToTree(this.getRouteTableId()));
                    if (this.getDestinationCidrBlock() != null) {
                        obj.set("destinationCidrBlock", om.valueToTree(this.getDestinationCidrBlock()));
                    }
                    if (this.getDestinationIpv6CidrBlock() != null) {
                        obj.set("destinationIpv6CidrBlock", om.valueToTree(this.getDestinationIpv6CidrBlock()));
                    }
                    if (this.getEgressOnlyInternetGatewayId() != null) {
                        obj.set("egressOnlyInternetGatewayId", om.valueToTree(this.getEgressOnlyInternetGatewayId()));
                    }
                    if (this.getGatewayId() != null) {
                        obj.set("gatewayId", om.valueToTree(this.getGatewayId()));
                    }
                    if (this.getInstanceId() != null) {
                        obj.set("instanceId", om.valueToTree(this.getInstanceId()));
                    }
                    if (this.getNatGatewayId() != null) {
                        obj.set("natGatewayId", om.valueToTree(this.getNatGatewayId()));
                    }
                    if (this.getNetworkInterfaceId() != null) {
                        obj.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                    }
                    if (this.getTransitGatewayId() != null) {
                        obj.set("transitGatewayId", om.valueToTree(this.getTransitGatewayId()));
                    }
                    if (this.getVpcPeeringConnectionId() != null) {
                        obj.set("vpcPeeringConnectionId", om.valueToTree(this.getVpcPeeringConnectionId()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.CfnRouteProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::EC2::Route.RouteTableId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public java.lang.String getRouteTableId() {
            return this.jsiiGet("routeTableId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.DestinationCidrBlock`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getDestinationCidrBlock() {
            return this.jsiiGet("destinationCidrBlock", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.DestinationIpv6CidrBlock`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getDestinationIpv6CidrBlock() {
            return this.jsiiGet("destinationIpv6CidrBlock", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.EgressOnlyInternetGatewayId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getEgressOnlyInternetGatewayId() {
            return this.jsiiGet("egressOnlyInternetGatewayId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.GatewayId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getGatewayId() {
            return this.jsiiGet("gatewayId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.InstanceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getInstanceId() {
            return this.jsiiGet("instanceId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.NatGatewayId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getNatGatewayId() {
            return this.jsiiGet("natGatewayId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.NetworkInterfaceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getNetworkInterfaceId() {
            return this.jsiiGet("networkInterfaceId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.TransitGatewayId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getTransitGatewayId() {
            return this.jsiiGet("transitGatewayId", java.lang.String.class);
        }

        /**
         * `AWS::EC2::Route.VpcPeeringConnectionId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        @javax.annotation.Nullable
        public java.lang.String getVpcPeeringConnectionId() {
            return this.jsiiGet("vpcPeeringConnectionId", java.lang.String.class);
        }
    }
}
