/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.OperatingSystemType;
import software.amazon.awscdk.services.ec2.UserData;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface MachineImageConfig
extends JsiiSerializable {
    public String getImageId();

    public OperatingSystemType getOsType();

    public UserData getUserData();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _imageId;
        private OperatingSystemType _osType;
        @Nullable
        private UserData _userData;

        public Builder withImageId(String value) {
            this._imageId = Objects.requireNonNull(value, "imageId is required");
            return this;
        }

        public Builder withOsType(OperatingSystemType value) {
            this._osType = Objects.requireNonNull(value, "osType is required");
            return this;
        }

        public Builder withUserData(@Nullable UserData value) {
            this._userData = value;
            return this;
        }

        public MachineImageConfig build() {
            return new MachineImageConfig(){
                private final String $imageId;
                private final OperatingSystemType $osType;
                @Nullable
                private final UserData $userData;
                {
                    this.$imageId = Objects.requireNonNull(_imageId, "imageId is required");
                    this.$osType = Objects.requireNonNull(_osType, "osType is required");
                    this.$userData = _userData;
                }

                @Override
                public String getImageId() {
                    return this.$imageId;
                }

                @Override
                public OperatingSystemType getOsType() {
                    return this.$osType;
                }

                @Override
                public UserData getUserData() {
                    return this.$userData;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("imageId", om.valueToTree((Object)this.getImageId()));
                    obj.set("osType", om.valueToTree((Object)this.getOsType()));
                    if (this.getUserData() != null) {
                        obj.set("userData", om.valueToTree((Object)this.getUserData()));
                    }
                    return obj;
                }
            };
        }
    }
}

