/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface SecurityGroupProps
extends JsiiSerializable {
    public IVpc getVpc();

    public Boolean getAllowAllOutbound();

    public String getDescription();

    public String getSecurityGroupName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IVpc _vpc;
        @Nullable
        private Boolean _allowAllOutbound;
        @Nullable
        private String _description;
        @Nullable
        private String _securityGroupName;

        public Builder withVpc(IVpc value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withAllowAllOutbound(@Nullable Boolean value) {
            this._allowAllOutbound = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withSecurityGroupName(@Nullable String value) {
            this._securityGroupName = value;
            return this;
        }

        public SecurityGroupProps build() {
            return new SecurityGroupProps(){
                private final IVpc $vpc;
                @Nullable
                private final Boolean $allowAllOutbound;
                @Nullable
                private final String $description;
                @Nullable
                private final String $securityGroupName;
                {
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$allowAllOutbound = _allowAllOutbound;
                    this.$description = _description;
                    this.$securityGroupName = _securityGroupName;
                }

                @Override
                public IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public Boolean getAllowAllOutbound() {
                    return this.$allowAllOutbound;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public String getSecurityGroupName() {
                    return this.$securityGroupName;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("vpc", om.valueToTree((Object)this.getVpc()));
                    if (this.getAllowAllOutbound() != null) {
                        obj.set("allowAllOutbound", om.valueToTree((Object)this.getAllowAllOutbound()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getSecurityGroupName() != null) {
                        obj.set("securityGroupName", om.valueToTree((Object)this.getSecurityGroupName()));
                    }
                    return obj;
                }
            };
        }
    }
}

