/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.core.IDependable;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface SelectedSubnets
extends JsiiSerializable {
    public List<String> getAvailabilityZones();

    public Boolean getHasPublic();

    public IDependable getInternetConnectivityEstablished();

    public List<String> getSubnetIds();

    public List<ISubnet> getSubnets();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> _availabilityZones;
        private Boolean _hasPublic;
        private IDependable _internetConnectivityEstablished;
        private List<String> _subnetIds;
        private List<ISubnet> _subnets;

        public Builder withAvailabilityZones(List<String> value) {
            this._availabilityZones = Objects.requireNonNull(value, "availabilityZones is required");
            return this;
        }

        public Builder withHasPublic(Boolean value) {
            this._hasPublic = Objects.requireNonNull(value, "hasPublic is required");
            return this;
        }

        public Builder withInternetConnectivityEstablished(IDependable value) {
            this._internetConnectivityEstablished = Objects.requireNonNull(value, "internetConnectivityEstablished is required");
            return this;
        }

        public Builder withSubnetIds(List<String> value) {
            this._subnetIds = Objects.requireNonNull(value, "subnetIds is required");
            return this;
        }

        public Builder withSubnets(List<ISubnet> value) {
            this._subnets = Objects.requireNonNull(value, "subnets is required");
            return this;
        }

        public SelectedSubnets build() {
            return new SelectedSubnets(){
                private final List<String> $availabilityZones;
                private final Boolean $hasPublic;
                private final IDependable $internetConnectivityEstablished;
                private final List<String> $subnetIds;
                private final List<ISubnet> $subnets;
                {
                    this.$availabilityZones = Objects.requireNonNull(_availabilityZones, "availabilityZones is required");
                    this.$hasPublic = Objects.requireNonNull(_hasPublic, "hasPublic is required");
                    this.$internetConnectivityEstablished = Objects.requireNonNull(_internetConnectivityEstablished, "internetConnectivityEstablished is required");
                    this.$subnetIds = Objects.requireNonNull(_subnetIds, "subnetIds is required");
                    this.$subnets = Objects.requireNonNull(_subnets, "subnets is required");
                }

                @Override
                public List<String> getAvailabilityZones() {
                    return this.$availabilityZones;
                }

                @Override
                public Boolean getHasPublic() {
                    return this.$hasPublic;
                }

                @Override
                public IDependable getInternetConnectivityEstablished() {
                    return this.$internetConnectivityEstablished;
                }

                @Override
                public List<String> getSubnetIds() {
                    return this.$subnetIds;
                }

                @Override
                public List<ISubnet> getSubnets() {
                    return this.$subnets;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
                    obj.set("hasPublic", om.valueToTree((Object)this.getHasPublic()));
                    obj.set("internetConnectivityEstablished", om.valueToTree((Object)this.getInternetConnectivityEstablished()));
                    obj.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                    obj.set("subnets", om.valueToTree(this.getSubnets()));
                    return obj;
                }
            };
        }
    }
}

