/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.FromCloudFormationOptions;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.ec2.$Module;
import software.amazon.awscdk.services.ec2.CfnVPCEndpointProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.CfnVPCEndpoint")
public class CfnVPCEndpoint
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnVPCEndpoint.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnVPCEndpoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVPCEndpoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnVPCEndpoint(@NotNull Construct scope, @NotNull String id, @NotNull CfnVPCEndpointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static CfnVPCEndpoint fromCloudFormation(@NotNull Construct scope, @NotNull String id, @NotNull Object resourceAttributes, @NotNull FromCloudFormationOptions options) {
        return (CfnVPCEndpoint)((Object)JsiiObject.jsiiStaticCall(CfnVPCEndpoint.class, (String)"fromCloudFormation", CfnVPCEndpoint.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), resourceAttributes, Objects.requireNonNull(options, "options is required")}));
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreationTimestamp() {
        return (String)this.jsiiGet("attrCreationTimestamp", String.class);
    }

    @NotNull
    public List<String> getAttrDnsEntries() {
        return Collections.unmodifiableList((List)this.jsiiGet("attrDnsEntries", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public List<String> getAttrNetworkInterfaceIds() {
        return Collections.unmodifiableList((List)this.jsiiGet("attrNetworkInterfaceIds", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getPolicyDocument() {
        return this.jsiiGet("policyDocument", Object.class);
    }

    public void setPolicyDocument(@NotNull Object value) {
        this.jsiiSet("policyDocument", Objects.requireNonNull(value, "policyDocument is required"));
    }

    @NotNull
    public String getServiceName() {
        return (String)this.jsiiGet("serviceName", String.class);
    }

    public void setServiceName(@NotNull String value) {
        this.jsiiSet("serviceName", Objects.requireNonNull(value, "serviceName is required"));
    }

    @NotNull
    public String getVpcId() {
        return (String)this.jsiiGet("vpcId", String.class);
    }

    public void setVpcId(@NotNull String value) {
        this.jsiiSet("vpcId", Objects.requireNonNull(value, "vpcId is required"));
    }

    @Nullable
    public Object getPrivateDnsEnabled() {
        return this.jsiiGet("privateDnsEnabled", Object.class);
    }

    public void setPrivateDnsEnabled(@Nullable Boolean value) {
        this.jsiiSet("privateDnsEnabled", value);
    }

    public void setPrivateDnsEnabled(@Nullable IResolvable value) {
        this.jsiiSet("privateDnsEnabled", value);
    }

    @Nullable
    public List<String> getRouteTableIds() {
        return Optional.ofNullable((List)this.jsiiGet("routeTableIds", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setRouteTableIds(@Nullable List<String> value) {
        this.jsiiSet("routeTableIds", value);
    }

    @Nullable
    public List<String> getSecurityGroupIds() {
        return Optional.ofNullable((List)this.jsiiGet("securityGroupIds", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSecurityGroupIds(@Nullable List<String> value) {
        this.jsiiSet("securityGroupIds", value);
    }

    @Nullable
    public List<String> getSubnetIds() {
        return Optional.ofNullable((List)this.jsiiGet("subnetIds", NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setSubnetIds(@Nullable List<String> value) {
        this.jsiiSet("subnetIds", value);
    }

    @Nullable
    public String getVpcEndpointType() {
        return (String)this.jsiiGet("vpcEndpointType", String.class);
    }

    public void setVpcEndpointType(@Nullable String value) {
        this.jsiiSet("vpcEndpointType", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnVPCEndpointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnVPCEndpointProps.Builder();
        }

        public Builder serviceName(String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        public Builder policyDocument(Object policyDocument) {
            this.props.policyDocument(policyDocument);
            return this;
        }

        public Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.props.privateDnsEnabled(privateDnsEnabled);
            return this;
        }

        public Builder privateDnsEnabled(IResolvable privateDnsEnabled) {
            this.props.privateDnsEnabled(privateDnsEnabled);
            return this;
        }

        public Builder routeTableIds(List<String> routeTableIds) {
            this.props.routeTableIds(routeTableIds);
            return this;
        }

        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        public Builder vpcEndpointType(String vpcEndpointType) {
            this.props.vpcEndpointType(vpcEndpointType);
            return this;
        }

        public CfnVPCEndpoint build() {
            return new CfnVPCEndpoint(this.scope, this.id, this.props.build());
        }
    }
}

