/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IDependable;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.$Module;
import software.amazon.awscdk.services.ec2.AddRouteOptions;
import software.amazon.awscdk.services.ec2.INetworkAcl;
import software.amazon.awscdk.services.ec2.IRouteTable;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.SubnetAttributes;
import software.amazon.awscdk.services.ec2.SubnetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ec2.Subnet")
public class Subnet
extends Resource
implements ISubnet {
    protected Subnet(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Subnet(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Subnet(@NotNull Construct scope, @NotNull String id, @NotNull SubnetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ISubnet fromSubnetAttributes(@NotNull Construct scope, @NotNull String id, @NotNull SubnetAttributes attrs) {
        return (ISubnet)JsiiObject.jsiiStaticCall(Subnet.class, (String)"fromSubnetAttributes", ISubnet.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static ISubnet fromSubnetId(@NotNull Construct scope, @NotNull String id, @NotNull String subnetId) {
        return (ISubnet)JsiiObject.jsiiStaticCall(Subnet.class, (String)"fromSubnetId", ISubnet.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(subnetId, "subnetId is required")});
    }

    @NotNull
    public static Boolean isVpcSubnet(@NotNull Object x) {
        return (Boolean)JsiiObject.jsiiStaticCall(Subnet.class, (String)"isVpcSubnet", Boolean.class, (Object[])new Object[]{x});
    }

    public void addDefaultInternetRoute(@NotNull String gatewayId, @NotNull IDependable gatewayAttachment) {
        this.jsiiCall("addDefaultInternetRoute", NativeType.VOID, new Object[]{Objects.requireNonNull(gatewayId, "gatewayId is required"), Objects.requireNonNull(gatewayAttachment, "gatewayAttachment is required")});
    }

    public void addDefaultNatRoute(@NotNull String natGatewayId) {
        this.jsiiCall("addDefaultNatRoute", NativeType.VOID, new Object[]{Objects.requireNonNull(natGatewayId, "natGatewayId is required")});
    }

    public void addRoute(@NotNull String id, @NotNull AddRouteOptions options) {
        this.jsiiCall("addRoute", NativeType.VOID, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public void associateNetworkAcl(@NotNull String id, @NotNull INetworkAcl networkAcl) {
        this.jsiiCall("associateNetworkAcl", NativeType.VOID, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(networkAcl, "networkAcl is required")});
    }

    @Override
    @NotNull
    public String getAvailabilityZone() {
        return (String)this.jsiiGet("availabilityZone", String.class);
    }

    @NotNull
    public List<IDependable> getDependencyElements() {
        return Collections.unmodifiableList((List)this.jsiiGet("dependencyElements", NativeType.listOf((NativeType)NativeType.forClass(IDependable.class))));
    }

    @Override
    @NotNull
    public IDependable getInternetConnectivityEstablished() {
        return (IDependable)this.jsiiGet("internetConnectivityEstablished", IDependable.class);
    }

    @NotNull
    public INetworkAcl getNetworkAcl() {
        return (INetworkAcl)this.jsiiGet("networkAcl", INetworkAcl.class);
    }

    @Override
    @NotNull
    public IRouteTable getRouteTable() {
        return (IRouteTable)this.jsiiGet("routeTable", IRouteTable.class);
    }

    @NotNull
    public String getSubnetAvailabilityZone() {
        return (String)this.jsiiGet("subnetAvailabilityZone", String.class);
    }

    @Override
    @NotNull
    public String getSubnetId() {
        return (String)this.jsiiGet("subnetId", String.class);
    }

    @NotNull
    public List<String> getSubnetIpv6CidrBlocks() {
        return Collections.unmodifiableList((List)this.jsiiGet("subnetIpv6CidrBlocks", NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getSubnetNetworkAclAssociationId() {
        return (String)this.jsiiGet("subnetNetworkAclAssociationId", String.class);
    }

    @NotNull
    public String getSubnetVpcId() {
        return (String)this.jsiiGet("subnetVpcId", String.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final SubnetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new SubnetProps.Builder();
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder cidrBlock(String cidrBlock) {
            this.props.cidrBlock(cidrBlock);
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        public Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.props.mapPublicIpOnLaunch(mapPublicIpOnLaunch);
            return this;
        }

        public Subnet build() {
            return new Subnet(this.scope, this.id, this.props.build());
        }
    }
}

