package software.amazon.awscdk.services.ec2;

/**
 * Properties of the bastion host.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.6.0 (build 248e75b)", date = "2020-06-04T00:02:18.727Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.BastionHostLinuxProps")
@software.amazon.jsii.Jsii.Proxy(BastionHostLinuxProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BastionHostLinuxProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * VPC to launch the instance in.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * In which AZ to place the instance within the VPC.
     * <p>
     * Default: - Random zone.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
     * <p>
     * Each instance that is launched has an associated root device volume,
     * either an Amazon EBS volume or an instance store volume.
     * You can use block device mappings to specify additional EBS volumes or
     * instance store volumes to attach to an instance when it is launched.
     * <p>
     * Default: - Uses the block device mapping of the AMI
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> getBlockDevices() {
        return null;
    }

    /**
     * The name of the instance.
     * <p>
     * Default: 'BastionHost'
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceName() {
        return null;
    }

    /**
     * Type of instance to launch.
     * <p>
     * Default: 't3.nano'
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return null;
    }

    /**
     * The machine image to use.
     * <p>
     * Default: - An Amazon Linux 2 image which is kept up-to-date automatically (the instance
     * may be replaced on every deployment).
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
        return null;
    }

    /**
     * Security Group to assign to this instance.
     * <p>
     * Default: - create new security group with no inbound and all outbound traffic allowed
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * Select the subnets to run the bastion host in.
     * <p>
     * Set this to PUBLIC if you need to connect to this instance via the internet and cannot use SSM.
     * You have to allow port 22 manually by using the connections field
     * <p>
     * Default: - private subnets of the supplied VPC
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BastionHostLinuxProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BastionHostLinuxProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BastionHostLinuxProps> {
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.lang.String availabilityZone;
        private java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices;
        private java.lang.String instanceName;
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        private software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;

        /**
         * Sets the value of {@link BastionHostLinuxProps#getVpc}
         * @param vpc VPC to launch the instance in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link BastionHostLinuxProps#getAvailabilityZone}
         * @param availabilityZone In which AZ to place the instance within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link BastionHostLinuxProps#getBlockDevices}
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         *                     Each instance that is launched has an associated root device volume,
         *                     either an Amazon EBS volume or an instance store volume.
         *                     You can use block device mappings to specify additional EBS volumes or
         *                     instance store volumes to attach to an instance when it is launched.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder blockDevices(java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices) {
            this.blockDevices = blockDevices;
            return this;
        }

        /**
         * Sets the value of {@link BastionHostLinuxProps#getInstanceName}
         * @param instanceName The name of the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceName(java.lang.String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        /**
         * Sets the value of {@link BastionHostLinuxProps#getInstanceType}
         * @param instanceType Type of instance to launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link BastionHostLinuxProps#getMachineImage}
         * @param machineImage The machine image to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder machineImage(software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        /**
         * Sets the value of {@link BastionHostLinuxProps#getSecurityGroup}
         * @param securityGroup Security Group to assign to this instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link BastionHostLinuxProps#getSubnetSelection}
         * @param subnetSelection Select the subnets to run the bastion host in.
         *                        Set this to PUBLIC if you need to connect to this instance via the internet and cannot use SSM.
         *                        You have to allow port 22 manually by using the connections field
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BastionHostLinuxProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BastionHostLinuxProps build() {
            return new Jsii$Proxy(vpc, availabilityZone, blockDevices, instanceName, instanceType, machineImage, securityGroup, subnetSelection);
        }
    }

    /**
     * An implementation for {@link BastionHostLinuxProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BastionHostLinuxProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.String availabilityZone;
        private final java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices;
        private final java.lang.String instanceName;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.availabilityZone = this.jsiiGet("availabilityZone", java.lang.String.class);
            this.blockDevices = this.jsiiGet("blockDevices", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.BlockDevice.class)));
            this.instanceName = this.jsiiGet("instanceName", java.lang.String.class);
            this.instanceType = this.jsiiGet("instanceType", software.amazon.awscdk.services.ec2.InstanceType.class);
            this.machineImage = this.jsiiGet("machineImage", software.amazon.awscdk.services.ec2.IMachineImage.class);
            this.securityGroup = this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
            this.subnetSelection = this.jsiiGet("subnetSelection", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.IVpc vpc, final java.lang.String availabilityZone, final java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices, final java.lang.String instanceName, final software.amazon.awscdk.services.ec2.InstanceType instanceType, final software.amazon.awscdk.services.ec2.IMachineImage machineImage, final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.availabilityZone = availabilityZone;
            this.blockDevices = blockDevices;
            this.instanceName = instanceName;
            this.instanceType = instanceType;
            this.machineImage = machineImage;
            this.securityGroup = securityGroup;
            this.subnetSelection = subnetSelection;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> getBlockDevices() {
            return this.blockDevices;
        }

        @Override
        public java.lang.String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
            return this.machineImage;
        }

        @Override
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getBlockDevices() != null) {
                data.set("blockDevices", om.valueToTree(this.getBlockDevices()));
            }
            if (this.getInstanceName() != null) {
                data.set("instanceName", om.valueToTree(this.getInstanceName()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getMachineImage() != null) {
                data.set("machineImage", om.valueToTree(this.getMachineImage()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.BastionHostLinuxProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BastionHostLinuxProps.Jsii$Proxy that = (BastionHostLinuxProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.blockDevices != null ? !this.blockDevices.equals(that.blockDevices) : that.blockDevices != null) return false;
            if (this.instanceName != null ? !this.instanceName.equals(that.instanceName) : that.instanceName != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.machineImage != null ? !this.machineImage.equals(that.machineImage) : that.machineImage != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            return this.subnetSelection != null ? this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection == null;
        }

        @Override
        public int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.blockDevices != null ? this.blockDevices.hashCode() : 0);
            result = 31 * result + (this.instanceName != null ? this.instanceName.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.machineImage != null ? this.machineImage.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            return result;
        }
    }
}
