package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::TrafficMirrorSession`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.6.0 (build 248e75b)", date = "2020-06-04T00:02:18.828Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnTrafficMirrorSessionProps")
@software.amazon.jsii.Jsii.Proxy(CfnTrafficMirrorSessionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTrafficMirrorSessionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::TrafficMirrorSession.NetworkInterfaceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-networkinterfaceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNetworkInterfaceId();

    /**
     * `AWS::EC2::TrafficMirrorSession.SessionNumber`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-sessionnumber
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getSessionNumber();

    /**
     * `AWS::EC2::TrafficMirrorSession.TrafficMirrorFilterId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrorfilterid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrafficMirrorFilterId();

    /**
     * `AWS::EC2::TrafficMirrorSession.TrafficMirrorTargetId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-trafficmirrortargetid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrafficMirrorTargetId();

    /**
     * `AWS::EC2::TrafficMirrorSession.Description`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::EC2::TrafficMirrorSession.PacketLength`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-packetlength
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPacketLength() {
        return null;
    }

    /**
     * `AWS::EC2::TrafficMirrorSession.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::EC2::TrafficMirrorSession.VirtualNetworkId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-trafficmirrorsession.html#cfn-ec2-trafficmirrorsession-virtualnetworkid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVirtualNetworkId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTrafficMirrorSessionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTrafficMirrorSessionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTrafficMirrorSessionProps> {
        private java.lang.String networkInterfaceId;
        private java.lang.Number sessionNumber;
        private java.lang.String trafficMirrorFilterId;
        private java.lang.String trafficMirrorTargetId;
        private java.lang.String description;
        private java.lang.Number packetLength;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private java.lang.Number virtualNetworkId;

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getNetworkInterfaceId}
         * @param networkInterfaceId `AWS::EC2::TrafficMirrorSession.NetworkInterfaceId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getSessionNumber}
         * @param sessionNumber `AWS::EC2::TrafficMirrorSession.SessionNumber`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionNumber(java.lang.Number sessionNumber) {
            this.sessionNumber = sessionNumber;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getTrafficMirrorFilterId}
         * @param trafficMirrorFilterId `AWS::EC2::TrafficMirrorSession.TrafficMirrorFilterId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficMirrorFilterId(java.lang.String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getTrafficMirrorTargetId}
         * @param trafficMirrorTargetId `AWS::EC2::TrafficMirrorSession.TrafficMirrorTargetId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficMirrorTargetId(java.lang.String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getDescription}
         * @param description `AWS::EC2::TrafficMirrorSession.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getPacketLength}
         * @param packetLength `AWS::EC2::TrafficMirrorSession.PacketLength`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packetLength(java.lang.Number packetLength) {
            this.packetLength = packetLength;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getTags}
         * @param tags `AWS::EC2::TrafficMirrorSession.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrafficMirrorSessionProps#getVirtualNetworkId}
         * @param virtualNetworkId `AWS::EC2::TrafficMirrorSession.VirtualNetworkId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualNetworkId(java.lang.Number virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTrafficMirrorSessionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTrafficMirrorSessionProps build() {
            return new Jsii$Proxy(networkInterfaceId, sessionNumber, trafficMirrorFilterId, trafficMirrorTargetId, description, packetLength, tags, virtualNetworkId);
        }
    }

    /**
     * An implementation for {@link CfnTrafficMirrorSessionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTrafficMirrorSessionProps {
        private final java.lang.String networkInterfaceId;
        private final java.lang.Number sessionNumber;
        private final java.lang.String trafficMirrorFilterId;
        private final java.lang.String trafficMirrorTargetId;
        private final java.lang.String description;
        private final java.lang.Number packetLength;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Number virtualNetworkId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.networkInterfaceId = this.jsiiGet("networkInterfaceId", java.lang.String.class);
            this.sessionNumber = this.jsiiGet("sessionNumber", java.lang.Number.class);
            this.trafficMirrorFilterId = this.jsiiGet("trafficMirrorFilterId", java.lang.String.class);
            this.trafficMirrorTargetId = this.jsiiGet("trafficMirrorTargetId", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.packetLength = this.jsiiGet("packetLength", java.lang.Number.class);
            this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.virtualNetworkId = this.jsiiGet("virtualNetworkId", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String networkInterfaceId, final java.lang.Number sessionNumber, final java.lang.String trafficMirrorFilterId, final java.lang.String trafficMirrorTargetId, final java.lang.String description, final java.lang.Number packetLength, final java.util.List<software.amazon.awscdk.core.CfnTag> tags, final java.lang.Number virtualNetworkId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.networkInterfaceId = java.util.Objects.requireNonNull(networkInterfaceId, "networkInterfaceId is required");
            this.sessionNumber = java.util.Objects.requireNonNull(sessionNumber, "sessionNumber is required");
            this.trafficMirrorFilterId = java.util.Objects.requireNonNull(trafficMirrorFilterId, "trafficMirrorFilterId is required");
            this.trafficMirrorTargetId = java.util.Objects.requireNonNull(trafficMirrorTargetId, "trafficMirrorTargetId is required");
            this.description = description;
            this.packetLength = packetLength;
            this.tags = tags;
            this.virtualNetworkId = virtualNetworkId;
        }

        @Override
        public java.lang.String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public java.lang.Number getSessionNumber() {
            return this.sessionNumber;
        }

        @Override
        public java.lang.String getTrafficMirrorFilterId() {
            return this.trafficMirrorFilterId;
        }

        @Override
        public java.lang.String getTrafficMirrorTargetId() {
            return this.trafficMirrorTargetId;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.Number getPacketLength() {
            return this.packetLength;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.Number getVirtualNetworkId() {
            return this.virtualNetworkId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
            data.set("sessionNumber", om.valueToTree(this.getSessionNumber()));
            data.set("trafficMirrorFilterId", om.valueToTree(this.getTrafficMirrorFilterId()));
            data.set("trafficMirrorTargetId", om.valueToTree(this.getTrafficMirrorTargetId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getPacketLength() != null) {
                data.set("packetLength", om.valueToTree(this.getPacketLength()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVirtualNetworkId() != null) {
                data.set("virtualNetworkId", om.valueToTree(this.getVirtualNetworkId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnTrafficMirrorSessionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTrafficMirrorSessionProps.Jsii$Proxy that = (CfnTrafficMirrorSessionProps.Jsii$Proxy) o;

            if (!networkInterfaceId.equals(that.networkInterfaceId)) return false;
            if (!sessionNumber.equals(that.sessionNumber)) return false;
            if (!trafficMirrorFilterId.equals(that.trafficMirrorFilterId)) return false;
            if (!trafficMirrorTargetId.equals(that.trafficMirrorTargetId)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.packetLength != null ? !this.packetLength.equals(that.packetLength) : that.packetLength != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.virtualNetworkId != null ? this.virtualNetworkId.equals(that.virtualNetworkId) : that.virtualNetworkId == null;
        }

        @Override
        public int hashCode() {
            int result = this.networkInterfaceId.hashCode();
            result = 31 * result + (this.sessionNumber.hashCode());
            result = 31 * result + (this.trafficMirrorFilterId.hashCode());
            result = 31 * result + (this.trafficMirrorTargetId.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.packetLength != null ? this.packetLength.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.virtualNetworkId != null ? this.virtualNetworkId.hashCode() : 0);
            return result;
        }
    }
}
