package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::FlowLog`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.6.0 (build 248e75b)", date = "2020-06-04T14:11:01.235Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnFlowLogProps")
@software.amazon.jsii.Jsii.Proxy(CfnFlowLogProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFlowLogProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::FlowLog.ResourceId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

    /**
     * `AWS::EC2::FlowLog.ResourceType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

    /**
     * `AWS::EC2::FlowLog.TrafficType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrafficType();

    /**
     * `AWS::EC2::FlowLog.DeliverLogsPermissionArn`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-deliverlogspermissionarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliverLogsPermissionArn() {
        return null;
    }

    /**
     * `AWS::EC2::FlowLog.LogDestination`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogDestination() {
        return null;
    }

    /**
     * `AWS::EC2::FlowLog.LogDestinationType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogDestinationType() {
        return null;
    }

    /**
     * `AWS::EC2::FlowLog.LogGroupName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-loggroupname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFlowLogProps> {
        private java.lang.String resourceId;
        private java.lang.String resourceType;
        private java.lang.String trafficType;
        private java.lang.String deliverLogsPermissionArn;
        private java.lang.String logDestination;
        private java.lang.String logDestinationType;
        private java.lang.String logGroupName;

        /**
         * Sets the value of {@link CfnFlowLogProps#getResourceId}
         * @param resourceId `AWS::EC2::FlowLog.ResourceId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getResourceType}
         * @param resourceType `AWS::EC2::FlowLog.ResourceType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getTrafficType}
         * @param trafficType `AWS::EC2::FlowLog.TrafficType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficType(java.lang.String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getDeliverLogsPermissionArn}
         * @param deliverLogsPermissionArn `AWS::EC2::FlowLog.DeliverLogsPermissionArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliverLogsPermissionArn(java.lang.String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogDestination}
         * @param logDestination `AWS::EC2::FlowLog.LogDestination`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestination(java.lang.String logDestination) {
            this.logDestination = logDestination;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogDestinationType}
         * @param logDestinationType `AWS::EC2::FlowLog.LogDestinationType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDestinationType(java.lang.String logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowLogProps#getLogGroupName}
         * @param logGroupName `AWS::EC2::FlowLog.LogGroupName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(java.lang.String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFlowLogProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFlowLogProps build() {
            return new Jsii$Proxy(resourceId, resourceType, trafficType, deliverLogsPermissionArn, logDestination, logDestinationType, logGroupName);
        }
    }

    /**
     * An implementation for {@link CfnFlowLogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFlowLogProps {
        private final java.lang.String resourceId;
        private final java.lang.String resourceType;
        private final java.lang.String trafficType;
        private final java.lang.String deliverLogsPermissionArn;
        private final java.lang.String logDestination;
        private final java.lang.String logDestinationType;
        private final java.lang.String logGroupName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceId = this.jsiiGet("resourceId", java.lang.String.class);
            this.resourceType = this.jsiiGet("resourceType", java.lang.String.class);
            this.trafficType = this.jsiiGet("trafficType", java.lang.String.class);
            this.deliverLogsPermissionArn = this.jsiiGet("deliverLogsPermissionArn", java.lang.String.class);
            this.logDestination = this.jsiiGet("logDestination", java.lang.String.class);
            this.logDestinationType = this.jsiiGet("logDestinationType", java.lang.String.class);
            this.logGroupName = this.jsiiGet("logGroupName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String resourceId, final java.lang.String resourceType, final java.lang.String trafficType, final java.lang.String deliverLogsPermissionArn, final java.lang.String logDestination, final java.lang.String logDestinationType, final java.lang.String logGroupName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceId = java.util.Objects.requireNonNull(resourceId, "resourceId is required");
            this.resourceType = java.util.Objects.requireNonNull(resourceType, "resourceType is required");
            this.trafficType = java.util.Objects.requireNonNull(trafficType, "trafficType is required");
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            this.logDestination = logDestination;
            this.logDestinationType = logDestinationType;
            this.logGroupName = logGroupName;
        }

        @Override
        public java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        public java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        public java.lang.String getTrafficType() {
            return this.trafficType;
        }

        @Override
        public java.lang.String getDeliverLogsPermissionArn() {
            return this.deliverLogsPermissionArn;
        }

        @Override
        public java.lang.String getLogDestination() {
            return this.logDestination;
        }

        @Override
        public java.lang.String getLogDestinationType() {
            return this.logDestinationType;
        }

        @Override
        public java.lang.String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceId", om.valueToTree(this.getResourceId()));
            data.set("resourceType", om.valueToTree(this.getResourceType()));
            data.set("trafficType", om.valueToTree(this.getTrafficType()));
            if (this.getDeliverLogsPermissionArn() != null) {
                data.set("deliverLogsPermissionArn", om.valueToTree(this.getDeliverLogsPermissionArn()));
            }
            if (this.getLogDestination() != null) {
                data.set("logDestination", om.valueToTree(this.getLogDestination()));
            }
            if (this.getLogDestinationType() != null) {
                data.set("logDestinationType", om.valueToTree(this.getLogDestinationType()));
            }
            if (this.getLogGroupName() != null) {
                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnFlowLogProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFlowLogProps.Jsii$Proxy that = (CfnFlowLogProps.Jsii$Proxy) o;

            if (!resourceId.equals(that.resourceId)) return false;
            if (!resourceType.equals(that.resourceType)) return false;
            if (!trafficType.equals(that.trafficType)) return false;
            if (this.deliverLogsPermissionArn != null ? !this.deliverLogsPermissionArn.equals(that.deliverLogsPermissionArn) : that.deliverLogsPermissionArn != null) return false;
            if (this.logDestination != null ? !this.logDestination.equals(that.logDestination) : that.logDestination != null) return false;
            if (this.logDestinationType != null ? !this.logDestinationType.equals(that.logDestinationType) : that.logDestinationType != null) return false;
            return this.logGroupName != null ? this.logGroupName.equals(that.logGroupName) : that.logGroupName == null;
        }

        @Override
        public int hashCode() {
            int result = this.resourceId.hashCode();
            result = 31 * result + (this.resourceType.hashCode());
            result = 31 * result + (this.trafficType.hashCode());
            result = 31 * result + (this.deliverLogsPermissionArn != null ? this.deliverLogsPermissionArn.hashCode() : 0);
            result = 31 * result + (this.logDestination != null ? this.logDestination.hashCode() : 0);
            result = 31 * result + (this.logDestinationType != null ? this.logDestinationType.hashCode() : 0);
            result = 31 * result + (this.logGroupName != null ? this.logGroupName.hashCode() : 0);
            return result;
        }
    }
}
