package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `AWS::EC2::VPCEndpoint`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.6.0 (build 248e75b)", date = "2020-06-09T15:22:44.423Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnVPCEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPCEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPCEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::EC2::VPCEndpoint.ServiceName`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceName();

    /**
     * `AWS::EC2::VPCEndpoint.VpcId`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * `AWS::EC2::VPCEndpoint.PolicyDocument`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicyDocument() {
        return null;
    }

    /**
     * `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateDnsEnabled() {
        return null;
    }

    /**
     * `AWS::EC2::VPCEndpoint.RouteTableIds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRouteTableIds() {
        return null;
    }

    /**
     * `AWS::EC2::VPCEndpoint.SecurityGroupIds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * `AWS::EC2::VPCEndpoint.SubnetIds`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
        return null;
    }

    /**
     * `AWS::EC2::VPCEndpoint.VpcEndpointType`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPCEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPCEndpointProps> {
        private java.lang.String serviceName;
        private java.lang.String vpcId;
        private java.lang.Object policyDocument;
        private java.lang.Object privateDnsEnabled;
        private java.util.List<java.lang.String> routeTableIds;
        private java.util.List<java.lang.String> securityGroupIds;
        private java.util.List<java.lang.String> subnetIds;
        private java.lang.String vpcEndpointType;

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getServiceName}
         * @param serviceName `AWS::EC2::VPCEndpoint.ServiceName`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getVpcId}
         * @param vpcId `AWS::EC2::VPCEndpoint.VpcId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getPolicyDocument}
         * @param policyDocument `AWS::EC2::VPCEndpoint.PolicyDocument`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(java.lang.Object policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getPrivateDnsEnabled}
         * @param privateDnsEnabled `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsEnabled(java.lang.Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getPrivateDnsEnabled}
         * @param privateDnsEnabled `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsEnabled(software.amazon.awscdk.core.IResolvable privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getRouteTableIds}
         * @param routeTableIds `AWS::EC2::VPCEndpoint.RouteTableIds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeTableIds(java.util.List<java.lang.String> routeTableIds) {
            this.routeTableIds = routeTableIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getSecurityGroupIds}
         * @param securityGroupIds `AWS::EC2::VPCEndpoint.SecurityGroupIds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getSubnetIds}
         * @param subnetIds `AWS::EC2::VPCEndpoint.SubnetIds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEndpointProps#getVpcEndpointType}
         * @param vpcEndpointType `AWS::EC2::VPCEndpoint.VpcEndpointType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcEndpointType(java.lang.String vpcEndpointType) {
            this.vpcEndpointType = vpcEndpointType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPCEndpointProps build() {
            return new Jsii$Proxy(serviceName, vpcId, policyDocument, privateDnsEnabled, routeTableIds, securityGroupIds, subnetIds, vpcEndpointType);
        }
    }

    /**
     * An implementation for {@link CfnVPCEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCEndpointProps {
        private final java.lang.String serviceName;
        private final java.lang.String vpcId;
        private final java.lang.Object policyDocument;
        private final java.lang.Object privateDnsEnabled;
        private final java.util.List<java.lang.String> routeTableIds;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.lang.String vpcEndpointType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceName = this.jsiiGet("serviceName", java.lang.String.class);
            this.vpcId = this.jsiiGet("vpcId", java.lang.String.class);
            this.policyDocument = this.jsiiGet("policyDocument", java.lang.Object.class);
            this.privateDnsEnabled = this.jsiiGet("privateDnsEnabled", java.lang.Object.class);
            this.routeTableIds = this.jsiiGet("routeTableIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.securityGroupIds = this.jsiiGet("securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnetIds = this.jsiiGet("subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcEndpointType = this.jsiiGet("vpcEndpointType", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String serviceName, final java.lang.String vpcId, final java.lang.Object policyDocument, final java.lang.Object privateDnsEnabled, final java.util.List<java.lang.String> routeTableIds, final java.util.List<java.lang.String> securityGroupIds, final java.util.List<java.lang.String> subnetIds, final java.lang.String vpcEndpointType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceName = java.util.Objects.requireNonNull(serviceName, "serviceName is required");
            this.vpcId = java.util.Objects.requireNonNull(vpcId, "vpcId is required");
            this.policyDocument = policyDocument;
            this.privateDnsEnabled = privateDnsEnabled;
            this.routeTableIds = routeTableIds;
            this.securityGroupIds = securityGroupIds;
            this.subnetIds = subnetIds;
            this.vpcEndpointType = vpcEndpointType;
        }

        @Override
        public java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public java.lang.Object getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public java.lang.Object getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        @Override
        public java.util.List<java.lang.String> getRouteTableIds() {
            return this.routeTableIds;
        }

        @Override
        public java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public java.lang.String getVpcEndpointType() {
            return this.vpcEndpointType;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serviceName", om.valueToTree(this.getServiceName()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getPolicyDocument() != null) {
                data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            }
            if (this.getPrivateDnsEnabled() != null) {
                data.set("privateDnsEnabled", om.valueToTree(this.getPrivateDnsEnabled()));
            }
            if (this.getRouteTableIds() != null) {
                data.set("routeTableIds", om.valueToTree(this.getRouteTableIds()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSubnetIds() != null) {
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            }
            if (this.getVpcEndpointType() != null) {
                data.set("vpcEndpointType", om.valueToTree(this.getVpcEndpointType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.CfnVPCEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCEndpointProps.Jsii$Proxy that = (CfnVPCEndpointProps.Jsii$Proxy) o;

            if (!serviceName.equals(that.serviceName)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.policyDocument != null ? !this.policyDocument.equals(that.policyDocument) : that.policyDocument != null) return false;
            if (this.privateDnsEnabled != null ? !this.privateDnsEnabled.equals(that.privateDnsEnabled) : that.privateDnsEnabled != null) return false;
            if (this.routeTableIds != null ? !this.routeTableIds.equals(that.routeTableIds) : that.routeTableIds != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.subnetIds != null ? !this.subnetIds.equals(that.subnetIds) : that.subnetIds != null) return false;
            return this.vpcEndpointType != null ? this.vpcEndpointType.equals(that.vpcEndpointType) : that.vpcEndpointType == null;
        }

        @Override
        public int hashCode() {
            int result = this.serviceName.hashCode();
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.policyDocument != null ? this.policyDocument.hashCode() : 0);
            result = 31 * result + (this.privateDnsEnabled != null ? this.privateDnsEnabled.hashCode() : 0);
            result = 31 * result + (this.routeTableIds != null ? this.routeTableIds.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
            result = 31 * result + (this.vpcEndpointType != null ? this.vpcEndpointType.hashCode() : 0);
            return result;
        }
    }
}
