package software.amazon.awscdk.services.ec2;

/**
 * What class and generation of instance to use.
 * <p>
 * We have both symbolic and concrete enums for every type.
 * <p>
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-06-24T18:52:11.768Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.InstanceClass")
public enum InstanceClass {
    /**
     * Standard instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD3,
    /**
     * Standard instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD4,
    /**
     * Standard instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5,
    /**
     * Standard instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_NVME_DRIVE,
    /**
     * Standard instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_AMD,
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_AMD_NVME_DRIVE,
    /**
     * Memory optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY3,
    /**
     * Memory optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY4,
    /**
     * Memory optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5,
    /**
     * Memory optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_HIGH_PERFORMANCE,
    /**
     * Memory optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_NVME_DRIVE,
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_AMD,
    /**
     * Compute optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE3,
    /**
     * Compute optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE4,
    /**
     * Compute optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5,
    /**
     * Compute optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_NVME_DRIVE,
    /**
     * Compute optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_HIGH_PERFORMANCE,
    /**
     * Storage-optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE2,
    /**
     * Storage/compute balanced instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE_COMPUTE_1,
    /**
     * I/O-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO3,
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO3_DENSE_NVME_DRIVE,
    /**
     * Burstable instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE2,
    /**
     * Burstable instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE3,
    /**
     * Burstable instances based on AMD EPYC, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE3_AMD,
    /**
     * Memory-intensive instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_1,
    /**
     * Memory-intensive instances, extended, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_1_EXTENDED,
    /**
     * Instances with customizable hardware acceleration, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FPGA1,
    /**
     * Graphics-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS3,
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Parallel-processing optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL2,
    /**
     * Parallel-processing optimized instances, 3nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL3,
    /**
     * Arm processor based instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARM1,
    /**
     * Arm processor based instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_GRAVITON,
    /**
     * High memory and compute capacity instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_COMPUTE_MEMORY1,
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFERENCE1,
}
