package software.amazon.awscdk.services.ec2;

/**
 * Pair represents a gateway created by NAT Provider.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-01T08:46:36.386Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.GatewayConfig")
@software.amazon.jsii.Jsii.Proxy(GatewayConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GatewayConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Availability Zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAz();

    /**
     * Identity of gateway spawned by the provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGatewayId();

    /**
     * @return a {@link Builder} of {@link GatewayConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GatewayConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GatewayConfig> {
        private java.lang.String az;
        private java.lang.String gatewayId;

        /**
         * Sets the value of {@link GatewayConfig#getAz}
         * @param az Availability Zone. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder az(java.lang.String az) {
            this.az = az;
            return this;
        }

        /**
         * Sets the value of {@link GatewayConfig#getGatewayId}
         * @param gatewayId Identity of gateway spawned by the provider. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayId(java.lang.String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GatewayConfig build() {
            return new Jsii$Proxy(az, gatewayId);
        }
    }

    /**
     * An implementation for {@link GatewayConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayConfig {
        private final java.lang.String az;
        private final java.lang.String gatewayId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.az = this.jsiiGet("az", java.lang.String.class);
            this.gatewayId = this.jsiiGet("gatewayId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String az, final java.lang.String gatewayId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.az = java.util.Objects.requireNonNull(az, "az is required");
            this.gatewayId = java.util.Objects.requireNonNull(gatewayId, "gatewayId is required");
        }

        @Override
        public java.lang.String getAz() {
            return this.az;
        }

        @Override
        public java.lang.String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("az", om.valueToTree(this.getAz()));
            data.set("gatewayId", om.valueToTree(this.getGatewayId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.GatewayConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GatewayConfig.Jsii$Proxy that = (GatewayConfig.Jsii$Proxy) o;

            if (!az.equals(that.az)) return false;
            return this.gatewayId.equals(that.gatewayId);
        }

        @Override
        public int hashCode() {
            int result = this.az.hashCode();
            result = 31 * result + (this.gatewayId.hashCode());
            return result;
        }
    }
}
