package software.amazon.awscdk.services.ec2;

/**
 * Customize subnets that are selected for placement of ENIs.
 * <p>
 * Constructs that allow customization of VPC placement use parameters of this
 * type to provide placement settings.
 * <p>
 * By default, the instances are placed in the private subnets.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-01T08:46:36.430Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.SubnetSelection")
@software.amazon.jsii.Jsii.Proxy(SubnetSelection.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubnetSelection extends software.amazon.jsii.JsiiSerializable {

    /**
     * Select subnets only in the given AZs.
     * <p>
     * Default: no filtering on AZs is done
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
        return null;
    }

    /**
     * If true, return at most one subnet per AZ.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOnePerAz() {
        return null;
    }

    /**
     * Select the subnet group with the given name.
     * <p>
     * Select the subnet group with the given name. This only needs
     * to be used if you have multiple subnet groups of the same type
     * and you need to distinguish between them. Otherwise, prefer
     * <code>subnetType</code>.
     * <p>
     * This field does not select individual subnets, it selects all subnets that
     * share the given subnet group name. This is the name supplied in
     * <code>subnetConfiguration</code>.
     * <p>
     * At most one of <code>subnetType</code> and <code>subnetGroupName</code> can be supplied.
     * <p>
     * Default: - Selection by type instead of by name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetGroupName() {
        return null;
    }

    /**
     * Alias for `subnetGroupName`.
     * <p>
     * Select the subnet group with the given name. This only needs
     * to be used if you have multiple subnet groups of the same type
     * and you need to distinguish between them.
     * <p>
     * @deprecated Use `subnetGroupName` instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetName() {
        return null;
    }

    /**
     * Explicitly select individual subnets.
     * <p>
     * Use this if you don't want to automatically use all subnets in
     * a group, but have a need to control selection down to
     * individual subnets.
     * <p>
     * Cannot be specified together with <code>subnetType</code> or <code>subnetGroupName</code>.
     * <p>
     * Default: - Use all subnets in a selected group (all private subnets by default)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets() {
        return null;
    }

    /**
     * Select all subnets of the given type.
     * <p>
     * At most one of <code>subnetType</code> and <code>subnetGroupName</code> can be supplied.
     * <p>
     * Default: SubnetType.PRIVATE (or ISOLATED or PUBLIC if there are no PRIVATE subnets)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SubnetSelection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubnetSelection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubnetSelection> {
        private java.util.List<java.lang.String> availabilityZones;
        private java.lang.Boolean onePerAz;
        private java.lang.String subnetGroupName;
        private java.lang.String subnetName;
        private java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;
        private software.amazon.awscdk.services.ec2.SubnetType subnetType;

        /**
         * Sets the value of {@link SubnetSelection#getAvailabilityZones}
         * @param availabilityZones Select subnets only in the given AZs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of {@link SubnetSelection#getOnePerAz}
         * @param onePerAz If true, return at most one subnet per AZ.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onePerAz(java.lang.Boolean onePerAz) {
            this.onePerAz = onePerAz;
            return this;
        }

        /**
         * Sets the value of {@link SubnetSelection#getSubnetGroupName}
         * @param subnetGroupName Select the subnet group with the given name.
         *                        Select the subnet group with the given name. This only needs
         *                        to be used if you have multiple subnet groups of the same type
         *                        and you need to distinguish between them. Otherwise, prefer
         *                        <code>subnetType</code>.
         *                        <p>
         *                        This field does not select individual subnets, it selects all subnets that
         *                        share the given subnet group name. This is the name supplied in
         *                        <code>subnetConfiguration</code>.
         *                        <p>
         *                        At most one of <code>subnetType</code> and <code>subnetGroupName</code> can be supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroupName(java.lang.String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link SubnetSelection#getSubnetName}
         * @param subnetName Alias for `subnetGroupName`.
         *                   Select the subnet group with the given name. This only needs
         *                   to be used if you have multiple subnet groups of the same type
         *                   and you need to distinguish between them.
         * @return {@code this}
         * @deprecated Use `subnetGroupName` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder subnetName(java.lang.String subnetName) {
            this.subnetName = subnetName;
            return this;
        }

        /**
         * Sets the value of {@link SubnetSelection#getSubnets}
         * @param subnets Explicitly select individual subnets.
         *                Use this if you don't want to automatically use all subnets in
         *                a group, but have a need to control selection down to
         *                individual subnets.
         *                <p>
         *                Cannot be specified together with <code>subnetType</code> or <code>subnetGroupName</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Sets the value of {@link SubnetSelection#getSubnetType}
         * @param subnetType Select all subnets of the given type.
         *                   At most one of <code>subnetType</code> and <code>subnetGroupName</code> can be supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetType(software.amazon.awscdk.services.ec2.SubnetType subnetType) {
            this.subnetType = subnetType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetSelection}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubnetSelection build() {
            return new Jsii$Proxy(availabilityZones, onePerAz, subnetGroupName, subnetName, subnets, subnetType);
        }
    }

    /**
     * An implementation for {@link SubnetSelection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetSelection {
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.Boolean onePerAz;
        private final java.lang.String subnetGroupName;
        private final java.lang.String subnetName;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets;
        private final software.amazon.awscdk.services.ec2.SubnetType subnetType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.availabilityZones = this.jsiiGet("availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.onePerAz = this.jsiiGet("onePerAz", java.lang.Boolean.class);
            this.subnetGroupName = this.jsiiGet("subnetGroupName", java.lang.String.class);
            this.subnetName = this.jsiiGet("subnetName", java.lang.String.class);
            this.subnets = this.jsiiGet("subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class)));
            this.subnetType = this.jsiiGet("subnetType", software.amazon.awscdk.services.ec2.SubnetType.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.String> availabilityZones, final java.lang.Boolean onePerAz, final java.lang.String subnetGroupName, final java.lang.String subnetName, final java.util.List<software.amazon.awscdk.services.ec2.ISubnet> subnets, final software.amazon.awscdk.services.ec2.SubnetType subnetType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.availabilityZones = availabilityZones;
            this.onePerAz = onePerAz;
            this.subnetGroupName = subnetGroupName;
            this.subnetName = subnetName;
            this.subnets = subnets;
            this.subnetType = subnetType;
        }

        @Override
        public java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public java.lang.Boolean getOnePerAz() {
            return this.onePerAz;
        }

        @Override
        public java.lang.String getSubnetGroupName() {
            return this.subnetGroupName;
        }

        @Override
        public java.lang.String getSubnetName() {
            return this.subnetName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.ISubnet> getSubnets() {
            return this.subnets;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
            return this.subnetType;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAvailabilityZones() != null) {
                data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            }
            if (this.getOnePerAz() != null) {
                data.set("onePerAz", om.valueToTree(this.getOnePerAz()));
            }
            if (this.getSubnetGroupName() != null) {
                data.set("subnetGroupName", om.valueToTree(this.getSubnetGroupName()));
            }
            if (this.getSubnetName() != null) {
                data.set("subnetName", om.valueToTree(this.getSubnetName()));
            }
            if (this.getSubnets() != null) {
                data.set("subnets", om.valueToTree(this.getSubnets()));
            }
            if (this.getSubnetType() != null) {
                data.set("subnetType", om.valueToTree(this.getSubnetType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.SubnetSelection"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubnetSelection.Jsii$Proxy that = (SubnetSelection.Jsii$Proxy) o;

            if (this.availabilityZones != null ? !this.availabilityZones.equals(that.availabilityZones) : that.availabilityZones != null) return false;
            if (this.onePerAz != null ? !this.onePerAz.equals(that.onePerAz) : that.onePerAz != null) return false;
            if (this.subnetGroupName != null ? !this.subnetGroupName.equals(that.subnetGroupName) : that.subnetGroupName != null) return false;
            if (this.subnetName != null ? !this.subnetName.equals(that.subnetName) : that.subnetName != null) return false;
            if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) return false;
            return this.subnetType != null ? this.subnetType.equals(that.subnetType) : that.subnetType == null;
        }

        @Override
        public int hashCode() {
            int result = this.availabilityZones != null ? this.availabilityZones.hashCode() : 0;
            result = 31 * result + (this.onePerAz != null ? this.onePerAz.hashCode() : 0);
            result = 31 * result + (this.subnetGroupName != null ? this.subnetGroupName.hashCode() : 0);
            result = 31 * result + (this.subnetName != null ? this.subnetName.hashCode() : 0);
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            result = 31 * result + (this.subnetType != null ? this.subnetType.hashCode() : 0);
            return result;
        }
    }
}
