package software.amazon.awscdk.services.ec2;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-01T08:46:36.450Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.VpnConnectionProps")
@software.amazon.jsii.Jsii.Proxy(VpnConnectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpnConnectionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.VpnConnectionOptions {

    /**
     * The VPC to connect to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * @return a {@link Builder} of {@link VpnConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpnConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpnConnectionProps> {
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.lang.String ip;
        private java.lang.Number asn;
        private java.util.List<java.lang.String> staticRoutes;
        private java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> tunnelOptions;

        /**
         * Sets the value of {@link VpnConnectionProps#getVpc}
         * @param vpc The VPC to connect to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link VpnConnectionProps#getIp}
         * @param ip The ip address of the customer gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ip(java.lang.String ip) {
            this.ip = ip;
            return this;
        }

        /**
         * Sets the value of {@link VpnConnectionProps#getAsn}
         * @param asn The ASN of the customer gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder asn(java.lang.Number asn) {
            this.asn = asn;
            return this;
        }

        /**
         * Sets the value of {@link VpnConnectionProps#getStaticRoutes}
         * @param staticRoutes The static routes to be routed from the VPN gateway to the customer gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticRoutes(java.util.List<java.lang.String> staticRoutes) {
            this.staticRoutes = staticRoutes;
            return this;
        }

        /**
         * Sets the value of {@link VpnConnectionProps#getTunnelOptions}
         * @param tunnelOptions The tunnel options for the VPN connection.
         *                      At most two elements (one per tunnel).
         *                      Duplicates not allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tunnelOptions(java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> tunnelOptions) {
            this.tunnelOptions = tunnelOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpnConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpnConnectionProps build() {
            return new Jsii$Proxy(vpc, ip, asn, staticRoutes, tunnelOptions);
        }
    }

    /**
     * An implementation for {@link VpnConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpnConnectionProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.String ip;
        private final java.lang.Number asn;
        private final java.util.List<java.lang.String> staticRoutes;
        private final java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> tunnelOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.ip = this.jsiiGet("ip", java.lang.String.class);
            this.asn = this.jsiiGet("asn", java.lang.Number.class);
            this.staticRoutes = this.jsiiGet("staticRoutes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tunnelOptions = this.jsiiGet("tunnelOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.VpnTunnelOption.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.IVpc vpc, final java.lang.String ip, final java.lang.Number asn, final java.util.List<java.lang.String> staticRoutes, final java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> tunnelOptions) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.ip = java.util.Objects.requireNonNull(ip, "ip is required");
            this.asn = asn;
            this.staticRoutes = staticRoutes;
            this.tunnelOptions = tunnelOptions;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public java.lang.String getIp() {
            return this.ip;
        }

        @Override
        public java.lang.Number getAsn() {
            return this.asn;
        }

        @Override
        public java.util.List<java.lang.String> getStaticRoutes() {
            return this.staticRoutes;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.VpnTunnelOption> getTunnelOptions() {
            return this.tunnelOptions;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            data.set("ip", om.valueToTree(this.getIp()));
            if (this.getAsn() != null) {
                data.set("asn", om.valueToTree(this.getAsn()));
            }
            if (this.getStaticRoutes() != null) {
                data.set("staticRoutes", om.valueToTree(this.getStaticRoutes()));
            }
            if (this.getTunnelOptions() != null) {
                data.set("tunnelOptions", om.valueToTree(this.getTunnelOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.VpnConnectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpnConnectionProps.Jsii$Proxy that = (VpnConnectionProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (!ip.equals(that.ip)) return false;
            if (this.asn != null ? !this.asn.equals(that.asn) : that.asn != null) return false;
            if (this.staticRoutes != null ? !this.staticRoutes.equals(that.staticRoutes) : that.staticRoutes != null) return false;
            return this.tunnelOptions != null ? this.tunnelOptions.equals(that.tunnelOptions) : that.tunnelOptions == null;
        }

        @Override
        public int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.ip.hashCode());
            result = 31 * result + (this.asn != null ? this.asn.hashCode() : 0);
            result = 31 * result + (this.staticRoutes != null ? this.staticRoutes.hashCode() : 0);
            result = 31 * result + (this.tunnelOptions != null ? this.tunnelOptions.hashCode() : 0);
            return result;
        }
    }
}
