package software.amazon.awscdk.services.ec2;

/**
 * Construction properties for a GatewayVpcEndpoint.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-07-02T12:03:16.149Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.GatewayVpcEndpointProps")
@software.amazon.jsii.Jsii.Proxy(GatewayVpcEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GatewayVpcEndpointProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.GatewayVpcEndpointOptions {

    /**
     * The VPC network in which the gateway endpoint will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * @return a {@link Builder} of {@link GatewayVpcEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GatewayVpcEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GatewayVpcEndpointProps> {
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService service;
        private java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets;

        /**
         * Sets the value of {@link GatewayVpcEndpointProps#getVpc}
         * @param vpc The VPC network in which the gateway endpoint will be used. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link GatewayVpcEndpointProps#getService}
         * @param service The service to use for this gateway VPC endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link GatewayVpcEndpointProps#getSubnets}
         * @param subnets Where to add endpoint routing.
         *                By default, this endpoint will be routable from all subnets in the VPC.
         *                Specify a list of subnet selection objects here to be more specific.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayVpcEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GatewayVpcEndpointProps build() {
            return new Jsii$Proxy(vpc, service, subnets);
        }
    }

    /**
     * An implementation for {@link GatewayVpcEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayVpcEndpointProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService service;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.service = this.jsiiGet("service", software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService.class);
            this.subnets = this.jsiiGet("subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.IVpc vpc, final software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService service, final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> subnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.service = java.util.Objects.requireNonNull(service, "service is required");
            this.subnets = subnets;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IGatewayVpcEndpointService getService() {
            return this.service;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getSubnets() {
            return this.subnets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            data.set("service", om.valueToTree(this.getService()));
            if (this.getSubnets() != null) {
                data.set("subnets", om.valueToTree(this.getSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ec2.GatewayVpcEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GatewayVpcEndpointProps.Jsii$Proxy that = (GatewayVpcEndpointProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (!service.equals(that.service)) return false;
            return this.subnets != null ? this.subnets.equals(that.subnets) : that.subnets == null;
        }

        @Override
        public int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.service.hashCode());
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            return result;
        }
    }
}
