package software.amazon.awscdk.services.ec2;

/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-21T10:50:03.076Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ec2.$Module.class, fqn = "@aws-cdk/aws-ec2.CfnClientVpnEndpoint")
public class CfnClientVpnEndpoint extends software.amazon.awscdk.core.CfnResource {

    protected CfnClientVpnEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnClientVpnEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::EC2::ClientVpnEndpoint`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnClientVpnEndpoint(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.ec2.CfnClientVpnEndpointProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getAuthenticationOptions() {
        return this.jsiiGet("authenticationOptions", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthenticationOptions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("authenticationOptions", java.util.Objects.requireNonNull(value, "authenticationOptions is required"));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthenticationOptions(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("authenticationOptions", java.util.Objects.requireNonNull(value, "authenticationOptions is required"));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getClientCidrBlock() {
        return this.jsiiGet("clientCidrBlock", java.lang.String.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setClientCidrBlock(final java.lang.String value) {
        this.jsiiSet("clientCidrBlock", java.util.Objects.requireNonNull(value, "clientCidrBlock is required"));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getConnectionLogOptions() {
        return this.jsiiGet("connectionLogOptions", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setConnectionLogOptions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("connectionLogOptions", java.util.Objects.requireNonNull(value, "connectionLogOptions is required"));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setConnectionLogOptions(final software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty value) {
        this.jsiiSet("connectionLogOptions", java.util.Objects.requireNonNull(value, "connectionLogOptions is required"));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getServerCertificateArn() {
        return this.jsiiGet("serverCertificateArn", java.lang.String.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setServerCertificateArn(final java.lang.String value) {
        this.jsiiSet("serverCertificateArn", java.util.Objects.requireNonNull(value, "serverCertificateArn is required"));
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(final java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.DnsServers`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getDnsServers() {
        return this.jsiiGet("dnsServers", java.util.List.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.DnsServers`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDnsServers(final java.util.List<java.lang.String> value) {
        this.jsiiSet("dnsServers", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getSplitTunnel() {
        return this.jsiiGet("splitTunnel", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSplitTunnel(final java.lang.Boolean value) {
        this.jsiiSet("splitTunnel", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSplitTunnel(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("splitTunnel", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getTagSpecifications() {
        return this.jsiiGet("tagSpecifications", java.lang.Object.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTagSpecifications(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("tagSpecifications", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTagSpecifications(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("tagSpecifications", value);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getTransportProtocol() {
        return this.jsiiGet("transportProtocol", java.lang.String.class);
    }

    /**
     * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTransportProtocol(final java.lang.String value) {
        this.jsiiSet("transportProtocol", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-certificateauthenticationrequest.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CertificateAuthenticationRequestProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty.ClientRootCertificateChainArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-certificateauthenticationrequest.html#cfn-ec2-clientvpnendpoint-certificateauthenticationrequest-clientrootcertificatechainarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getClientRootCertificateChainArn();

        /**
         * @return a {@link Builder} of {@link CertificateAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CertificateAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String clientRootCertificateChainArn;

            /**
             * Sets the value of ClientRootCertificateChainArn
             * @param clientRootCertificateChainArn `CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty.ClientRootCertificateChainArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder clientRootCertificateChainArn(java.lang.String clientRootCertificateChainArn) {
                this.clientRootCertificateChainArn = clientRootCertificateChainArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateAuthenticationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CertificateAuthenticationRequestProperty build() {
                return new Jsii$Proxy(clientRootCertificateChainArn);
            }

        }

        /**
         * An implementation for {@link CertificateAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateAuthenticationRequestProperty {
            private final java.lang.String clientRootCertificateChainArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.clientRootCertificateChainArn = this.jsiiGet("clientRootCertificateChainArn", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String clientRootCertificateChainArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientRootCertificateChainArn = java.util.Objects.requireNonNull(clientRootCertificateChainArn, "clientRootCertificateChainArn is required");
            }

            @Override
            public java.lang.String getClientRootCertificateChainArn() {
                return this.clientRootCertificateChainArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("clientRootCertificateChainArn", om.valueToTree(this.getClientRootCertificateChainArn()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CertificateAuthenticationRequestProperty.Jsii$Proxy that = (CertificateAuthenticationRequestProperty.Jsii$Proxy) o;

                return this.clientRootCertificateChainArn.equals(that.clientRootCertificateChainArn);
            }

            @Override
            public int hashCode() {
                int result = this.clientRootCertificateChainArn.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ClientAuthenticationRequestProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.ActiveDirectory`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-activedirectory
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getActiveDirectory();

        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.MutualAuthentication`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-mutualauthentication
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getMutualAuthentication();

        /**
         * @return a {@link Builder} of {@link ClientAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ClientAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String type;
            private java.lang.Object activeDirectory;
            private java.lang.Object mutualAuthentication;

            /**
             * Sets the value of Type
             * @param type `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of ActiveDirectory
             * @param activeDirectory `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.ActiveDirectory`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder activeDirectory(software.amazon.awscdk.core.IResolvable activeDirectory) {
                this.activeDirectory = activeDirectory;
                return this;
            }

            /**
             * Sets the value of ActiveDirectory
             * @param activeDirectory `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.ActiveDirectory`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder activeDirectory(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty activeDirectory) {
                this.activeDirectory = activeDirectory;
                return this;
            }

            /**
             * Sets the value of MutualAuthentication
             * @param mutualAuthentication `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.MutualAuthentication`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder mutualAuthentication(software.amazon.awscdk.core.IResolvable mutualAuthentication) {
                this.mutualAuthentication = mutualAuthentication;
                return this;
            }

            /**
             * Sets the value of MutualAuthentication
             * @param mutualAuthentication `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.MutualAuthentication`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder mutualAuthentication(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty mutualAuthentication) {
                this.mutualAuthentication = mutualAuthentication;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientAuthenticationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ClientAuthenticationRequestProperty build() {
                return new Jsii$Proxy(type, activeDirectory, mutualAuthentication);
            }

        }

        /**
         * An implementation for {@link ClientAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientAuthenticationRequestProperty {
            private final java.lang.String type;
            private final java.lang.Object activeDirectory;
            private final java.lang.Object mutualAuthentication;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.activeDirectory = this.jsiiGet("activeDirectory", java.lang.Object.class);
                this.mutualAuthentication = this.jsiiGet("mutualAuthentication", java.lang.Object.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String type, java.lang.Object activeDirectory, java.lang.Object mutualAuthentication) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(type, "type is required");
                this.activeDirectory = activeDirectory;
                this.mutualAuthentication = mutualAuthentication;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.Object getActiveDirectory() {
                return this.activeDirectory;
            }

            @Override
            public java.lang.Object getMutualAuthentication() {
                return this.mutualAuthentication;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("type", om.valueToTree(this.getType()));
                if (this.getActiveDirectory() != null) {
                    obj.set("activeDirectory", om.valueToTree(this.getActiveDirectory()));
                }
                if (this.getMutualAuthentication() != null) {
                    obj.set("mutualAuthentication", om.valueToTree(this.getMutualAuthentication()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientAuthenticationRequestProperty.Jsii$Proxy that = (ClientAuthenticationRequestProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.activeDirectory != null ? !this.activeDirectory.equals(that.activeDirectory) : that.activeDirectory != null) return false;
                return this.mutualAuthentication != null ? this.mutualAuthentication.equals(that.mutualAuthentication) : that.mutualAuthentication == null;
            }

            @Override
            public int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.activeDirectory != null ? this.activeDirectory.hashCode() : 0);
                result = 31 * result + (this.mutualAuthentication != null ? this.mutualAuthentication.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ConnectionLogOptionsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogGroup`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-cloudwatchloggroup
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCloudwatchLogGroup();

        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogStream`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-cloudwatchlogstream
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCloudwatchLogStream();

        /**
         * @return a {@link Builder} of {@link ConnectionLogOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ConnectionLogOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.Object enabled;
            private java.lang.String cloudwatchLogGroup;
            private java.lang.String cloudwatchLogStream;

            /**
             * Sets the value of Enabled
             * @param enabled `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of CloudwatchLogGroup
             * @param cloudwatchLogGroup `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogGroup`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cloudwatchLogGroup(java.lang.String cloudwatchLogGroup) {
                this.cloudwatchLogGroup = cloudwatchLogGroup;
                return this;
            }

            /**
             * Sets the value of CloudwatchLogStream
             * @param cloudwatchLogStream `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogStream`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cloudwatchLogStream(java.lang.String cloudwatchLogStream) {
                this.cloudwatchLogStream = cloudwatchLogStream;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionLogOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ConnectionLogOptionsProperty build() {
                return new Jsii$Proxy(enabled, cloudwatchLogGroup, cloudwatchLogStream);
            }

        }

        /**
         * An implementation for {@link ConnectionLogOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionLogOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String cloudwatchLogGroup;
            private final java.lang.String cloudwatchLogStream;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.cloudwatchLogGroup = this.jsiiGet("cloudwatchLogGroup", java.lang.String.class);
                this.cloudwatchLogStream = this.jsiiGet("cloudwatchLogStream", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Object enabled, java.lang.String cloudwatchLogGroup, java.lang.String cloudwatchLogStream) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.cloudwatchLogGroup = cloudwatchLogGroup;
                this.cloudwatchLogStream = cloudwatchLogStream;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.lang.String getCloudwatchLogGroup() {
                return this.cloudwatchLogGroup;
            }

            @Override
            public java.lang.String getCloudwatchLogStream() {
                return this.cloudwatchLogStream;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getCloudwatchLogGroup() != null) {
                    obj.set("cloudwatchLogGroup", om.valueToTree(this.getCloudwatchLogGroup()));
                }
                if (this.getCloudwatchLogStream() != null) {
                    obj.set("cloudwatchLogStream", om.valueToTree(this.getCloudwatchLogStream()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionLogOptionsProperty.Jsii$Proxy that = (ConnectionLogOptionsProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.cloudwatchLogGroup != null ? !this.cloudwatchLogGroup.equals(that.cloudwatchLogGroup) : that.cloudwatchLogGroup != null) return false;
                return this.cloudwatchLogStream != null ? this.cloudwatchLogStream.equals(that.cloudwatchLogStream) : that.cloudwatchLogStream == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.cloudwatchLogGroup != null ? this.cloudwatchLogGroup.hashCode() : 0);
                result = 31 * result + (this.cloudwatchLogStream != null ? this.cloudwatchLogStream.hashCode() : 0);
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-directoryserviceauthenticationrequest.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DirectoryServiceAuthenticationRequestProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty.DirectoryId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-directoryserviceauthenticationrequest.html#cfn-ec2-clientvpnendpoint-directoryserviceauthenticationrequest-directoryid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getDirectoryId();

        /**
         * @return a {@link Builder} of {@link DirectoryServiceAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link DirectoryServiceAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String directoryId;

            /**
             * Sets the value of DirectoryId
             * @param directoryId `CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty.DirectoryId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder directoryId(java.lang.String directoryId) {
                this.directoryId = directoryId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DirectoryServiceAuthenticationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DirectoryServiceAuthenticationRequestProperty build() {
                return new Jsii$Proxy(directoryId);
            }

        }

        /**
         * An implementation for {@link DirectoryServiceAuthenticationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DirectoryServiceAuthenticationRequestProperty {
            private final java.lang.String directoryId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.directoryId = this.jsiiGet("directoryId", java.lang.String.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String directoryId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.directoryId = java.util.Objects.requireNonNull(directoryId, "directoryId is required");
            }

            @Override
            public java.lang.String getDirectoryId() {
                return this.directoryId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("directoryId", om.valueToTree(this.getDirectoryId()));
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DirectoryServiceAuthenticationRequestProperty.Jsii$Proxy that = (DirectoryServiceAuthenticationRequestProperty.Jsii$Proxy) o;

                return this.directoryId.equals(that.directoryId);
            }

            @Override
            public int hashCode() {
                int result = this.directoryId.hashCode();
                return result;
            }

        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnClientVpnEndpoint.TagSpecificationProperty.ResourceType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html#cfn-ec2-clientvpnendpoint-tagspecification-resourcetype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceType();

        /**
         * `CfnClientVpnEndpoint.TagSpecificationProperty.Tags`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html#cfn-ec2-clientvpnendpoint-tagspecification-tags
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

        /**
         * @return a {@link Builder} of {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Builder {
            private java.lang.String resourceType;
            private java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Sets the value of ResourceType
             * @param resourceType `CfnClientVpnEndpoint.TagSpecificationProperty.ResourceType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of Tags
             * @param tags `CfnClientVpnEndpoint.TagSpecificationProperty.Tags`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TagSpecificationProperty build() {
                return new Jsii$Proxy(resourceType, tags);
            }

        }

        /**
         * An implementation for {@link TagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.resourceType = this.jsiiGet("resourceType", java.lang.String.class);
                this.tags = this.jsiiGet("tags", java.util.List.class);
            }


            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String resourceType, java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = resourceType;
                this.tags = tags;
            }

            @Override
            public java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getResourceType() != null) {
                    obj.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getTags() != null) {
                    obj.set("tags", om.valueToTree(this.getTags()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagSpecificationProperty.Jsii$Proxy that = (TagSpecificationProperty.Jsii$Proxy) o;

                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public int hashCode() {
                int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }

        }
    }
}
