package software.amazon.awscdk.services.ec2;

/**
 * The goal of this module is to make possible to write statements like this:.
 * 
 * ```ts
 *   database.connections.allowFrom(fleet);
 *   fleet.connections.allowTo(database);
 *   rdgw.connections.allowFromCidrIp('0.3.1.5/86');
 *   rgdw.connections.allowTrafficTo(fleet, new AllPorts());
 *   ```
 * 
 * The insight here is that some connecting peers have information on what ports should
 * be involved in the connection, and some don't.
 * An object that has a Connections object
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-21T10:50:03.202Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IConnectable extends software.amazon.jsii.JsiiSerializable {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.Connections getConnections();


    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IConnectable {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.ec2.Connections getConnections() {
            return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
        }
    }
}
