package software.amazon.awscdk.services.ec2;

/**
 * Customize subnets that are selected for placement of ENIs.
 * 
 * Constructs that allow customization of VPC placement use parameters of this
 * type to provide placement settings.
 * 
 * By default, the instances are placed in the private subnets.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.15.1 (build ceff2ca)", date = "2019-08-21T10:50:03.226Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubnetSelection extends software.amazon.jsii.JsiiSerializable {
    /**
     * If true, return at most one subnet per AZ.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getOnePerAz();

    /**
     * Place the instances in the subnets with the given name.
     * 
     * (This is the name supplied in subnetConfiguration).
     * 
     * At most one of `subnetType` and `subnetName` can be supplied.
     * 
     * Default: name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getSubnetName();

    /**
     * Place the instances in the subnets of the given type.
     * 
     * At most one of `subnetType` and `subnetName` can be supplied.
     * 
     * Default: SubnetType.PRIVATE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.SubnetType getSubnetType();

    /**
     * @return a {@link Builder} of {@link SubnetSelection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SubnetSelection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.Boolean onePerAz;
        private java.lang.String subnetName;
        private software.amazon.awscdk.services.ec2.SubnetType subnetType;

        /**
         * Sets the value of OnePerAz
         * @param onePerAz If true, return at most one subnet per AZ.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onePerAz(java.lang.Boolean onePerAz) {
            this.onePerAz = onePerAz;
            return this;
        }

        /**
         * Sets the value of SubnetName
         * @param subnetName Place the instances in the subnets with the given name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetName(java.lang.String subnetName) {
            this.subnetName = subnetName;
            return this;
        }

        /**
         * Sets the value of SubnetType
         * @param subnetType Place the instances in the subnets of the given type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetType(software.amazon.awscdk.services.ec2.SubnetType subnetType) {
            this.subnetType = subnetType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetSelection}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public SubnetSelection build() {
            return new Jsii$Proxy(onePerAz, subnetName, subnetType);
        }

    }

    /**
     * An implementation for {@link SubnetSelection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetSelection {
        private final java.lang.Boolean onePerAz;
        private final java.lang.String subnetName;
        private final software.amazon.awscdk.services.ec2.SubnetType subnetType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.onePerAz = this.jsiiGet("onePerAz", java.lang.Boolean.class);
            this.subnetName = this.jsiiGet("subnetName", java.lang.String.class);
            this.subnetType = this.jsiiGet("subnetType", software.amazon.awscdk.services.ec2.SubnetType.class);
        }


        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Boolean onePerAz, java.lang.String subnetName, software.amazon.awscdk.services.ec2.SubnetType subnetType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.onePerAz = onePerAz;
            this.subnetName = subnetName;
            this.subnetType = subnetType;
        }

        @Override
        public java.lang.Boolean getOnePerAz() {
            return this.onePerAz;
        }

        @Override
        public java.lang.String getSubnetName() {
            return this.subnetName;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetType getSubnetType() {
            return this.subnetType;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getOnePerAz() != null) {
                obj.set("onePerAz", om.valueToTree(this.getOnePerAz()));
            }
            if (this.getSubnetName() != null) {
                obj.set("subnetName", om.valueToTree(this.getSubnetName()));
            }
            if (this.getSubnetType() != null) {
                obj.set("subnetType", om.valueToTree(this.getSubnetType()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubnetSelection.Jsii$Proxy that = (SubnetSelection.Jsii$Proxy) o;

            if (this.onePerAz != null ? !this.onePerAz.equals(that.onePerAz) : that.onePerAz != null) return false;
            if (this.subnetName != null ? !this.subnetName.equals(that.subnetName) : that.subnetName != null) return false;
            return this.subnetType != null ? this.subnetType.equals(that.subnetType) : that.subnetType == null;
        }

        @Override
        public int hashCode() {
            int result = this.onePerAz != null ? this.onePerAz.hashCode() : 0;
            result = 31 * result + (this.subnetName != null ? this.subnetName.hashCode() : 0);
            result = 31 * result + (this.subnetType != null ? this.subnetType.hashCode() : 0);
            return result;
        }

    }
}
