/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint;
import software.amazon.awscdk.services.ec2.CfnClientVpnEndpointProps;
import software.amazon.jsii.JsiiSerializable;

public interface CfnClientVpnEndpointProps
extends JsiiSerializable {
    public Object getAuthenticationOptions();

    public String getClientCidrBlock();

    public Object getConnectionLogOptions();

    public String getServerCertificateArn();

    public String getDescription();

    public List<String> getDnsServers();

    public Object getSplitTunnel();

    public Object getTagSpecifications();

    public String getTransportProtocol();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Object authenticationOptions;
        private String clientCidrBlock;
        private Object connectionLogOptions;
        private String serverCertificateArn;
        private String description;
        private List<String> dnsServers;
        private Object splitTunnel;
        private Object tagSpecifications;
        private String transportProtocol;

        public Builder authenticationOptions(IResolvable authenticationOptions) {
            this.authenticationOptions = authenticationOptions;
            return this;
        }

        public Builder authenticationOptions(List<Object> authenticationOptions) {
            this.authenticationOptions = authenticationOptions;
            return this;
        }

        public Builder clientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
            return this;
        }

        public Builder connectionLogOptions(IResolvable connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public Builder connectionLogOptions(CfnClientVpnEndpoint.ConnectionLogOptionsProperty connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder dnsServers(List<String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        public Builder splitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        public Builder splitTunnel(IResolvable splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        public Builder tagSpecifications(IResolvable tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        public Builder tagSpecifications(List<Object> tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        public Builder transportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        public CfnClientVpnEndpointProps build() {
            return new Jsii.Proxy(this.authenticationOptions, this.clientCidrBlock, this.connectionLogOptions, this.serverCertificateArn, this.description, this.dnsServers, this.splitTunnel, this.tagSpecifications, this.transportProtocol, null);
        }
    }
}

